/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class STCoreRegionString
implements CharSequence {
    private static final Pattern REGION_SPLIT = Pattern.compile(",\\s*");
    private static final Pattern REGION_PATTERN = Pattern.compile("\\[([-+]?\\d+):([-+]?\\d+)\\]");
    private final StringBuilder buffer;
    private final List<ITextRegion> regions = new ArrayList<ITextRegion>();

    public STCoreRegionString() {
        this.buffer = new StringBuilder();
    }

    public STCoreRegionString(String str) {
        this.buffer = new StringBuilder(str);
    }

    public STCoreRegionString(CharSequence str) {
        this.buffer = new StringBuilder(str);
    }

    public STCoreRegionString(String str, boolean region) {
        this.buffer = new StringBuilder(str);
        if (region) {
            this.regions.add((ITextRegion)new TextRegion(0, str.length()));
        }
    }

    public STCoreRegionString(CharSequence str, boolean region) {
        this.buffer = new StringBuilder(str);
        if (region) {
            this.regions.add((ITextRegion)new TextRegion(0, str.length()));
        }
    }

    public STCoreRegionString append(char c) {
        this.buffer.append(c);
        return this;
    }

    public STCoreRegionString append(CharSequence s) {
        this.buffer.append(s);
        return this;
    }

    public STCoreRegionString append(char c, boolean region) {
        if (region) {
            this.regions.add((ITextRegion)new TextRegion(this.length(), 1));
        }
        this.buffer.append(c);
        return this;
    }

    public STCoreRegionString append(CharSequence s, boolean region) {
        if (region) {
            this.regions.add((ITextRegion)new TextRegion(this.length(), s.length()));
        }
        this.buffer.append(s);
        return this;
    }

    public STCoreRegionString addRegion(ITextRegion region) {
        if (region.getOffset() < 0 || region.getOffset() + region.getLength() > this.length()) {
            throw new IllegalArgumentException();
        }
        this.regions.add(region);
        return this;
    }

    public STCoreRegionString concat(STCoreRegionString other) {
        this.regions.addAll(other.getRegions(this.length()));
        this.buffer.append((CharSequence)other.buffer);
        return this;
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer.subSequence(start, end);
    }

    public List<ITextRegion> getRegions() {
        return this.regions;
    }

    public List<ITextRegion> getRegions(int offset) {
        if (offset == 0) {
            return this.getRegions();
        }
        return this.regions.stream().map(region -> new TextRegion(offset + region.getOffset(), region.getLength())).toList();
    }

    public static List<ITextRegion> parseRegions(String string) {
        return STCoreRegionString.parseRegions(string, 0);
    }

    public static List<ITextRegion> parseRegions(String string, int offset) {
        if (string.length() < 2 || string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
            throw new IllegalArgumentException("Invalid regions string: " + string);
        }
        if (string.length() == 2) {
            return Collections.emptyList();
        }
        return REGION_SPLIT.splitAsStream(string.substring(1, string.length() - 1)).map(s -> STCoreRegionString.parseRegion(s, offset)).toList();
    }

    public static ITextRegion parseRegion(String string) {
        return STCoreRegionString.parseRegion(string, 0);
    }

    public static ITextRegion parseRegion(String string, int offset) {
        Matcher matcher = REGION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid region string: " + string);
        }
        return new TextRegion(offset + Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

