/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.datatype.helper.RetainHelper;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;

public class ChangeRetainAttributeCommand
extends Command
implements ScopedCommand {
    private final IInterfaceElement pin;
    private final RetainHelper.RetainTag oldValue;
    private final RetainHelper.RetainTag newValue;

    public ChangeRetainAttributeCommand(IInterfaceElement pin, RetainHelper.RetainTag oldValue, RetainHelper.RetainTag newValue) {
        this.pin = pin;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.pin);
    }

    public void execute() {
        if (ChangeRetainAttributeCommand.isTagged(this.oldValue) && !ChangeRetainAttributeCommand.isTagged(this.newValue) && this.pin.getAttribute("Retain") != null) {
            this.pin.deleteAttribute("Retain");
            return;
        }
        if (ChangeRetainAttributeCommand.isTagged(this.newValue)) {
            this.pin.setAttribute(InternalAttributeDeclarations.RETAIN, this.newValue.getString(), "");
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (!ChangeRetainAttributeCommand.isTagged(this.oldValue)) {
            this.pin.setAttribute(InternalAttributeDeclarations.RETAIN, this.oldValue.getString(), "");
        } else if (this.pin.getAttribute("Retain") != null) {
            this.pin.deleteAttribute("Retain");
        }
    }

    private static boolean isTagged(RetainHelper.RetainTag tag) {
        return tag != RetainHelper.RetainTag.NOTHING;
    }
}

