/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.export.forte_lua.filter.LuaUtils;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class LuaConstants {
    private static final int FB_STATE = 0;
    private static final int FB_DI_FLAG = 0x2000000;
    private static final int FB_DO_FLAG = 0x4000000;
    private static final int FB_AD_FLAG = 0x8000000;
    private static final int FB_ADI_FLAG = 0xA000000;
    private static final int FB_ADO_FLAG = 0xC000000;
    private static final int FB_IN_FLAG = 0x10000000;
    private static final int WITH_DELIMITER = 65535;

    public static CharSequence luaTypeName(FBType type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FORTE_");
        String _name = type.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaStateVariable() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("STATE");
        return _builder;
    }

    public static CharSequence luaFBStateVarName() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("FB_STATE");
        return _builder;
    }

    public static CharSequence luaStateName(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ECC_");
        String _name = state.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaInputEventName(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        FBNetworkElement _fBNetworkElement = event.getFBNetworkElement();
        if (_fBNetworkElement instanceof AdapterFB) {
            _builder.append("AEI_");
            String _name = event.getFBNetworkElement().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = event.getName();
            _builder.append(_name_1);
        } else {
            _builder.append("EI_");
            String _name_2 = event.getName();
            _builder.append(_name_2);
        }
        return _builder;
    }

    public static CharSequence luaOutputEventName(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        FBNetworkElement _fBNetworkElement = event.getFBNetworkElement();
        if (_fBNetworkElement instanceof AdapterFB) {
            _builder.append("AEO_");
            String _name = event.getFBNetworkElement().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = event.getName();
            _builder.append(_name_1);
        } else {
            _builder.append("EO_");
            String _name_2 = event.getName();
            _builder.append(_name_2);
        }
        return _builder;
    }

    public static CharSequence luaAdapterInputEventName(Event event, String adapterName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("AEI_");
        _builder.append(adapterName);
        _builder.append("_");
        String _name = event.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaAdapterOutputEventName(Event event, String adapterName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("AEO_");
        _builder.append(adapterName);
        _builder.append("_");
        String _name = event.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBInputVarName(VarDeclaration decl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DI_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBOutputVarName(VarDeclaration decl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("DO_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBAdapterInputVarName(VarDeclaration decl, String adapterName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADI_");
        _builder.append(adapterName);
        _builder.append("_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBAdapterOutputVarName(VarDeclaration decl, String adapterName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ADO_");
        _builder.append(adapterName);
        _builder.append("_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBInternalVarName(VarDeclaration decl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("IN_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaVariable(VarDeclaration decl) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("VAR_");
        String _name = decl.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaAdapterVariable(String name, String adapterInstanceName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("VAR_");
        _builder.append(adapterInstanceName);
        _builder.append("_");
        _builder.append(name);
        return _builder;
    }

    public static CharSequence luaAlgorithmName(Algorithm alg) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("alg_");
        String _name = alg.getName();
        _builder.append(_name);
        return _builder;
    }

    public static CharSequence luaFBStateConstant() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local ");
        CharSequence _luaFBStateVarName = LuaConstants.luaFBStateVarName();
        _builder.append((Object)_luaFBStateVarName);
        _builder.append(" = ");
        _builder.append((Object)0);
        return _builder;
    }

    public static CharSequence luaStateConstants(ECC ecc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ecc.getECState();
        for (ECState state : _eCState) {
            _builder.append("local ");
            CharSequence _luaStateName = LuaConstants.luaStateName(state);
            _builder.append((Object)_luaStateName);
            _builder.append(" = ");
            int _indexOf = ecc.getECState().indexOf((Object)state);
            _builder.append((Object)_indexOf);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaEventConstants(InterfaceList ifl) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eventInputs = ifl.getEventInputs();
        for (Event event : _eventInputs) {
            _builder.append("local ");
            CharSequence _luaInputEventName = LuaConstants.luaInputEventName(event);
            _builder.append((Object)_luaInputEventName);
            _builder.append(" = ");
            int _indexOf = ifl.getEventInputs().indexOf((Object)event);
            _builder.append((Object)_indexOf);
            _builder.newLineIfNotEmpty();
        }
        EList _eventOutputs = ifl.getEventOutputs();
        for (Event event_1 : _eventOutputs) {
            _builder.append("local ");
            CharSequence _luaOutputEventName = LuaConstants.luaOutputEventName(event_1);
            _builder.append((Object)_luaOutputEventName);
            _builder.append(" = ");
            int _indexOf_1 = ifl.getEventOutputs().indexOf((Object)event_1);
            _builder.append((Object)_indexOf_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaFBVariableConstants(InterfaceList ifl) {
        StringConcatenation _builder = new StringConcatenation();
        EList _inputVars = ifl.getInputVars();
        for (VarDeclaration decl : _inputVars) {
            _builder.append("local ");
            CharSequence _luaFBInputVarName = LuaConstants.luaFBInputVarName(decl);
            _builder.append((Object)_luaFBInputVarName);
            _builder.append(" = ");
            _builder.append((Object)(0x2000000 | ifl.getInputVars().indexOf((Object)decl)));
            _builder.newLineIfNotEmpty();
        }
        EList _outputVars = ifl.getOutputVars();
        for (VarDeclaration decl_1 : _outputVars) {
            _builder.append("local ");
            CharSequence _luaFBOutputVarName = LuaConstants.luaFBOutputVarName(decl_1);
            _builder.append((Object)_luaFBOutputVarName);
            _builder.append(" = ");
            _builder.append((Object)(0x4000000 | ifl.getOutputVars().indexOf((Object)decl_1)));
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaFBAdapterConstants(InterfaceList ifl) {
        StringConcatenation _builder = new StringConcatenation();
        EList _sockets = ifl.getSockets();
        for (AdapterDeclaration socket : _sockets) {
            CharSequence _luaFBAdapterInterfaceConstants = LuaConstants.luaFBAdapterInterfaceConstants(socket, ifl.getSockets(), ifl.getPlugs().size());
            _builder.append((Object)_luaFBAdapterInterfaceConstants);
            _builder.newLineIfNotEmpty();
        }
        EList _plugs = ifl.getPlugs();
        for (AdapterDeclaration plug : _plugs) {
            CharSequence _luaFBAdapterInterfaceConstants_1 = LuaConstants.luaFBAdapterInterfaceConstants(plug, ifl.getPlugs(), 0);
            _builder.append((Object)_luaFBAdapterInterfaceConstants_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaFBAdapterInterfaceConstants(AdapterDeclaration adapter, EList<?> ifl, int offset) {
        StringConcatenation _builder = new StringConcatenation();
        InterfaceList aifl = LuaConstants.getAdapterInterfaceList(adapter);
        _builder.append("\t\t");
        _builder.newLineIfNotEmpty();
        int _indexOf = ifl.indexOf((Object)adapter);
        int adapterID = _indexOf + offset;
        _builder.newLineIfNotEmpty();
        EList _eventOutputs = aifl.getEventOutputs();
        for (Event decl : _eventOutputs) {
            _builder.append("local ");
            CharSequence _luaAdapterOutputEventName = LuaConstants.luaAdapterOutputEventName(decl, adapter.getName());
            _builder.append((Object)_luaAdapterOutputEventName);
            _builder.append(" = ");
            _builder.append((Object)(0x8000000 | adapterID << 16 | aifl.getEventOutputs().indexOf((Object)decl)));
            _builder.newLineIfNotEmpty();
        }
        EList _eventInputs = aifl.getEventInputs();
        for (Event decl_1 : _eventInputs) {
            _builder.append("local ");
            CharSequence _luaAdapterInputEventName = LuaConstants.luaAdapterInputEventName(decl_1, adapter.getName());
            _builder.append((Object)_luaAdapterInputEventName);
            _builder.append(" = ");
            _builder.append((Object)(0x8000000 | adapterID << 16 | aifl.getEventInputs().indexOf((Object)decl_1)));
            _builder.newLineIfNotEmpty();
        }
        EList _outputVars = aifl.getOutputVars();
        for (VarDeclaration decl_2 : _outputVars) {
            _builder.append("local ");
            CharSequence _luaFBAdapterOutputVarName = LuaConstants.luaFBAdapterOutputVarName(decl_2, adapter.getName());
            _builder.append((Object)_luaFBAdapterOutputVarName);
            _builder.append(" = ");
            _builder.append((Object)(0xA000000 | adapterID << 16 | aifl.getOutputVars().indexOf((Object)decl_2)));
            _builder.newLineIfNotEmpty();
        }
        EList _inputVars = aifl.getInputVars();
        for (VarDeclaration decl_3 : _inputVars) {
            _builder.append("local ");
            CharSequence _luaFBAdapterInputVarName = LuaConstants.luaFBAdapterInputVarName(decl_3, adapter.getName());
            _builder.append((Object)_luaFBAdapterInputVarName);
            _builder.append(" = ");
            _builder.append((Object)(0xC000000 | adapterID << 16 | aifl.getInputVars().indexOf((Object)decl_3)));
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static InterfaceList getAdapterInterfaceList(AdapterDeclaration adapter) {
        boolean _isIsInput = adapter.isIsInput();
        if (_isIsInput) {
            return adapter.getType().getPlugType().getInterfaceList();
        }
        return adapter.getType().getInterfaceList();
    }

    public static CharSequence luaInternalConstants(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        EList _internalVars = type.getInternalVars();
        for (VarDeclaration decl : _internalVars) {
            _builder.append("local ");
            CharSequence _luaFBInternalVarName = LuaConstants.luaFBInternalVarName(decl);
            _builder.append((Object)_luaFBInternalVarName);
            _builder.append(" = ");
            _builder.append((Object)(0x10000000 | type.getInternalVars().indexOf((Object)decl)));
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaConstants(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _luaFBStateConstant = LuaConstants.luaFBStateConstant();
        _builder.append((Object)_luaFBStateConstant);
        _builder.newLineIfNotEmpty();
        CharSequence _luaStateConstants = LuaConstants.luaStateConstants(type.getECC());
        _builder.append((Object)_luaStateConstants);
        _builder.newLineIfNotEmpty();
        CharSequence _luaEventConstants = LuaConstants.luaEventConstants(type.getInterfaceList());
        _builder.append((Object)_luaEventConstants);
        _builder.newLineIfNotEmpty();
        CharSequence _luaFBVariableConstants = LuaConstants.luaFBVariableConstants(type.getInterfaceList());
        _builder.append((Object)_luaFBVariableConstants);
        _builder.newLineIfNotEmpty();
        CharSequence _luaFBAdapterConstants = LuaConstants.luaFBAdapterConstants(type.getInterfaceList());
        _builder.append((Object)_luaFBAdapterConstants);
        _builder.newLineIfNotEmpty();
        CharSequence _luaInternalConstants = LuaConstants.luaInternalConstants(type);
        _builder.append((Object)_luaInternalConstants);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence luaFBStateVariable() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fb[");
        CharSequence _luaFBStateVarName = LuaConstants.luaFBStateVarName();
        _builder.append((Object)_luaFBStateVarName);
        _builder.append("]");
        return _builder;
    }

    public static CharSequence luaFBVariable(VarDeclaration decl) {
        StringConcatenation _xblockexpression = null;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)decl);
        FBType type = (FBType)_rootContainer;
        StringConcatenation _xifexpression = null;
        boolean _contains = type.getInterfaceList().getInputVars().contains((Object)decl);
        if (_contains) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("fb[");
            CharSequence _luaFBInputVarName = LuaConstants.luaFBInputVarName(decl);
            _builder.append((Object)_luaFBInputVarName);
            _builder.append("]");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xifexpression_1 = null;
            boolean _contains_1 = type.getInterfaceList().getOutputVars().contains((Object)decl);
            if (_contains_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("fb[");
                CharSequence _luaFBOutputVarName = LuaConstants.luaFBOutputVarName(decl);
                _builder_1.append((Object)_luaFBOutputVarName);
                _builder_1.append("]");
                _xifexpression_1 = _builder_1;
            } else {
                StringConcatenation _xifexpression_2 = null;
                if (!(type instanceof BasicFBType) || !((BasicFBType)type).getInternalVars().contains((Object)decl)) {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("Unknown kind of variable ");
                    String _name = decl.getName();
                    _builder_3.append(_name);
                    throw new IllegalArgumentException(_builder_3.toString());
                }
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("fb[");
                CharSequence _luaFBInternalVarName = LuaConstants.luaFBInternalVarName(decl);
                _builder_2.append((Object)_luaFBInternalVarName);
                _builder_2.append("]");
                _xifexpression_2 = _builder_2;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static CharSequence luaFBVariablesPrefix(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        for (VarDeclaration variable : variables) {
            _builder.append("local ");
            CharSequence _luaVariable = LuaConstants.luaVariable(variable);
            _builder.append((Object)_luaVariable);
            _builder.append(" = ");
            CharSequence _luaFBVariable = LuaConstants.luaFBVariable(variable);
            _builder.append((Object)_luaFBVariable);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaFBAdapterInECCVariablesPrefix(VarDeclaration adapterVariable, String adapterName, boolean isPlug) {
        StringConcatenation _builder = new StringConcatenation();
        if (isPlug) {
            _builder.append("local ");
            CharSequence _luaAdapterVariable = LuaConstants.luaAdapterVariable(adapterVariable.getName(), adapterName);
            _builder.append((Object)_luaAdapterVariable);
            _builder.append(" = fb[");
            CharSequence _xifexpression = null;
            boolean _isIsInput = adapterVariable.isIsInput();
            _xifexpression = _isIsInput ? LuaConstants.luaFBAdapterInputVarName(adapterVariable, adapterName) : LuaConstants.luaFBAdapterOutputVarName(adapterVariable, adapterName);
            _builder.append((Object)_xifexpression);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("local ");
            CharSequence _luaAdapterVariable_1 = LuaConstants.luaAdapterVariable(adapterVariable.getName(), adapterName);
            _builder.append((Object)_luaAdapterVariable_1);
            _builder.append(" = fb[");
            CharSequence _xifexpression_1 = null;
            boolean _isIsInput_1 = adapterVariable.isIsInput();
            _xifexpression_1 = _isIsInput_1 ? LuaConstants.luaFBAdapterOutputVarName(adapterVariable, adapterName) : LuaConstants.luaFBAdapterInputVarName(adapterVariable, adapterName);
            _builder.append((Object)_xifexpression_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaFBVariablesSuffix(Iterable<VarDeclaration> variables) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            boolean _isIsInput = it.isIsInput();
            return !_isIsInput;
        };
        Iterable _filter = IterableExtensions.filter(variables, (Functions.Function1)_function);
        for (VarDeclaration variable : _filter) {
            CharSequence _luaFBVariable = LuaConstants.luaFBVariable(variable);
            _builder.append((Object)_luaFBVariable);
            _builder.append(" = ");
            CharSequence _luaVariable = LuaConstants.luaVariable(variable);
            _builder.append((Object)_luaVariable);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence luaSendOutputEvent(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fb(");
        CharSequence _luaOutputEventName = LuaConstants.luaOutputEventName(event);
        _builder.append((Object)_luaOutputEventName);
        _builder.append(")");
        return _builder;
    }

    public static CharSequence luaSendAdapterOutputEvent(Event event) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fb(AEO_");
        String _replace = event.getName().replace(".", "_");
        _builder.append(_replace);
        _builder.append(")");
        return _builder;
    }

    public static int getEventWith(Event event, List<Integer> with, List<VarDeclaration> vars) {
        boolean _isEmpty = event.getWith().isEmpty();
        if (_isEmpty) {
            return -1;
        }
        int index = with.size();
        EList _with = event.getWith();
        for (With w : _with) {
            with.add(vars.indexOf(w.getVariables()));
        }
        with.add(65535);
        return index;
    }

    public static ArrayList<Object> getTypeList(List<VarDeclaration> vars) {
        int _size = vars.size();
        ArrayList<Object> typeList = new ArrayList<Object>(_size);
        Consumer<VarDeclaration> _function = it -> {
            boolean _isArray = it.isArray();
            if (_isArray) {
                typeList.add("ARRAY");
                typeList.add(it.getArraySize());
            }
            typeList.add(it.getTypeName());
        };
        vars.forEach(_function);
        return typeList;
    }

    public static CharSequence luaInterfaceSpec(InterfaceList ifl) {
        StringConcatenation _xblockexpression = null;
        ArrayList<Integer> inputWith = new ArrayList<Integer>();
        ArrayList<Integer> inputWithIndexes = new ArrayList<Integer>();
        EList _eventInputs = ifl.getEventInputs();
        for (Event e : _eventInputs) {
            inputWithIndexes.add(LuaConstants.getEventWith(e, inputWith, (List<VarDeclaration>)ifl.getInputVars()));
        }
        ArrayList<Integer> outputWith = new ArrayList<Integer>();
        ArrayList<Integer> outputWithIndexes = new ArrayList<Integer>();
        EList _eventOutputs = ifl.getEventOutputs();
        for (Event e_1 : _eventOutputs) {
            outputWithIndexes.add(LuaConstants.getEventWith(e_1, outputWith, (List<VarDeclaration>)ifl.getOutputVars()));
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local interfaceSpec = {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("numEIs = ");
        int _size = ifl.getEventInputs().size();
        _builder.append((Object)_size, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EINames = ");
        Functions.Function1 _function = it -> it.getName();
        CharSequence _luaStringList = LuaUtils.luaStringList(ListExtensions.map((List)ifl.getEventInputs(), (Functions.Function1)_function));
        _builder.append((Object)_luaStringList, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EIWith = ");
        CharSequence _luaIntegerList = LuaUtils.luaIntegerList(inputWith);
        _builder.append((Object)_luaIntegerList, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EIWithIndexes = ");
        CharSequence _luaIntegerList_1 = LuaUtils.luaIntegerList(inputWithIndexes);
        _builder.append((Object)_luaIntegerList_1, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("numEOs = ");
        int _size_1 = ifl.getEventOutputs().size();
        _builder.append((Object)_size_1, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EONames = ");
        Functions.Function1 _function_1 = it -> it.getName();
        CharSequence _luaStringList_1 = LuaUtils.luaStringList(ListExtensions.map((List)ifl.getEventOutputs(), (Functions.Function1)_function_1));
        _builder.append((Object)_luaStringList_1, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EOWith = ");
        CharSequence _luaIntegerList_2 = LuaUtils.luaIntegerList(outputWith);
        _builder.append((Object)_luaIntegerList_2, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("EOWithIndexes = ");
        CharSequence _luaIntegerList_3 = LuaUtils.luaIntegerList(outputWithIndexes);
        _builder.append((Object)_luaIntegerList_3, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("numDIs = ");
        int _size_2 = ifl.getInputVars().size();
        _builder.append((Object)_size_2, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("DINames = ");
        Functions.Function1 _function_2 = it -> it.getName();
        CharSequence _luaStringList_2 = LuaUtils.luaStringList(ListExtensions.map((List)ifl.getInputVars(), (Functions.Function1)_function_2));
        _builder.append((Object)_luaStringList_2, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("DIDataTypeNames = ");
        CharSequence _luaValueList = LuaUtils.luaValueList(LuaConstants.getTypeList((List<VarDeclaration>)ifl.getInputVars()));
        _builder.append((Object)_luaValueList, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("numDOs = ");
        int _size_3 = ifl.getOutputVars().size();
        _builder.append((Object)_size_3, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("DONames = ");
        Functions.Function1 _function_3 = it -> it.getName();
        CharSequence _luaStringList_3 = LuaUtils.luaStringList(ListExtensions.map((List)ifl.getOutputVars(), (Functions.Function1)_function_3));
        _builder.append((Object)_luaStringList_3, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("DODataTypeNames = ");
        CharSequence _luaValueList_1 = LuaUtils.luaValueList(LuaConstants.getTypeList((List<VarDeclaration>)ifl.getOutputVars()));
        _builder.append((Object)_luaValueList_1, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("numAdapters = ");
        int _size_4 = ifl.getPlugs().size();
        int _size_5 = ifl.getSockets().size();
        int _plus = _size_4 + _size_5;
        _builder.append((Object)_plus, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("adapterInstanceDefinition = {");
        _builder.newLine();
        _builder.append("    ");
        Functions.Function1 _function_4 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("{adapterNameID = \"");
            String _name = it.getName();
            _builder_1.append(_name);
            _builder_1.append("\", adapterTypeNameID = \"");
            String _typeName = it.getTypeName();
            _builder_1.append(_typeName);
            _builder_1.append("\", isPlug = true}");
            return _builder_1.toString();
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)ifl.getPlugs(), (Functions.Function1)_function_4), (CharSequence)",\n");
        _builder.append(_join, "    ");
        if (!ifl.getSockets().isEmpty() && !ifl.getPlugs().isEmpty()) {
            _builder.append(",");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        Functions.Function1 _function_5 = it -> {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("{adapterNameID = \"");
            String _name = it.getName();
            _builder_1.append(_name);
            _builder_1.append("\", adapterTypeNameID = \"");
            String _typeName = it.getTypeName();
            _builder_1.append(_typeName);
            _builder_1.append("\", isPlug = false}");
            return _builder_1.toString();
        };
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)ifl.getSockets(), (Functions.Function1)_function_5), (CharSequence)",\n");
        _builder.append(_join_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public static CharSequence luaInternalVarsInformation(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local internalVarsInformation = {");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("numIntVars = ");
        int _size = type.getInternalVars().size();
        _builder.append((Object)_size, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("intVarsNames = ");
        Functions.Function1 _function = it -> it.getName();
        CharSequence _luaStringList = LuaUtils.luaStringList(ListExtensions.map((List)type.getInternalVars(), (Functions.Function1)_function));
        _builder.append((Object)_luaStringList, "  ");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("intVarsDataTypeNames = ");
        CharSequence _luaValueList = LuaUtils.luaValueList(LuaConstants.getTypeList((List<VarDeclaration>)type.getInternalVars()));
        _builder.append((Object)_luaValueList, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        return _builder;
    }
}

