/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractRuntimeWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.AnyValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class VarDeclarationWatch
extends AbstractRuntimeWatch
implements IVarDeclarationWatch {
    private boolean forced;

    public VarDeclarationWatch(String name, VarDeclaration varDeclaration, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(VariableOperations.newVariable((String)name, (INamedElement)VariableOperations.evaluateResultType((VarDeclaration)varDeclaration)), (ITypedElement)varDeclaration, debugTarget);
    }

    public VarDeclarationWatch(String name, VarDeclaration varDeclaration, Resource resource, String resourceRelativeName, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(VariableOperations.newVariable((String)name, (INamedElement)VariableOperations.evaluateResultType((VarDeclaration)varDeclaration)), (ITypedElement)varDeclaration, resource, resourceRelativeName, debugTarget);
    }

    @Override
    public void setValue(String expression) throws DebugException {
        super.setValue(expression);
        this.writeWatch();
    }

    @Override
    public void setValue(IValue value) throws DebugException {
        super.setValue(value);
        this.writeWatch();
    }

    @Override
    public void setValue(Value value) throws DebugException {
        this.getInternalVariable().setValue(value);
        this.fireContentChanged();
        this.writeWatch();
    }

    @Override
    protected void childValueChanged() throws DebugException {
        this.writeWatch();
    }

    protected void writeWatch() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().writeFBParameter(this.getResourceChecked(), this.getResourceRelativeName(), this.getInternalVariable().toString(false));
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.VarDeclarationWatch_WriteError, this.getQualifiedName()), (Throwable)e));
        }
    }

    @Override
    public void forceValue(String value) throws DebugException {
        super.setValue(value);
        this.writeForce();
    }

    @Override
    public void forceValue(Value value) throws DebugException {
        this.getInternalVariable().setValue(value);
        this.fireContentChanged();
        this.writeForce();
    }

    protected void writeForce() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().forceValue(this.getResourceChecked(), this.getResourceRelativeName(), this.getInternalVariable().toString(false));
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.VarDeclarationWatch_ForceError, this.getQualifiedName()), (Throwable)e));
        }
    }

    @Override
    public void clearForce() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().clearForce(this.getResourceChecked(), this.getResourceRelativeName());
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.VarDeclarationWatch_ClearForceError, this.getQualifiedName()), (Throwable)e));
        }
    }

    @Override
    public boolean isForced() {
        return this.forced;
    }

    protected void setForced(boolean forced) {
        this.forced = forced;
    }

    @Override
    public void updateValue(Data data) {
        super.updateValue(data);
        this.setForced(Boolean.parseBoolean(data.getForced()));
    }

    @Override
    public VarDeclaration getWatchedElement() {
        return (VarDeclaration)super.getWatchedElement();
    }

    @Override
    public AnyValue getInternalValue() {
        return (AnyValue)super.getInternalValue();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IInterfaceElement.class) {
            return adapter.cast(this.getWatchedElement());
        }
        return (T)super.getAdapter(adapter);
    }
}

