/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractVariableWatch
extends DeploymentDebugVariable
implements IVariableWatch {
    private final Resource resource;
    private final ITypedElement element;
    private long aliveCount;

    protected AbstractVariableWatch(Variable<?> variable, ITypedElement element, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        this(variable, element, DeploymentDebugWatchUtils.getResource((INamedElement)element), debugTarget);
    }

    protected AbstractVariableWatch(Variable<?> variable, ITypedElement element, Resource resource, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(variable, element.getQualifiedName(), debugTarget);
        this.resource = resource;
        this.element = element;
    }

    protected void updateValue(String value) {
        try {
            this.getInternalVariable().setValue(value, this.getDebugTarget().getTypeLibrary());
            this.aliveCount = this.getDebugTarget().getVariableUpdateCount();
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("Invalid watch value for " + this.getQualifiedName() + ": " + value), (Exception)e);
        }
    }

    protected void updateValue(Value value) {
        try {
            this.getInternalVariable().setValue(value);
            this.aliveCount = this.getDebugTarget().getVariableUpdateCount();
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("Invalid watch value for " + this.getQualifiedName() + ": " + String.valueOf(value)), (Exception)e);
        }
    }

    @Override
    public boolean isAlive() {
        return this.aliveCount == this.getDebugTarget().getVariableUpdateCount();
    }

    @Override
    public String getQualifiedName() {
        return this.getExpression();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    protected Resource getResourceChecked() throws DebugException {
        if (this.resource == null) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.AbstractVariableWatch_ElementNotInResource, this.getQualifiedName())));
        }
        return this.resource;
    }

    @Override
    public ITypedElement getWatchedElement() {
        return this.element;
    }

    @Override
    public Value getInternalValue() {
        return this.getInternalVariable().getValue();
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableWatch other = (AbstractVariableWatch)obj;
        return Objects.equals(this.getQualifiedName(), other.getQualifiedName());
    }
}

