/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentNetwork;
import org.eclipse.fordiac.ide.application.policies.ContainerContentLayoutPolicy;
import org.eclipse.fordiac.ide.model.commands.change.AddElementsToGroup;
import org.eclipse.fordiac.ide.model.commands.create.CreateFBElementInGroupCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class GroupXYLayoutPolicy
extends ContainerContentLayoutPolicy {
    @Override
    protected Command getCreateCommand(CreateRequest request) {
        if (request != null) {
            Object childClass = request.getNewObjectType();
            Point insertPoint = this.getInsertPoint(request);
            if (childClass instanceof TypeEntry) {
                TypeEntry typeEntry = (TypeEntry)childClass;
                return new CreateFBElementInGroupCommand(typeEntry, this.getParentModel(), insertPoint.x, insertPoint.y);
            }
        }
        return null;
    }

    @Override
    protected Command getAddCommand(Request request) {
        Group dropGroup;
        ChangeBoundsRequest changeBoundsRequest;
        List editParts;
        List<FBNetworkElement> fbEls;
        if (GroupXYLayoutPolicy.isDragAndDropRequestForGroup(request, this.getTargetEditPart(request)) && GroupXYLayoutPolicy.containsOnlyFbsAndSubapps(fbEls = GroupXYLayoutPolicy.collectDraggedFBs(editParts = (changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts(), dropGroup = ((GroupContentNetwork)this.getTargetEditPart(request).getModel()).getGroup()))) {
            return this.createAddToGroupCommand(changeBoundsRequest, dropGroup, fbEls);
        }
        return null;
    }

    private static boolean containsOnlyFbsAndSubapps(List<FBNetworkElement> fbEls) {
        if (!fbEls.isEmpty()) {
            if (!fbEls.stream().anyMatch(Group.class::isInstance)) {
                return true;
            }
        }
        return false;
    }

    private static List<FBNetworkElement> collectDraggedFBs(List<? extends EditPart> editParts, Group dropGroup) {
        return editParts.stream().map(EditPart::getModel).filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).filter(el -> dropGroup.getFbNetwork().equals(el.getFbNetwork())).toList();
    }

    public static boolean isDragAndDropRequestForGroup(Request generic, EditPart targetEditPart) {
        return generic instanceof ChangeBoundsRequest && targetEditPart instanceof GroupContentEditPart;
    }

    protected Group getParentModel() {
        return (Group)super.getParentModel();
    }

    private Command createAddToGroupCommand(ChangeBoundsRequest request, Group dropGroup, List<FBNetworkElement> fbEls) {
        Rectangle groupContentBounds = ContainerContentLayoutPolicy.getContainerAreaBounds(this.getHost());
        Point topLeft = groupContentBounds.getTopLeft();
        GroupXYLayoutPolicy.translateToRelative((GraphicalEditPart)this.getHost().getParent(), topLeft);
        Point moveDelta = this.getScaledMoveDelta(request);
        topLeft.translate(-moveDelta.x, -moveDelta.y);
        AddElementsToGroup addElementsToGroup = new AddElementsToGroup(dropGroup, fbEls, topLeft);
        return new ResizeGroupOrSubappCommand(this.getHost(), (Command)addElementsToGroup);
    }
}

