/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.dnd;

import java.util.List;
import org.eclipse.fordiac.ide.application.dnd.CustomSourceTransfer;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.dnd.Transfer;

public class CustomDragTargetListener
extends AbstractTransferDropTargetListener {
    public CustomDragTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)CustomSourceTransfer.getInstance());
        this.setEnablementDeterminedByCommand(true);
    }

    protected Request createTargetRequest() {
        Request req = CustomSourceTransfer.getInstance().getObject();
        if (req != null) {
            return req;
        }
        return super.createTargetRequest();
    }

    protected Command getCommand() {
        Request req = this.getTargetRequest();
        if (req instanceof ReconnectRequest) {
            ReconnectRequest reconReq = (ReconnectRequest)req;
            List connections = (List)req.getExtendedData().get("Connections");
            if (connections != null) {
                CompoundCommand cmd = new CompoundCommand();
                connections.forEach(con -> {
                    reconReq.setConnectionEditPart((ConnectionEditPart)con);
                    cmd.add(this.getTargetEditPart().getCommand((Request)reconReq));
                });
                return cmd;
            }
        }
        return super.getCommand();
    }

    protected void updateTargetRequest() {
        Request req = this.getTargetRequest();
        if (req instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConReq = (CreateConnectionRequest)req;
            createConReq.setLocation(this.getDropLocation());
        } else if (req instanceof ReconnectRequest) {
            ReconnectRequest reconReq = (ReconnectRequest)req;
            reconReq.setLocation(this.getDropLocation());
            reconReq.setTargetEditPart(this.getTargetEditPart());
        } else if (req instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest boundReq = (ChangeBoundsRequest)req;
            boundReq.setLocation(this.getDropLocation());
        }
    }
}

