/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.libraryElement.I4DIACElement;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.IOpenListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;

public enum OpenListenerManager {
    INSTANCE;

    private List<IOpenListener> openListeners = null;

    List<IOpenListener> getOpenListeners() {
        if (this.openListeners == null) {
            this.loadOpenListeners();
        }
        return this.openListeners;
    }

    public List<IOpenListener> getOpenListener(I4DIACElement elementToOpen) {
        ArrayList<IOpenListener> listeners = new ArrayList<IOpenListener>();
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!this.listenerSupportsElement(openListener, elementToOpen)) continue;
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            listeners.add(openListener);
        }
        return listeners;
    }

    public void setDefaultOpenListener(Class<? extends I4DIACElement> libElement, String id) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue(libElement.getName(), id);
    }

    public IOpenListener getDefaultOpenListener(I4DIACElement elementToOpen) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!this.listenerSupportsElement(openListener, elementToOpen)) continue;
            String value = ps.getString(openListener.getHandledClass().getName());
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            if ("".equals(value)) {
                return openListener;
            }
            if (!value.equals(openListener.getOpenListenerID())) continue;
            return openListener;
        }
        return null;
    }

    public static IEditorPart openEditor(I4DIACElement element) {
        IOpenListener openListener = INSTANCE.getDefaultOpenListener(element);
        if (openListener != null) {
            openListener.run(null);
            return openListener.getOpenedEditor();
        }
        return null;
    }

    private void loadOpenListeners() {
        IConfigurationElement[] elems;
        this.openListeners = new ArrayList<IOpenListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.util", "openListener");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IOpenListener) {
                    this.openListeners.add((IOpenListener)object);
                }
            }
            catch (CoreException corex) {
                Activator.getDefault().logError(corex.getMessage(), (Exception)((Object)corex));
            }
            ++n2;
        }
    }

    private boolean listenerSupportsElement(IOpenListener listener, I4DIACElement elementtoOpen) {
        return listener.getHandledClass() != null && listener.getHandledClass().isInstance(elementtoOpen);
    }
}

