/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.fordiac.ide.util.Activator;
import org.eclipse.fordiac.ide.util.comm.datatypes.IECDataTypeFactory;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;

public class IEC_ARRAY
extends IEC_ANY {
    private IEC_ANY[] value;

    public IEC_ARRAY() {
        this.value = new IEC_ANY[0];
    }

    public IEC_ARRAY(IEC_ANY[] initial) {
        this.value = (IEC_ANY[])initial.clone();
    }

    public IEC_ARRAY(DataInputStream in) {
        super(in);
    }

    @Override
    public void decodeValueFrom(DataInputStream in) {
        int size = 0;
        int ASN1IdentifierOctet = 0;
        try {
            size = in.readShort();
            ASN1IdentifierOctet = in.readByte() & 0xFF;
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        IEC_ANY[] temp = new IEC_ANY[size];
        int i = 0;
        while (i < size) {
            temp[i] = IECDataTypeFactory.getIECType(ASN1IdentifierOctet, in);
            ++i;
        }
        this.value = temp;
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{118};
        return retval;
    }

    @Override
    public byte[] encodeValue() {
        ByteArrayOutputStream myOut = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(myOut);
        try {
            dos.writeShort(this.value.length);
            dos.write(this.value[0].encodeTag());
            int i = 0;
            while (i < this.value.length) {
                dos.write(this.value[i].encodeValue());
                ++i;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return myOut.toByteArray();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IEC_ARRAY) {
            boolean equal = true;
            IEC_ARRAY that = (IEC_ARRAY)obj;
            if (that.value.length == this.value.length) {
                if (that.value.length == 0) {
                    return true;
                }
                if (!that.value[0].getClass().equals(this.value[0].getClass())) {
                    return false;
                }
                int i = 0;
                while (i < this.value.length) {
                    if (!this.value[i].equals(that.value[i])) {
                        equal = false;
                    }
                    ++i;
                }
            } else {
                return false;
            }
            return equal;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public IEC_ANY[] getValue() {
        return (IEC_ANY[])this.value.clone();
    }

    public void setValue(IEC_ANY[] value) {
        this.value = (IEC_ANY[])value.clone();
    }

    public String toString() {
        StringBuilder tempString = new StringBuilder("[");
        int i = 0;
        while (i < this.value.length) {
            if (i != 0) {
                tempString.append(", ");
            }
            tempString.append(this.value[i].toString());
            ++i;
        }
        tempString.append("]");
        return tempString.toString();
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_ARRAY)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        return false;
    }
}

