/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemimport;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemimport.IEC61499_2ImportWizardPage;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class SystemImport
extends Wizard
implements IImportWizard {
    private static final String FORDIAC_SYSTEM_IMPORT_SECTION = "4DIAC_SYSTEM_IMPORT_SECTION";
    AutomationSystem system = null;
    private IEC61499_2ImportWizardPage page;

    public SystemImport() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(FORDIAC_SYSTEM_IMPORT_SECTION);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(FORDIAC_SYSTEM_IMPORT_SECTION);
        }
        this.setDialogSettings(dialogSettings);
    }

    public void addPages() {
        super.addPages();
        this.page = new IEC61499_2ImportWizardPage("Import System");
        this.page.setDescription("Importing a system configuration to 4diac");
        this.page.setTitle("System Import");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SystemImport.this.system = SystemManager.INSTANCE.createLocalProject(SystemImport.this.page.getProjectName());
                try {
                    SystemImporter sysImporter = new SystemImporter();
                    FileInputStream stream = new FileInputStream(SystemImport.this.page.getSelectedSystemFile());
                    sysImporter.importSystem((InputStream)stream, SystemImport.this.system);
                    SystemManager.INSTANCE.saveSystem(SystemImport.this.system);
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    Activator.getDefault().logError(e.getMessage(), (Exception)e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, op);
        }
        catch (Exception e) {
            MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
            msg.setMessage("Import Error:\n" + e.getMessage());
            msg.open();
            Activator.getDefault().logError(msg.getMessage(), e);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

