/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.controls.Abstract4DIACUIPlugin;
import org.eclipse.fordiac.ide.ui.controls.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;

public class ResourceDeleteCommand
extends Command {
    private IEditorPart editor;
    private Device device;
    private Resource resource;
    private CompoundCommand commands;

    public ResourceDeleteCommand(Resource resource) {
        this.resource = resource;
        this.editor = Abstract4DIACUIPlugin.getCurrentActiveEditor();
    }

    public boolean canUndo() {
        return this.editor.equals(Abstract4DIACUIPlugin.getCurrentActiveEditor());
    }

    public boolean canExecute() {
        return this.resource != null && !this.resource.isDeviceTypeResource();
    }

    public void execute() {
        this.closeResourceEditor();
        this.device = this.resource.getDevice();
        this.commands = new CompoundCommand();
        for (FBNetworkElement element : this.resource.getFBNetwork().getNetworkElements()) {
            UnmapCommand cmd = null;
            if (element.isMapped()) {
                cmd = new UnmapCommand(element);
            }
            if (cmd == null || !cmd.canExecute()) continue;
            this.commands.add((Command)cmd);
        }
        this.redo();
    }

    private void closeResourceEditor() {
        EditorUtils.closeEditorsFiltered(editor -> editor instanceof DiagramEditorWithFlyoutPalette && this.resource.getFBNetwork().equals(((DiagramEditorWithFlyoutPalette)editor).getModel()));
    }

    public void undo() {
        if (this.device != null) {
            this.device.getResource().add((Object)this.resource);
        }
        this.commands.undo();
        SystemManager.INSTANCE.notifyListeners();
    }

    public void redo() {
        this.commands.execute();
        if (this.device != null) {
            this.device.getResource().remove((Object)this.resource);
        }
        SystemManager.INSTANCE.notifyListeners();
    }
}

