/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.dataexport.AdapterExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.CompilableType;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Identification;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VersionInfo;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CommonElementExporter {
    private static FbtExporter fbTypeExporter = new FbtExporter();
    private static AdapterExporter adapterTypeExporter = new AdapterExporter();
    private static SubApplicationTypeExporter subAppTypeExporter = new SubApplicationTypeExporter();

    public static void saveType(PaletteEntry entry) {
        CommonElementExporter exporter = null;
        if (entry instanceof FBTypePaletteEntry) {
            exporter = fbTypeExporter;
        } else if (entry instanceof AdapterTypePaletteEntry) {
            exporter = adapterTypeExporter;
        } else if (entry instanceof SubApplicationTypePaletteEntry) {
            exporter = subAppTypeExporter;
        }
        if (exporter != null) {
            exporter.performSave(entry);
            entry.setLastModificationTimestamp(entry.getFile().getModificationStamp());
        }
    }

    public void performSave(PaletteEntry entry) {
        try {
            Document dom = this.getDocument(this.getType(entry));
            DOMSource source = new DOMSource(dom);
            this.writeToFile(source, entry.getFile());
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public static void addColorAttributeElement(Document dom, Element parent, ColorizableElement colElement) {
        String colorValue = String.valueOf(colElement.getColor().getRed()) + "," + colElement.getColor().getGreen() + "," + colElement.getColor().getBlue();
        Element colorAttribute = CommonElementExporter.createAttributeElement(dom, "Color", "STRING", colorValue, "color");
        parent.appendChild(colorAttribute);
    }

    public static Element createAttributeElement(Document dom, String name, String type, String value, String comment) {
        Element attributeElement = dom.createElement("Attribute");
        attributeElement.setAttribute("Name", name);
        attributeElement.setAttribute("Type", type);
        attributeElement.setAttribute("Value", value);
        attributeElement.setAttribute("Comment", comment);
        return attributeElement;
    }

    private Transformer createXMLTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setAttribute("indent-number", 2);
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("doctype-system", "http://www.holobloc.com/xml/LibraryElement.dtd");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }

    protected abstract FBType getType(PaletteEntry var1);

    public Document getDocument(FBType fbType) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.newDocument();
            this.addType(dom, fbType);
            return dom;
        }
        catch (ParserConfigurationException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    protected abstract void addType(Document var1, FBType var2);

    protected Element createRootElement(Document dom, INamedElement namedElement, String rootElemName) {
        Element rootElement = dom.createElement(rootElemName);
        CommonElementExporter.setNameAttribute(rootElement, namedElement.getName());
        CommonElementExporter.setCommentAttribute(rootElement, namedElement);
        dom.appendChild(rootElement);
        return rootElement;
    }

    protected void addCompileAbleTypeData(Document dom, Element rootElement, CompilableType type) {
        CommonElementExporter.addIdentification(dom, rootElement, type);
        CommonElementExporter.addVersionInfo(dom, rootElement, type);
        CommonElementExporter.addCompilerInfo(dom, rootElement, type.getCompilerInfo());
    }

    public void writeToFile(Source source, IFile iFile) throws UnsupportedEncodingException, FileNotFoundException, TransformerException, IOException {
        new StreamResult(new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), "UTF-8"));
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        Transformer transformer = this.createXMLTransformer();
        transformer.transform(source, result);
        try {
            if (iFile.exists()) {
                iFile.setContents((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8")), 3, null);
            } else {
                IFolder folder = iFile.getProject().getFolder(iFile.getProjectRelativePath().removeLastSegments(1));
                if (!folder.exists()) {
                    folder.create(true, true, null);
                    folder.refreshLocal(0, null);
                }
                iFile.create((InputStream)new ByteArrayInputStream(result.toString().getBytes("UTF-8")), 3, null);
            }
            iFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static void addIdentification(Document dom, Element parentElement, LibraryElement libraryelement) {
        if (libraryelement.getIdentification() != null) {
            Element identification = dom.createElement("Identification");
            Identification ident = libraryelement.getIdentification();
            if (ident.getStandard() != null && !ident.getStandard().equals("")) {
                identification.setAttribute("Standard", ident.getStandard());
            }
            if (ident.getClassification() != null && !ident.getClassification().equals("")) {
                identification.setAttribute("Classification", ident.getClassification());
            }
            if (ident.getApplicationDomain() != null && !ident.getApplicationDomain().equals("")) {
                identification.setAttribute("ApplicationDomain", ident.getApplicationDomain());
            }
            if (ident.getFunction() != null && !ident.getFunction().equals("")) {
                identification.setAttribute("Function", ident.getFunction());
            }
            if (ident.getType() != null && !ident.getType().equals("")) {
                identification.setAttribute("Type", ident.getType());
            }
            if (ident.getDescription() != null && !ident.getDescription().equals("")) {
                identification.setAttribute("Description", ident.getDescription());
            }
            parentElement.appendChild(identification);
        }
    }

    public static void addVersionInfo(Document dom, Element rootEle, LibraryElement libraryelement) {
        if (libraryelement.getVersionInfo().size() > 0) {
            for (VersionInfo info : libraryelement.getVersionInfo()) {
                Element versionInfo = dom.createElement("VersionInfo");
                if (info.getOrganization() != null && !info.getOrganization().equals("")) {
                    versionInfo.setAttribute("Organization", info.getOrganization());
                }
                if (info.getVersion() != null && !info.getVersion().equals("")) {
                    versionInfo.setAttribute("Version", info.getVersion());
                }
                if (info.getAuthor() != null && !info.getAuthor().equals("")) {
                    versionInfo.setAttribute("Author", info.getAuthor());
                }
                if (info.getDate() != null && !info.getDate().equals("")) {
                    versionInfo.setAttribute("Date", info.getDate());
                }
                if (info.getRemarks() != null && !info.getRemarks().equals("")) {
                    versionInfo.setAttribute("Remarks", info.getRemarks());
                }
                rootEle.appendChild(versionInfo);
            }
        }
    }

    public static void addCompilerInfo(Document dom, Element rootEle, CompilerInfo compilerInfo) {
        if (compilerInfo != null) {
            Element compilerInfoElement = dom.createElement("CompilerInfo");
            if (compilerInfo.getHeader() != null && !compilerInfo.getHeader().equals("")) {
                compilerInfoElement.setAttribute("header", compilerInfo.getHeader().toString());
            }
            if (compilerInfo.getClassdef() != null && !compilerInfo.getClassdef().equals("")) {
                compilerInfoElement.setAttribute("classdef", compilerInfo.getClassdef());
            }
            for (Compiler compiler : compilerInfo.getCompiler()) {
                CommonElementExporter.addCompiler(dom, compilerInfoElement, compiler);
            }
            rootEle.appendChild(compilerInfoElement);
        }
    }

    protected void addInterfaceList(Document dom, Element rootEle, InterfaceList interfaceList) {
        Element interfaceListElement = dom.createElement(this.getInterfaceListElementName());
        this.addEvents(dom, interfaceListElement, interfaceList);
        this.addVars(dom, interfaceListElement, interfaceList);
        this.createAdapterList(dom, interfaceListElement, (List<AdapterDeclaration>)interfaceList.getPlugs(), "Plugs");
        this.createAdapterList(dom, interfaceListElement, (List<AdapterDeclaration>)interfaceList.getSockets(), "Sockets");
        rootEle.appendChild(interfaceListElement);
    }

    protected String getInterfaceListElementName() {
        return "InterfaceList";
    }

    private void createAdapterList(Document dom, Element parentElement, List<AdapterDeclaration> adapterList, String elementName) {
        if (adapterList.size() > 0) {
            Element adpaterListElement = dom.createElement(elementName);
            for (AdapterDeclaration adpDecl : adapterList) {
                this.addAdapterDeclaration(dom, adpaterListElement, adpDecl);
            }
            parentElement.appendChild(adpaterListElement);
        }
    }

    private void addAdapterDeclaration(Document dom, Element parentElement, AdapterDeclaration adapterDecl) {
        Element adatperElement = dom.createElement("AdapterDeclaration");
        CommonElementExporter.setNameTypeCommentAttribute(adatperElement, adapterDecl, adapterDecl.getType());
        if (adapterDecl.getAdapterFB() != null) {
            CommonElementExporter.exportXandY(adapterDecl.getAdapterFB(), adatperElement);
        }
        parentElement.appendChild(adatperElement);
    }

    private static void addCompiler(Document dom, Element compilerInfo, Compiler compiler) {
        Element compilerElement = dom.createElement("Compiler");
        if (compiler.getLanguage() != null) {
            compilerElement.setAttribute("Language", compiler.getLanguage().getName());
        } else {
            compilerElement.setAttribute("Language", "");
        }
        if (compiler.getVendor() != null) {
            compilerElement.setAttribute("Vendor", compiler.getVendor());
        } else {
            compilerElement.setAttribute("Vendor", "");
        }
        if (compiler.getProduct() != null) {
            compilerElement.setAttribute("Product", compiler.getProduct());
        } else {
            compilerElement.setAttribute("Product", "");
        }
        if (compiler.getVersion() != null) {
            compilerElement.setAttribute("Version", compiler.getVersion());
        } else {
            compilerElement.setAttribute("Version", "");
        }
        compilerInfo.appendChild(compilerElement);
    }

    private void addVars(Document dom, Element parentElement, InterfaceList interfaceList) {
        Element inputVars = dom.createElement("InputVars");
        Element outputVars = dom.createElement("OutputVars");
        for (VarDeclaration varDecl : interfaceList.getInputVars()) {
            if (varDecl instanceof AdapterDeclaration) continue;
            this.addVariable(dom, inputVars, varDecl);
        }
        for (VarDeclaration varDecl : interfaceList.getOutputVars()) {
            if (varDecl instanceof AdapterDeclaration) continue;
            this.addVariable(dom, outputVars, varDecl);
        }
        parentElement.appendChild(inputVars);
        parentElement.appendChild(outputVars);
    }

    public void addVariable(Document dom, Element parentElement, VarDeclaration varDecl) {
        Element variableElement = dom.createElement("VarDeclaration");
        CommonElementExporter.setNameTypeCommentAttribute(variableElement, varDecl, varDecl.getType());
        if (varDecl.isArray()) {
            variableElement.setAttribute("ArraySize", Integer.toString(varDecl.getArraySize()));
        }
        if (varDecl.getVarInitialization() != null && varDecl.getVarInitialization().getInitialValue() != null) {
            variableElement.setAttribute("InitialValue", varDecl.getVarInitialization().getInitialValue());
        }
        parentElement.appendChild(variableElement);
    }

    private void addEvents(Document dom, Element parentElement, InterfaceList interfaceList) {
        Element eventInputs = dom.createElement(this.getEventInputsElementName());
        Element eventOutputs = dom.createElement(this.getEventOutputsElementName());
        for (Event event : interfaceList.getEventInputs()) {
            this.addEvent(dom, eventInputs, event);
        }
        for (Event event : interfaceList.getEventOutputs()) {
            this.addEvent(dom, eventOutputs, event);
        }
        parentElement.appendChild(eventInputs);
        parentElement.appendChild(eventOutputs);
    }

    protected String getEventOutputsElementName() {
        return "EventOutputs";
    }

    protected String getEventInputsElementName() {
        return "EventInputs";
    }

    private void addEvent(Document dom, Element parentElement, Event event) {
        Element eventElem = dom.createElement(this.getEventElementName());
        CommonElementExporter.setNameAttribute(eventElem, event.getName());
        eventElem.setAttribute("Type", "Event");
        CommonElementExporter.setCommentAttribute(eventElem, event);
        CommonElementExporter.addWith(dom, eventElem, event);
        parentElement.appendChild(eventElem);
    }

    protected String getEventElementName() {
        return "Event";
    }

    private static void addWith(Document dom, Element parentElement, Event event) {
        Iterator iterator = event.getWith().iterator();
        while (iterator.hasNext()) {
            Element with = dom.createElement("With");
            With withElement = (With)iterator.next();
            VarDeclaration varDecl = withElement.getVariables();
            if (varDecl.getName() != null) {
                with.setAttribute("Var", varDecl.getName());
            } else {
                with.setAttribute("Var", "");
            }
            parentElement.appendChild(with);
        }
    }

    protected static void setCommentAttribute(Element element, INamedElement namedElement) {
        if (namedElement.getComment() != null) {
            element.setAttribute("Comment", namedElement.getComment());
        }
    }

    static void setNameAndCommentAttribute(Element element, INamedElement namedElement) {
        CommonElementExporter.setNameAttribute(element, namedElement.getName());
        CommonElementExporter.setCommentAttribute(element, namedElement);
    }

    static void setNameTypeCommentAttribute(Element element, INamedElement namedElement, INamedElement type) {
        CommonElementExporter.setNameAttribute(element, namedElement.getName());
        CommonElementExporter.setTypeAttribute(element, type);
        CommonElementExporter.setCommentAttribute(element, namedElement);
    }

    static void setTypeAttribute(Element element, INamedElement type) {
        CommonElementExporter.setTypeAttribute(element, type != null && type.getName() != null ? type.getName() : "");
    }

    protected static void setTypeAttribute(Element element, String type) {
        element.setAttribute("Type", type != null ? type : "");
    }

    static void setNameAttribute(Element element, String name) {
        element.setAttribute("Name", name != null ? name : "");
    }

    static void addParamsConfig(Document dom, Element fbElement, EList<VarDeclaration> inputVars) {
        for (VarDeclaration var : inputVars) {
            if (var.getValue() == null || var.getValue().getValue() == null || var.getValue().getValue().equals("")) continue;
            Element parameterElement = dom.createElement("Parameter");
            CommonElementExporter.setNameAttribute(parameterElement, var.getName());
            parameterElement.setAttribute("Value", var.getValue().getValue());
            fbElement.appendChild(parameterElement);
        }
    }

    static void exportXandY(PositionableElement fb, Element fbElement) {
        CommonElementExporter.setXYAttributes(fbElement, fb.getX(), fb.getY());
    }

    static void setXYAttributes(Element element, int x, int y) {
        element.setAttribute("x", CommonElementExporter.reConvertCoordinate(x).toString());
        element.setAttribute("y", CommonElementExporter.reConvertCoordinate(y).toString());
    }

    public void addService(Document dom, Element rootEle, FBType sfb) {
        if (sfb.getService() != null && sfb.getService().getRightInterface() != null && sfb.getService().getLeftInterface() != null) {
            Element serviceElement = dom.createElement("Service");
            serviceElement.setAttribute("RightInterface", sfb.getService().getRightInterface().getName());
            serviceElement.setAttribute("LeftInterface", sfb.getService().getLeftInterface().getName());
            CommonElementExporter.setCommentAttribute(serviceElement, sfb);
            this.addServiceSequences(dom, serviceElement, (List<ServiceSequence>)sfb.getService().getServiceSequence());
            rootEle.appendChild(serviceElement);
        }
    }

    private void addServiceSequences(Document dom, Element serviceElement, List<ServiceSequence> sequences) {
        for (ServiceSequence seq : sequences) {
            Element seqElement = dom.createElement("ServiceSequence");
            CommonElementExporter.setNameAttribute(seqElement, seq.getName());
            CommonElementExporter.setCommentAttribute(seqElement, seq);
            CommonElementExporter.addServiceTransactions(dom, seqElement, seq.getServiceTransaction());
            serviceElement.appendChild(seqElement);
        }
    }

    private static void addServiceTransactions(Document dom, Element seqElement, List<ServiceTransaction> transactions) {
        Iterator<ServiceTransaction> iter = transactions.iterator();
        while (iter.hasNext()) {
            Element serviceTransaction = dom.createElement("ServiceTransaction");
            ServiceTransaction transaction = iter.next();
            if (transaction.getInputPrimitive() != null) {
                CommonElementExporter.addInputPrimitive(dom, serviceTransaction, transaction);
            }
            if (transaction.getOutputPrimitive().size() > 0) {
                CommonElementExporter.addOutputPrimitives(dom, serviceTransaction, transaction);
            }
            seqElement.appendChild(serviceTransaction);
        }
    }

    private static void addInputPrimitive(Document dom, Element serviceTransaction, ServiceTransaction transaction) {
        Element inputPrimitive = dom.createElement("InputPrimitive");
        if (transaction.getInputPrimitive().getInterface() != null && transaction.getInputPrimitive().getInterface().getName() != null) {
            inputPrimitive.setAttribute("Interface", transaction.getInputPrimitive().getInterface().getName());
        } else {
            inputPrimitive.setAttribute("Interface", "");
        }
        if (transaction.getInputPrimitive().getEvent() != null) {
            inputPrimitive.setAttribute("Event", transaction.getInputPrimitive().getEvent());
        } else {
            inputPrimitive.setAttribute("Event", "");
        }
        if (transaction.getInputPrimitive().getParameters() != null && !transaction.getInputPrimitive().getParameters().equals(" ")) {
            inputPrimitive.setAttribute("Parameters", transaction.getInputPrimitive().getParameters());
        }
        serviceTransaction.appendChild(inputPrimitive);
    }

    private static void addOutputPrimitives(Document dom, Element serviceTransaction, ServiceTransaction transaction) {
        Iterator iter = transaction.getOutputPrimitive().iterator();
        while (iter.hasNext()) {
            Element outputPrimitive = dom.createElement("OutputPrimitive");
            OutputPrimitive primitive = (OutputPrimitive)iter.next();
            outputPrimitive.setAttribute("Interface", primitive.getInterface().getName());
            if (primitive.getEvent() != null) {
                outputPrimitive.setAttribute("Event", primitive.getEvent());
            } else {
                outputPrimitive.setAttribute("Event", "");
            }
            if (primitive.getParameters() != null && !primitive.getParameters().equals(" ")) {
                outputPrimitive.setAttribute("Parameters", primitive.getParameters());
            }
            serviceTransaction.appendChild(outputPrimitive);
        }
    }

    public static Double reConvertCoordinate(int value) {
        double lineHeight = 20.0;
        return (double)value * 100.0 / lineHeight;
    }
}

