/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class ChangeArraySizeCommand
extends Command {
    private VarDeclaration variable;
    private int oldArraySize;
    private int newArraySize;
    private String newArraySizeString;

    public ChangeArraySizeCommand(VarDeclaration variable, String newArraySizeString) {
        this.variable = variable;
        this.newArraySizeString = newArraySizeString;
    }

    public boolean canExecute() {
        return this.variable != null && this.newArraySizeString != null;
    }

    public void execute() {
        this.oldArraySize = this.variable.isArray() ? this.variable.getArraySize() : 0;
        if (this.newArraySizeString.length() == 0) {
            this.newArraySize = 0;
        } else if (this.newArraySizeString.length() > 0) {
            try {
                this.newArraySize = Integer.parseInt(this.newArraySizeString);
            }
            catch (NumberFormatException numberFormatException) {
                this.newArraySize = 0;
            }
        }
        this.setArraySize(this.newArraySize);
    }

    private void setArraySize(int arraySize) {
        this.variable.setArraySize(arraySize);
    }

    public void undo() {
        this.setArraySize(this.oldArraySize);
    }

    public void redo() {
        this.setArraySize(this.newArraySize);
    }
}

