/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteGroup;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InterfaceElementSection
extends AbstractSection {
    protected Text nameText;
    protected Text commentText;
    protected Combo typeCombo;
    protected Text parameterText;
    protected CLabel valueCLabel;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTypeAndCommentSection(parent);
    }

    protected void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceElementSection.this.removeContentAdapter();
                InterfaceElementSection.this.executeCommand((Command)new ChangeNameCommand((INamedElement)InterfaceElementSection.this.getType(), InterfaceElementSection.this.nameText.getText()));
                InterfaceElementSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Comment:");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceElementSection.this.removeContentAdapter();
                InterfaceElementSection.this.executeCommand((Command)new ChangeCommentCommand((INamedElement)InterfaceElementSection.this.getType(), InterfaceElementSection.this.commentText.getText()));
                InterfaceElementSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Type: ");
        this.typeCombo = new Combo(composite, 12);
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChangeTypeCommand cmd = null;
                if (InterfaceElementSection.this.getType() instanceof AdapterDeclaration) {
                    DataType newType = this.getTypeForSelection(InterfaceElementSection.this.typeCombo.getText());
                    cmd = new ChangeTypeCommand((VarDeclaration)InterfaceElementSection.this.getType(), newType);
                } else if (InterfaceElementSection.this.getType() instanceof VarDeclaration) {
                    cmd = new ChangeTypeCommand((VarDeclaration)InterfaceElementSection.this.getType(), DataTypeLibrary.getInstance().getType(InterfaceElementSection.this.typeCombo.getText()));
                }
                InterfaceElementSection.this.executeCommand((Command)cmd);
            }

            private DataType getTypeForSelection(String text) {
                for (AdapterTypePaletteEntry adaptertype : InterfaceElementSection.getAdapterTypes(InterfaceElementSection.this.getType().getFBNetworkElement().getFbNetwork().getApplication().getAutomationSystem().getPalette())) {
                    if (!adaptertype.getAdapterType().getName().equals(text)) continue;
                    return adaptertype.getAdapterType();
                }
                return null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.valueCLabel = this.getWidgetFactory().createCLabel(composite, "Value:");
        this.parameterText = this.createGroupText(composite, true);
        this.parameterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceElementSection.this.removeContentAdapter();
                InterfaceElementSection.this.executeCommand((Command)new ChangeValueCommand((VarDeclaration)InterfaceElementSection.this.getType(), InterfaceElementSection.this.parameterText.getText()));
                InterfaceElementSection.this.addContentAdapter();
            }
        });
    }

    protected void fillTypeCombo(String text) {
        this.typeCombo.removeAll();
        if (this.getType() instanceof Event) {
            for (DataType dataType : EventTypeLibrary.getInstance().getEventTypes()) {
                this.typeCombo.add(dataType.getName());
            }
        } else if (this.getType() instanceof AdapterDeclaration) {
            if (this.getType() != null && this.getType().getFBNetworkElement().getFbNetwork().getApplication() != null) {
                for (AdapterTypePaletteEntry adaptertype : InterfaceElementSection.getAdapterTypes(this.getType().getFBNetworkElement().getFbNetwork().getApplication().getAutomationSystem().getPalette())) {
                    this.typeCombo.add(adaptertype.getAdapterType().getName());
                }
            }
        } else if (this.getType() instanceof VarDeclaration) {
            for (DataType dataType : DataTypeLibrary.getInstance().getDataTypesSorted()) {
                this.typeCombo.add(dataType.getName());
            }
        }
        if (this.typeCombo.getItems().length > 0) {
            int i = this.typeCombo.getItems().length - 1;
            while (!text.equals(this.typeCombo.getItems()[i]) && i > 0) {
                --i;
            }
            this.typeCombo.select(i);
        }
    }

    private static ArrayList<AdapterTypePaletteEntry> getAdapterTypes(Palette systemPalette) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        Palette pal = systemPalette;
        if (pal == null) {
            pal = TypeLibrary.getInstance().getPalette();
        }
        retVal.addAll(InterfaceElementSection.getAdapterGroup(pal.getRootGroup()));
        return retVal;
    }

    private static ArrayList<AdapterTypePaletteEntry> getAdapterGroup(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteGroup paletteGroup : group.getSubGroups()) {
            retVal.addAll(InterfaceElementSection.getAdapterGroup(paletteGroup));
        }
        retVal.addAll(InterfaceElementSection.getAdapterGroupEntries(group));
        return retVal;
    }

    private static ArrayList<AdapterTypePaletteEntry> getAdapterGroupEntries(PaletteGroup group) {
        ArrayList<AdapterTypePaletteEntry> retVal = new ArrayList<AdapterTypePaletteEntry>();
        for (PaletteEntry entry : group.getEntries()) {
            if (!(entry instanceof AdapterTypePaletteEntry)) continue;
            retVal.add((AdapterTypePaletteEntry)entry);
        }
        return retVal;
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            if (this.getType().getFBNetworkElement() instanceof SubApp) {
                this.nameText.setEditable(true);
                this.nameText.setEnabled(true);
                this.commentText.setEditable(true);
                this.commentText.setEnabled(true);
                if (this.getType().getInputConnections().isEmpty() && this.getType().getOutputConnections().isEmpty()) {
                    this.typeCombo.setEnabled(true);
                } else {
                    this.typeCombo.setEnabled(false);
                }
            } else {
                this.nameText.setEditable(false);
                this.nameText.setEnabled(false);
                this.commentText.setEditable(false);
                this.commentText.setEnabled(false);
                this.typeCombo.setEnabled(false);
            }
            this.nameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
            this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
            String itype = "";
            if (this.type instanceof VarDeclaration) {
                String string = itype = ((VarDeclaration)this.getType()).getType() != null ? ((VarDeclaration)this.getType()).getType().getName() : "";
                if (this.getType().isIsInput()) {
                    this.parameterText.setVisible(true);
                    this.valueCLabel.setVisible(true);
                    this.parameterText.setText(this.getType().getValue() != null && this.getType().getValue().getValue() != null ? this.getType().getValue().getValue() : "");
                } else {
                    this.valueCLabel.setVisible(false);
                    this.parameterText.setVisible(false);
                }
            } else {
                itype = "Event";
                this.valueCLabel.setVisible(false);
                this.parameterText.setVisible(false);
            }
            this.fillTypeCombo(itype);
        }
        this.commandStack = commandStackBuffer;
    }

    @Override
    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        if (part instanceof DiagramEditorWithFlyoutPalette) {
            return ((DiagramEditorWithFlyoutPalette)part).getCommandStack();
        }
        return null;
    }

    protected IInterfaceElement getInputType(Object input) {
        if (input instanceof InterfaceEditPart) {
            return ((InterfaceEditPart)input).getModel();
        }
        return null;
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    @Override
    protected void setInputInit() {
    }

    @Override
    protected void setInputCode() {
    }
}

