/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.router.MoveableRouter;
import org.eclipse.gef.commands.Command;

public class AdjustConnectionCommand
extends Command {
    private final Connection connection;
    private final Point point;
    private final int index;
    private final org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection;

    public AdjustConnectionCommand(Connection connection, Point p, int index, org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection) {
        this.connection = connection;
        this.point = p;
        this.index = index;
        this.modelConnection = modelConnection;
        connection.translateToRelative((Translatable)this.point);
    }

    public void execute() {
        ConnectionRouter router = this.connection.getConnectionRouter();
        if (router instanceof MoveableRouter) {
            MoveableRouter mr = (MoveableRouter)router;
            switch (this.index) {
                case 1: {
                    Point sourceP = this.connection.getSourceAnchor().getLocation(this.connection.getSourceAnchor().getReferencePoint());
                    this.connection.translateToRelative((Translatable)sourceP);
                    int newX = this.point.x;
                    int delta = newX - sourceP.x;
                    mr.setDeltaX1(this.connection, delta);
                    this.modelConnection.setDx1(delta);
                    break;
                }
                case 2: {
                    Point p3 = this.connection.getTargetAnchor().getLocation(this.connection.getTargetAnchor().getReferencePoint()).getCopy();
                    Point temp = this.connection.getSourceAnchor().getLocation(this.connection.getSourceAnchor().getReferencePoint()).getCopy();
                    this.connection.translateToRelative((Translatable)p3);
                    this.connection.translateToRelative((Translatable)temp);
                    int dif = Math.abs(p3.y - temp.y);
                    int y = 0;
                    y = p3.y < temp.y ? p3.y + dif / 2 : temp.y + dif / 2;
                    int deltaY = this.point.y - y;
                    mr.setDeltaY(this.connection, deltaY);
                    this.modelConnection.setDy(deltaY);
                    break;
                }
                case 3: {
                    Point sourceP = this.connection.getTargetAnchor().getLocation(this.connection.getTargetAnchor().getReferencePoint());
                    this.connection.translateToRelative((Translatable)sourceP);
                    int newX = this.point.x;
                    int delta = newX - sourceP.x;
                    mr.setDeltaX2(this.connection, delta);
                    this.modelConnection.setDx2(delta);
                    break;
                }
            }
            this.connection.revalidate();
        }
    }

    public boolean canExecute() {
        Point ref1 = this.connection.getTargetAnchor().getReferencePoint();
        Point ref2 = this.connection.getSourceAnchor().getReferencePoint();
        Point min = this.connection.getTargetAnchor().getLocation(ref2).getCopy();
        Point p2 = this.connection.getSourceAnchor().getLocation(ref1).getCopy();
        this.connection.translateToRelative((Translatable)min);
        this.connection.translateToRelative((Translatable)p2);
        int x = p2.x;
        int newX = this.point.x;
        int delta = newX - p2.x;
        if (min.x - 20 > p2.x + 20) {
            return x + delta < min.x - 20;
        }
        return true;
    }

    public void undo() {
    }

    public void redo() {
    }
}

