/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

class DiagramOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable {
    private PageBook pageBook;
    private Canvas overview;
    private Thumbnail thumbnail;
    private DisposeListener disposeListener;
    private GraphicalViewer graphicalViewer;

    public DiagramOutlinePage(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        if (this.thumbnail == null) {
            this.initializeOverview();
        }
        this.pageBook.showPage((Control)this.overview);
        this.thumbnail.setVisible(true);
    }

    public void dispose() {
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        super.dispose();
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void initializeOverview() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.getGraphicalViewer().getRootEditPart();
        if (rep instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiagramOutlinePage.this.thumbnail != null) {
                        DiagramOutlinePage.this.thumbnail.deactivate();
                        DiagramOutlinePage.this.thumbnail = null;
                    }
                }
            };
            this.getEditor().addDisposeListener(this.disposeListener);
        }
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return null;
    }

    public void setFocus() {
        if (this.getControl() != null) {
            this.getControl().setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }
}

