/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.AttributeChangeCommand;
import org.eclipse.fordiac.ide.model.commands.create.AttributeCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.AttributeDeleteCommand;
import org.eclipse.fordiac.ide.model.data.BaseType1;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractAttributeSection
extends AbstractSection {
    private TableViewer attributeViewer;
    private final String NAME = "name";
    private final String VALUE = "value";
    private final String TYPE = "type";
    private final String COMMENT = "comment";
    private Button attributeNew;
    private Button attributeDelete;

    protected abstract ConfigurableObject getInputType(Object var1);

    @Override
    protected abstract EObject getType();

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputInfoGroup(parent);
        this.createNewDeleteButton(parent);
    }

    private void createNewDeleteButton(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(0, 4, false, true));
        this.attributeNew = this.getWidgetFactory().createButton(composite, "", 8);
        this.attributeNew.setToolTipText("create attribute");
        this.attributeNew.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.attributeNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AbstractAttributeSection.this.type instanceof ConfigurableObject) {
                    AbstractAttributeSection.this.executeCommand((Command)new AttributeCreateCommand((ConfigurableObject)AbstractAttributeSection.this.type));
                    AbstractAttributeSection.this.attributeViewer.refresh();
                }
            }
        });
        this.attributeDelete = this.getWidgetFactory().createButton(composite, "", 8);
        this.attributeDelete.setToolTipText("delete selected attribute");
        this.attributeDelete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.attributeDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractAttributeSection.this.executeCommand((Command)new AttributeDeleteCommand((ConfigurableObject)AbstractAttributeSection.this.type, (Attribute)((IStructuredSelection)AbstractAttributeSection.this.attributeViewer.getSelection()).getFirstElement()));
                AbstractAttributeSection.this.attributeViewer.refresh();
            }
        });
    }

    private String[] getDataTypes() {
        List<BaseType1> list = Arrays.asList(BaseType1.values());
        Collections.sort(list);
        String[] types = new String[list.size()];
        int i = 0;
        for (BaseType1 type : list) {
            types[i++] = type.getName();
        }
        return types;
    }

    private void createInputInfoGroup(Composite parent) {
        this.attributeViewer = new TableViewer(parent, 65798);
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        gridDataVersionViewer.minimumHeight = 80;
        gridDataVersionViewer.widthHint = 400;
        this.attributeViewer.getControl().setLayoutData((Object)gridDataVersionViewer);
        Table table = this.attributeViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column1.setText("name");
        TableColumn column2 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column2.setText("type");
        TableColumn column3 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column3.setText("value");
        TableColumn column4 = new TableColumn(this.attributeViewer.getTable(), 16384);
        column4.setText("comment");
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 90));
        table.setLayout((Layout)layout);
        this.attributeViewer.setContentProvider((IContentProvider)new InputContentProvider());
        this.attributeViewer.setLabelProvider((IBaseLabelProvider)new InputLabelProvider());
        this.attributeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, this.getDataTypes(), 8), new TextCellEditor((Composite)table, 514), new TextCellEditor((Composite)table)});
        this.attributeViewer.setColumnProperties(new String[]{"name", "type", "value", "comment"});
        this.attributeViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !(element instanceof Attribute) || !"type".equals(property) || ((Attribute)element).getAttributeDeclaration() == null;
            }

            public Object getValue(Object element, String property) {
                switch (property) {
                    case "name": {
                        return ((Attribute)element).getName();
                    }
                    case "value": {
                        return ((Attribute)element).getValue();
                    }
                    case "type": {
                        return ((Attribute)element).getType().getValue();
                    }
                    case "comment": {
                        return ((Attribute)element).getComment();
                    }
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Attribute data = (Attribute)((TableItem)element).getData();
                AttributeChangeCommand cmd = null;
                switch (property) {
                    case "name": {
                        cmd = new AttributeChangeCommand(data, value.toString(), null, null, null);
                        break;
                    }
                    case "value": {
                        cmd = new AttributeChangeCommand(data, null, value.toString(), null, null);
                        break;
                    }
                    case "type": {
                        cmd = new AttributeChangeCommand(data, null, null, BaseType1.get((int)((Integer)value)), null);
                        break;
                    }
                    case "comment": {
                        cmd = new AttributeChangeCommand(data, null, null, null, value.toString());
                    }
                }
                AbstractAttributeSection.this.executeCommand((Command)cmd);
                AbstractAttributeSection.this.attributeViewer.refresh((Object)data);
            }
        });
    }

    public void refresh() {
        super.refresh();
        if (this.type != null) {
            this.attributeViewer.setInput((Object)this.getType());
        }
    }

    @Override
    protected CommandStack getCommandStack(IWorkbenchPart part, Object input) {
        if (part instanceof DiagramEditorWithFlyoutPalette) {
            return ((DiagramEditorWithFlyoutPalette)part).getCommandStack();
        }
        return null;
    }

    @Override
    protected void setInputCode() {
        this.attributeViewer.setCellModifier(null);
    }

    @Override
    protected void setInputInit() {
    }

    public class InputContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Application) {
                return ((Application)inputElement).getAttributes().toArray();
            }
            if (inputElement instanceof Device) {
                return ((Device)inputElement).getAttributes().toArray();
            }
            if (inputElement instanceof Segment) {
                return ((Segment)inputElement).getAttributes().toArray();
            }
            return new Object[0];
        }
    }

    public class InputLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Attribute) {
                switch (columnIndex) {
                    case 0: {
                        return ((Attribute)element).getName();
                    }
                    case 1: {
                        return ((Attribute)element).getType().getName();
                    }
                    case 2: {
                        return ((Attribute)element).getValue();
                    }
                    case 3: {
                        return ((Attribute)element).getComment() != null ? ((Attribute)element).getComment() : "";
                    }
                }
            }
            return element.toString();
        }
    }
}

