/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTreeView;
import org.eclipse.fordiac.ide.deployment.ui.views.Output;
import org.eclipse.fordiac.ide.util.ISelectedElementsChangedListener;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class Mode
extends ViewPart
implements ISelectionListener {
    private Button downloadButton;
    private DownloadSelectionTreeView treeView = null;
    private ISelectedElementsChangedListener changeListener = null;

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.downloadButton = new Button(root, 0);
        this.downloadButton.setText(Messages.Mode_DownloadButtonLabel);
        this.downloadButton.setImage(FordiacImage.ICON_Download.getImage());
        this.downloadButton.setEnabled(false);
        this.downloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected = Mode.this.treeView.getSelectedElements();
                Mode.this.clearDownloadConsole();
                DeploymentCoordinator deployment = DeploymentCoordinator.getInstance();
                deployment.performDeployment(selected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.contributeToActionBars();
        this.getSite().getPage().addSelectionListener("org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTreeView", (ISelectionListener)this);
    }

    private void clearDownloadConsole() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.fordiac.ide.deployment.ui.views.Output");
        if (view != null && view instanceof Output) {
            Output output = (Output)view;
            output.clearOutput();
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    public void setFocus() {
    }

    private ISelectedElementsChangedListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new ISelectedElementsChangedListener(){

                public void selectionChanged() {
                    if (Mode.this.treeView != null && !Mode.this.downloadButton.isDisposed()) {
                        Mode.this.downloadButton.setEnabled(Mode.this.treeView.getSelectedElements().length > 0);
                    }
                }
            };
        }
        return this.changeListener;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof DownloadSelectionTreeView && this.treeView != part) {
            this.treeView = (DownloadSelectionTreeView)part;
            this.treeView.addSelectedElementsChangedListener(this.getChangeListener());
            this.getChangeListener().selectionChanged();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.treeView != null) {
            this.treeView.removeSelectedElementsChangedListener(this.getChangeListener());
        }
    }
}

