/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTree;
import org.eclipse.fordiac.ide.deployment.ui.views.Output;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.systemmanagement.DistributedSystemListener;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.util.ISelectedElementsChangedListener;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class DownloadSelectionTreeView
extends ViewPart {
    private ContainerCheckedTreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private final ArrayList<Device> initialized = new ArrayList();
    private DownloadSelectionTreeView treeView = null;
    private ISelectedElementsChangedListener changeListener = null;
    private final ArrayList<ISelectedElementsChangedListener> listeners = new ArrayList();
    private Button downloadButton;

    public ContainerCheckedTreeViewer getViewer() {
        return this.viewer;
    }

    public DownloadSelectionTreeView() {
        SystemManager.INSTANCE.addWorkspaceListener(new DistributedSystemListener(){

            public void distributedSystemWorkspaceChanged() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!DownloadSelectionTreeView.this.viewer.getTree().isDisposed()) {
                            DownloadSelectionTreeView.this.viewer.refresh(true);
                        }
                    }
                });
            }
        });
    }

    private void initializeDeviceProperties() {
        for (AutomationSystem system : SystemManager.INSTANCE.getSystems()) {
            for (Device dev : system.getSystemConfiguration().getDevices()) {
                if (this.initialized.contains(dev)) continue;
                DownloadSelectionTree.initSelectedProperties(dev);
                this.initialized.add(dev);
            }
        }
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.initializeDeviceProperties();
        this.viewer = new DownloadSelectionTree(composite, 66306);
        this.drillDownAdapter = new DrillDownAdapter((TreeViewer)this.viewer);
        GridData fillBoth = new GridData();
        fillBoth.horizontalAlignment = 4;
        fillBoth.grabExcessHorizontalSpace = true;
        fillBoth.verticalAlignment = 4;
        fillBoth.grabExcessVerticalSpace = true;
        this.viewer.getTree().setLayoutData((Object)fillBoth);
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DownloadSelectionTreeView.this.notifyListeners();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener("org.eclipse.fordiac.ide.deployment.ui.views.DownloadSelectionTreeView", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof DownloadSelectionTreeView && DownloadSelectionTreeView.this.treeView != part) {
                    DownloadSelectionTreeView.this.treeView = (DownloadSelectionTreeView)part;
                    DownloadSelectionTreeView.this.treeView.addSelectedElementsChangedListener(DownloadSelectionTreeView.this.getChangeListener());
                    DownloadSelectionTreeView.this.getChangeListener().selectionChanged();
                }
            }
        });
        this.downloadButton = new Button(composite, 0);
        this.downloadButton.setText(Messages.Mode_DownloadButtonLabel);
        this.downloadButton.setImage(FordiacImage.ICON_Download.getImage());
        this.downloadButton.setLayoutData((Object)new GridData(131072, 4, true, false));
        this.downloadButton.setEnabled(false);
        this.downloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selected = DownloadSelectionTreeView.this.treeView.getSelectedElements();
                DownloadSelectionTreeView.this.clearDownloadConsole();
                DeploymentCoordinator deployment = DeploymentCoordinator.getInstance();
                deployment.performDeployment(selected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.makeActions();
        this.createToolbarbuttons();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void clearDownloadConsole() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.fordiac.ide.deployment.ui.views.Output");
        if (view != null && view instanceof Output) {
            Output output = (Output)view;
            output.clearOutput();
        }
    }

    private ISelectedElementsChangedListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new ISelectedElementsChangedListener(){

                public void selectionChanged() {
                    if (DownloadSelectionTreeView.this.treeView != null && !DownloadSelectionTreeView.this.downloadButton.isDisposed()) {
                        DownloadSelectionTreeView.this.downloadButton.setEnabled(DownloadSelectionTreeView.this.treeView.getSelectedElements().length > 0);
                    }
                }
            };
        }
        return this.changeListener;
    }

    public void dispose() {
        super.dispose();
        if (this.treeView != null) {
            this.treeView.removeSelectedElementsChangedListener(this.getChangeListener());
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(Messages.DownloadSelectionTreeView_LABEL_PopupMenu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DownloadSelectionTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void createToolbarbuttons() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action collapseAllAction = new Action(){

            public void run() {
                DownloadSelectionTreeView.this.viewer.collapseAll();
            }
        };
        collapseAllAction.setText(Messages.DownloadSelectionTreeView_COLLAPSE_ALL);
        collapseAllAction.setToolTipText(Messages.DownloadSelectionTreeView_COLLAPSE_ALL);
        collapseAllAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL"));
        toolBarManager.add((IAction)collapseAllAction);
        Action expandAllAction = new Action(){

            public void run() {
                DownloadSelectionTreeView.this.viewer.expandAll();
            }
        };
        expandAllAction.setText(Messages.DownloadSelectionTreeView_EXPAND_ALL);
        expandAllAction.setToolTipText(Messages.DownloadSelectionTreeView_EXPAND_ALL);
        expandAllAction.setImageDescriptor(FordiacImage.ICON_ExpandAll.getImageDescriptor());
        toolBarManager.add((IAction)expandAllAction);
        Action refresh = new Action(){

            public void run() {
                DownloadSelectionTreeView.this.viewer.refresh(true);
            }
        };
        refresh.setText(Messages.DownloadSelectionTreeView_Refresh);
        refresh.setToolTipText(Messages.DownloadSelectionTreeView_Refresh);
        refresh.setImageDescriptor(FordiacImage.ICON_Refresh.getImageDescriptor());
        toolBarManager.add((IAction)refresh);
    }

    private void makeActions() {
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void addSelectedElementsChangedListener(ISelectedElementsChangedListener listener) {
        if (!this.listeners.contains(listener) && listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectedElementsChangedListener(ISelectedElementsChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ISelectedElementsChangedListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    public Object[] getSelectedElements() {
        return this.viewer.getCheckedElements();
    }
}

