/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannel;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannelDestination;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationModel;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.CanPubSubGenerator;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.EthernetPubSubGenerator;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;

public class ProtocolSelector {
    public static void doAutomatedProtocolSelection(CommunicationModel model) {
        for (CommunicationChannel channel : model.getChannels().values()) {
            ArrayList<Segment> commonSegments = new ArrayList<Segment>();
            Iterator<CommunicationChannelDestination> destinationIterator = channel.getDestinations().iterator();
            CommunicationChannelDestination destination2 = destinationIterator.next();
            for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                commonSegments.add(mediaInfo.getSegment());
            }
            while (destinationIterator.hasNext()) {
                destination2 = destinationIterator.next();
                Iterator segmentIterator = commonSegments.iterator();
                while (segmentIterator.hasNext()) {
                    Segment segment = (Segment)segmentIterator.next();
                    boolean containsSegment = false;
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        if (mediaInfo.getSegment() != segment) continue;
                        containsSegment = true;
                    }
                    if (containsSegment) continue;
                    segmentIterator.remove();
                }
            }
            Segment selectedCommonSegment = null;
            if (commonSegments.size() > 0) {
                ProtocolSelector.sortSegments(commonSegments);
                selectedCommonSegment = commonSegments.get(0);
            }
            block5: for (CommunicationChannelDestination destination2 : channel.getDestinations()) {
                Segment selectedSegment = selectedCommonSegment;
                if (selectedSegment == null) {
                    ArrayList<Segment> availableSegments = new ArrayList<Segment>();
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        availableSegments.add(mediaInfo.getSegment());
                    }
                    ProtocolSelector.sortSegments(availableSegments);
                    if (availableSegments.size() > 0) {
                        selectedSegment = availableSegments.get(0);
                    }
                }
                if (selectedSegment != null) {
                    for (CommunicationMediaInfo mediaInfo : destination2.getAvailableMedia()) {
                        if (mediaInfo.getSegment() != selectedSegment) continue;
                        destination2.setSelectedMedia(mediaInfo);
                        destination2.setSelectedProtocolId(ProtocolSelector.getProtocolIdForMetiaType(mediaInfo.getSegment()));
                        continue block5;
                    }
                    continue;
                }
                System.err.println("No connection available for ");
            }
        }
    }

    private static String getProtocolIdForMetiaType(Segment segment) {
        if (segment.getType().getName().equalsIgnoreCase("Ethernet")) {
            return EthernetPubSubGenerator.PROTOCOL_ID;
        }
        if (segment.getType().getName().equalsIgnoreCase("Can")) {
            return CanPubSubGenerator.PROTOCOL_ID;
        }
        return null;
    }

    private static void sortSegments(ArrayList<Segment> segmentList) {
        Collections.sort(segmentList, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                String name1 = o1.getType().getName();
                String name2 = o2.getType().getName();
                if (name1.equalsIgnoreCase("Can")) {
                    if (name2.equalsIgnoreCase("Can")) {
                        return 0;
                    }
                    return -1;
                }
                if (name1.equalsIgnoreCase("Ethernet")) {
                    if (name2.equalsIgnoreCase("Can")) {
                        return 1;
                    }
                    if (name2.equalsIgnoreCase("Ethernet")) {
                        return 0;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }
}

