/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import org.eclipse.fordiac.ide.application.utilities.ICreationExecutor;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CreationPopupDialog
extends PopupDialog {
    private Object[] elements;
    private LabelProvider labelProvider;
    private ICreationExecutor executor;

    public CreationPopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText, Object[] elements, LabelProvider labelProvider, ICreationExecutor executor) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        this.elements = (Object[])elements.clone();
        this.labelProvider = labelProvider;
        this.executor = executor;
    }

    protected Point getInitialLocation(Point initialSize) {
        Display display = this.getShell().getDisplay();
        return display.getCursorLocation();
    }

    protected Control createDialogArea(Composite parent) {
        Table proposalTable = new Table(parent, 768);
        proposalTable.setRedraw(false);
        proposalTable.setItemCount(this.elements.length);
        TableItem[] items = proposalTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object proposal = this.elements[i];
            item.setText(this.labelProvider.getText(proposal));
            item.setImage(this.labelProvider.getImage(proposal));
            item.setData(proposal);
            ++i;
        }
        proposalTable.setRedraw(true);
        proposalTable.setHeaderVisible(false);
        proposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem selected = (TableItem)e.item;
                    CreationPopupDialog.this.executor.execute(selected.getData());
                }
                CreationPopupDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return proposalTable;
    }
}

