/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.router.RouterUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;

public abstract class EditorWithInterfaceEditPart
extends AbstractFBNetworkEditPart {
    private Figure leftInterfaceContainer;
    private Figure leftEventContainer;
    private Figure leftVarContainer;
    private Figure leftAdapterContainer;
    private Figure rightInterfaceContainer;
    private Figure rightEventContainer;
    private Figure rightVarContainer;
    private Figure rightAdapterContainer;
    private ControlListener controlListener;

    protected IFigure createFigure() {
        this.leftInterfaceContainer = new Figure();
        this.leftEventContainer = new Figure();
        this.leftVarContainer = new Figure();
        this.leftAdapterContainer = new Figure();
        this.rightInterfaceContainer = new Figure();
        this.rightEventContainer = new Figure();
        this.rightVarContainer = new Figure();
        this.rightAdapterContainer = new Figure();
        ToolbarLayout tbl = new ToolbarLayout(false);
        this.leftInterfaceContainer.setLayoutManager((LayoutManager)tbl);
        ToolbarLayout tbl1 = new ToolbarLayout(false);
        this.leftEventContainer.setLayoutManager((LayoutManager)tbl1);
        ToolbarLayout tbl2 = new ToolbarLayout(false);
        this.leftVarContainer.setLayoutManager((LayoutManager)tbl2);
        ToolbarLayout tbl3 = new ToolbarLayout(false);
        this.leftAdapterContainer.setLayoutManager((LayoutManager)tbl3);
        tbl.setMinorAlignment(2);
        tbl1.setMinorAlignment(2);
        tbl2.setMinorAlignment(2);
        tbl3.setMinorAlignment(2);
        this.leftInterfaceContainer.add((IFigure)this.leftEventContainer);
        this.leftInterfaceContainer.add((IFigure)this.leftVarContainer);
        this.leftInterfaceContainer.add((IFigure)this.leftAdapterContainer);
        this.rightInterfaceContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.rightEventContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.rightVarContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.rightAdapterContainer.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.rightInterfaceContainer.add((IFigure)this.rightEventContainer);
        this.rightInterfaceContainer.add((IFigure)this.rightVarContainer);
        this.rightInterfaceContainer.add((IFigure)this.rightAdapterContainer);
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(10));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setOpaque(false);
        f.add((IFigure)this.leftInterfaceContainer);
        f.add((IFigure)this.rightInterfaceContainer);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(RouterUtil.getConnectionRouter((IFigure)f));
        return f;
    }

    public FreeformLayer getCastedFigure() {
        return (FreeformLayer)this.getFigure();
    }

    public Figure getLeftInterfaceContainer() {
        return this.leftInterfaceContainer;
    }

    public Figure getLeftEventInterfaceContainer() {
        return this.leftEventContainer;
    }

    public Figure getLeftVarInterfaceContainer() {
        return this.leftVarContainer;
    }

    public Figure getLeftAdapterInterfaceContainer() {
        return this.leftAdapterContainer;
    }

    public Figure getRightInterfaceContainer() {
        return this.rightInterfaceContainer;
    }

    public Figure getRightEventInterfaceContainer() {
        return this.rightEventContainer;
    }

    public Figure getRightVarInterfaceContainer() {
        return this.rightVarContainer;
    }

    public Figure getRightAdapterInterfaceContainer() {
        return this.rightAdapterContainer;
    }

    protected List<?> getInterfaceChildren() {
        return Collections.EMPTY_LIST;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        super.addChildVisual(childEditPart, index);
    }

    protected void updateInterfacePosition() {
        if (this.getParent() != null && this.getParent().getViewer() != null && this.getParent().getViewer().getControl() != null) {
            int xRight = Integer.MIN_VALUE;
            for (Object obj : this.getChildren()) {
                if (!(obj instanceof AbstractFBNElementEditPart)) continue;
                AbstractFBNElementEditPart part = (AbstractFBNElementEditPart)((Object)obj);
                int xNew = part.getModel().getX() + 150;
                xRight = Math.max(xNew += part.getFigure().getPreferredSize((int)-1, (int)-1).width, xRight);
            }
            Point p = this.getParent().getViewer().getControl().getSize();
            xRight = Math.max(xRight, p.x - this.getRightInterfaceContainer().getSize().width - 20);
            Rectangle rect = new Rectangle(xRight, 0, -1, -1);
            this.getContentPane().setConstraint((IFigure)this.getRightInterfaceContainer(), (Object)rect);
            rect = new Rectangle(0, 0, -1, -1);
            this.getContentPane().setConstraint((IFigure)this.getLeftInterfaceContainer(), (Object)rect);
        }
    }

    protected void refreshVisuals() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlResized(ControlEvent e) {
                    EditorWithInterfaceEditPart.this.updateInterfacePosition();
                }

                public void controlMoved(ControlEvent e) {
                }
            };
            this.getParent().getViewer().getControl().addControlListener(this.controlListener);
        }
        this.updateInterfacePosition();
    }

    public void deactivate() {
        super.deactivate();
        if (this.controlListener != null && this.getParent() != null && this.getParent().getViewer() != null && this.getParent().getViewer().getControl() != null) {
            this.getParent().getViewer().getControl().removeControlListener(this.controlListener);
        }
    }
}

