/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;

public class ConnectionTooltipFigure
extends Figure {
    public ConnectionTooltipFigure(Connection connection) {
        this.setLayoutManager((LayoutManager)new GridLayout());
        StringBuffer label = new StringBuffer();
        if (connection != null) {
            this.getEndpointLabel(label, connection.getSource());
            label.append(" -> ");
            this.getEndpointLabel(label, connection.getDestination());
        }
        Label connNameLabel = new Label(label.toString());
        this.add((IFigure)connNameLabel);
        TextFlow content = new TextFlow(connection != null && connection.getComment() != null ? connection.getComment() : "");
        content.setLayoutManager((LayoutManager)new ParagraphTextLayout(content, 0));
        FlowPage fp = new FlowPage();
        fp.add((IFigure)content);
        if (connection != null && connection.getComment() != null && connection.getComment().length() > 0) {
            this.add((IFigure)fp);
            this.setConstraint((IFigure)fp, new GridData(2, 16, false, true));
        }
        this.setConstraint((IFigure)connNameLabel, new GridData(2, 16, true, true));
    }

    private void getEndpointLabel(StringBuffer label, IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            if (interfaceElement.getFBNetworkElement() != null) {
                label.append(interfaceElement.getFBNetworkElement().getName());
                label.append(".");
            }
            label.append(interfaceElement.getName());
        }
    }
}

