/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.util.AbstractUntypedEditorInputFactory;
import org.eclipse.ui.IMemento;

public class SubApplicationEditorInputFactory
extends AbstractUntypedEditorInputFactory {
    private static final String ID_FACTORY = "org.eclipse.fordiac.ide.application.SubApplicationEditorInputFactory";
    private static final String TAG_APPLICATION = "APPLICATION";
    private static final String TAG_SUB_APPLICATION = "SUB_APPLICATION";

    public IAdaptable createElement(IMemento memento) {
        Application application;
        SubApp subApp;
        AutomationSystem system;
        String systemName = this.loadAutomationSystemName(memento);
        String applicationName = memento.getString(TAG_APPLICATION);
        String subApplicationName = memento.getString(TAG_SUB_APPLICATION);
        if (systemName != null && applicationName != null && (system = SystemManager.INSTANCE.getSystemForName(systemName)) != null && (subApp = (application = system.getApplicationNamed(applicationName)).getFBNetwork().getSubAppNamed(subApplicationName)) != null) {
            return new SubApplicationEditorInput(subApp);
        }
        return null;
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }

    public static void saveState(IMemento memento, SubApplicationEditorInput input) {
        Application app = input.getApplication();
        if (app != null) {
            SubApplicationEditorInputFactory.saveAutomationSystem((IMemento)memento, (AutomationSystem)app.getAutomationSystem());
            memento.putString(TAG_APPLICATION, app.getName());
            memento.putString(TAG_SUB_APPLICATION, input.getName());
        }
    }
}

