---
stage: Plan
group: Project Management
description: Epics, issues, milestones, labels.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Plan and track work

Plan your work by creating requirements, issues, and epics. Schedule work
with milestones and track your team's time. Learn how to save time with
quick actions, see how GitLab renders Markdown text, and learn how to
use Git to interact with GitLab.

<!-- vale gitlab.Spelling = NO -->

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For a thorough demo of Plan features, see
[Multi-team planning with GitLab Ultimate](https://www.youtube.com/watch?v=KmASFwSap7c).
In this video, Gabe describes a use case of a multi-team organization that uses GitLab
with [Scaled Agile Framework (SAFe)](https://handbook.gitlab.com/handbook/marketing/brand-and-product-marketing/product-and-solution-marketing/demo/executive-demo/#scaled-agile-framework-safe).

<!-- vale gitlab.Spelling = YES -->

- [Tutorial: Use GitLab to facilitate scrum](../tutorials/scrum_events/index.md)
- [Labels](../user/project/labels.md)
- [Iterations](../user/group/iterations/index.md)
- [Milestones](../user/project/milestones/index.md)
- [Issues](../user/project/issues/index.md)
- [Issue boards](../user/project/issue_board.md)
- [Comments and threads](../user/discussions/index.md)
- [Tasks](../user/tasks.md)
- [Requirements](../user/project/requirements/index.md)
- [Time tracking](../user/project/time_tracking.md)
- [Customer relations management (CRM)](../user/crm/index.md)
- [Wikis](../user/project/wiki/index.md)
- [Epics](../user/group/epics/index.md)
- [Roadmaps](../user/group/roadmap/index.md)
- [Planning hierarchies](../user/group/planning_hierarchy/index.md)
- [Objectives and key results](../user/okrs.md)
- [Keyboard shortcuts](../user/shortcuts.md)
- [Quick actions](../user/project/quick_actions.md)
- [Markdown](../user/markdown.md)
- [To-Do List](../user/todos.md)
