# frozen_string_literal: true

class FinalizeBackfillHasMergeRequestOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  milestone '17.0'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillHasMergeRequestOfVulnerabilityReads',
      table_name: :vulnerability_reads,
      column_name: :vulnerability_id,
      job_arguments: [],
      finalize: true
    )
  end

  def down; end
end
