////////////////////////////////////////////////////////////////////////////////
/// @file wsW2LTX.h
/// 
/// $Workfile:$
/// 
/// $Author:$
/// $Date:$
/// $Revision:$
/// 
///  Copyright: Ingo H. de Boer
/// 
/// http://www.winshell.org/
/// 
////////////////////////////////////////////////////////////////////////////////

#ifndef WS_W2LTX
#define WS_W2LTX

#ifdef WS_W2LTX_STATIC
	#define WS_W2LTX_API
#else
	#ifdef WS_W2LTX_EXPORTS
		#define WS_W2LTX_API __declspec(dllexport)
	#else
		#define WS_W2LTX_API __declspec(dllimport)
	#endif
#endif

class WS_W2LTX_API wsW2LTX
{
public:
	wsW2LTX();
	~wsW2LTX();

	// required
	void			SetInputName(char* pchInputName);
	bool			Convert();
	
	// optional, virtual
	virtual void	ErrorOut(char* pchErrorMessage);

	// optional
	void			SetOutputName(char* pchOutputName);
	void			SetOutputDirectory(char* pchOutputDirectory);
	void			SetGSFontDirectory(char* pchGSFontDirectory);
	void			SetGSFontMapName(char* pchGSFontMapName);
	void			SetCharSet(char* pchCharSet);
	void			SetPassword(char* pchPassword);
	void			NoGraphics(bool bNoGraphics);

	// information
	static void		GetVersion(char *pchProductVersion, char *pchFileVersion);

private:
	char*			m_pchInputName;
	char*			m_pchOutputName;
	char*			m_pchOutputDirectory;
	char*			m_pchGSFontDirectory;
	char*			m_pchGSFontMapName;
	char*			m_pchCharSet;
	char*			m_pchPassword;
	bool			m_bNoGraphics;
};


#endif // WS_W2LTX
