/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerAttributeRegistry
implements Cloneable {
    public static final String ATTRIBUTE_COMMAND = ".command";
    public static final String ATTRIBUTE_ARGUMENTS = ".arguments";
    public static final String ATTRIBUTE_DDE_VIEW_COMMAND = ".ddeViewCommand";
    public static final String ATTRIBUTE_DDE_VIEW_SERVER = ".ddeViewServer";
    public static final String ATTRIBUTE_DDE_VIEW_TOPIC = ".ddeViewTopic";
    public static final String ATTRIBUTE_DDE_CLOSE_COMMAND = ".ddeCloseCommand";
    public static final String ATTRIBUTE_DDE_CLOSE_SERVER = ".ddeCloseServer";
    public static final String ATTRIBUTE_DDE_CLOSE_TOPIC = ".ddeCloseTopic";
    public static final String ATTRIBUTE_FORMAT = ".format";
    public static final String ATTRIBUTE_INVERSE_SEARCH = ".inverse";
    public static final String ATTRIBUTE_FORWARD_SEARCH = ".forward";
    public static final String INVERSE_SEARCH_NO = "no";
    public static final String INVERSE_SEARCH_RUN = "run";
    public static final String INVERSE_SEARCH_STD = "std";
    public static final String VIEWER_CURRENT = "viewerCurrent";
    public static final String VIEWER_NAMES = "viewerNames";
    static final String VIEWER_NONE = "none";
    private static final String VIEWER_KDVI = "kdvi";
    private static final String VIEWER_XDVI = "xdvi";
    private static final String VIEWER_YAP = "yap";
    private static final String VIEWER_GV = "gv";
    private static final String VIEWER_ACROBAT = "acroread";
    private static final String VIEWER_SUMATRA = "sumatra PDF";
    private static final String VIEWER_ITEXMAC = "itexmac";
    private static final String DEFAULT_ARGUMENTS_KDVI = "%file";
    private static final String DEFAULT_ARGUMENTS_XDVI = "-editor \"echo %f:%l\" -sourceposition \"%line %texfile\" %file";
    private static final String DEFAULT_DIR_YAP = "C:\\texmf\\miktex\\bin";
    private static final String DEFAULT_ARGUMENTS_YAP = "-1 -s \"%line %texfile\" %file";
    private static final String DEFAULT_ARGUMENTS_GV = "%file";
    private static final String DEFAULT_ARGUMENTS_SUMATRA = "-reuse-instance %file";
    private static final String DEFAULT_ARGUMENTS_ACROBAT = "%file";
    private static final String DEFAULT_ARGUMENTS_ITEXMAC = "-a \"/Applications/iTeXMac 1.3.15/iTeXMac.app\" %file";
    private HashMap<String, String> registry = new HashMap();
    private String activeViewer;
    private String[] allViewers;

    public ViewerAttributeRegistry() {
        this.load(TexlipsePlugin.getDefault().getPreferenceStore());
    }

    private static String findFromEnvPath(String filename, String winFilename, String winPath) {
        if (filename.length() == 0) {
            filename = winFilename;
        } else if (winFilename.length() == 0) {
            winFilename = filename;
        }
        return PathUtils.findEnvFile(filename, "/usr/bin", winFilename, winPath);
    }

    public static void initializeDefaults(IPreferenceStore prefs) {
        String def = VIEWER_XDVI;
        String os = System.getProperty("os.name");
        if (os.indexOf("indow") > 0) {
            def = VIEWER_YAP;
        } else if (os.indexOf("OS X") > 0) {
            def = VIEWER_ITEXMAC;
        }
        prefs.setDefault(VIEWER_CURRENT, def);
        ArrayList<String> vlist = new ArrayList<String>();
        vlist.add(VIEWER_XDVI);
        vlist.add(VIEWER_YAP);
        vlist.add(VIEWER_ITEXMAC);
        vlist.add(VIEWER_KDVI);
        vlist.add(VIEWER_GV);
        vlist.add(VIEWER_SUMATRA);
        vlist.add(VIEWER_ACROBAT);
        vlist.add(VIEWER_NONE);
        vlist.remove(def);
        StringBuilder sb = new StringBuilder(def);
        for (String viewer : vlist) {
            sb.append(',');
            sb.append(viewer);
        }
        prefs.setDefault(VIEWER_NAMES, sb.toString());
        prefs.setDefault("none.command", "");
        prefs.setDefault("none.arguments", "");
        prefs.setDefault("none.format", "pdf");
        prefs.setDefault("none.inverse", INVERSE_SEARCH_NO);
        prefs.setDefault("none.forward", "false");
        prefs.setDefault("kdvi.command", ViewerAttributeRegistry.findFromEnvPath(VIEWER_KDVI, "", ""));
        prefs.setDefault("kdvi.arguments", "%file");
        prefs.setDefault("kdvi.format", "dvi");
        prefs.setDefault("kdvi.inverse", INVERSE_SEARCH_RUN);
        prefs.setDefault("kdvi.forward", "true");
        prefs.setDefault("xdvi.command", ViewerAttributeRegistry.findFromEnvPath(VIEWER_XDVI, "", ""));
        prefs.setDefault("xdvi.arguments", DEFAULT_ARGUMENTS_XDVI);
        prefs.setDefault("xdvi.format", "dvi");
        prefs.setDefault("xdvi.inverse", INVERSE_SEARCH_STD);
        prefs.setDefault("xdvi.forward", "true");
        prefs.setDefault("yap.command", ViewerAttributeRegistry.findFromEnvPath("", "yap.exe", DEFAULT_DIR_YAP));
        prefs.setDefault("yap.arguments", DEFAULT_ARGUMENTS_YAP);
        prefs.setDefault("yap.format", "dvi");
        prefs.setDefault("yap.inverse", INVERSE_SEARCH_RUN);
        prefs.setDefault("yap.forward", "true");
        prefs.setDefault("gv.command", ViewerAttributeRegistry.findFromEnvPath(VIEWER_GV, "ghostview.exe", ""));
        prefs.setDefault("gv.arguments", "%file");
        prefs.setDefault("gv.format", "ps");
        prefs.setDefault("gv.inverse", INVERSE_SEARCH_NO);
        prefs.setDefault("gv.forward", "false");
        prefs.setDefault("sumatra PDF.command", ViewerAttributeRegistry.findFromEnvPath("SumatraPDF", "SumatraPDF.exe", "C:\\Program Files\\SumatraPDF"));
        prefs.setDefault("sumatra PDF.arguments", DEFAULT_ARGUMENTS_SUMATRA);
        prefs.setDefault("sumatra PDF.ddeViewCommand", "[ForwardSearch(\"%file\",\"%texfile\",%line,0)]");
        prefs.setDefault("sumatra PDF.ddeViewServer", "SUMATRA");
        prefs.setDefault("sumatra PDF.ddeViewTopic", "control");
        prefs.setDefault("sumatra PDF.format", "pdf");
        prefs.setDefault("sumatra PDF.inverse", INVERSE_SEARCH_NO);
        prefs.setDefault("sumatra PDF.forward", "true");
        prefs.setDefault("acroread.command", ViewerAttributeRegistry.findFromEnvPath(VIEWER_ACROBAT, "acroread.exe", ""));
        prefs.setDefault("acroread.arguments", "%file");
        prefs.setDefault("acroread.ddeViewCommand", "[DocOpen(\"%fullfile\")][FileOpen(\"%fullfile\")]");
        prefs.setDefault("acroread.ddeViewServer", "acroview");
        prefs.setDefault("acroread.ddeViewTopic", "control");
        prefs.setDefault("acroread.ddeCloseCommand", "[DocClose(\"%fullfile\")]");
        prefs.setDefault("acroread.ddeCloseServer", "acroview");
        prefs.setDefault("acroread.ddeCloseTopic", "control");
        prefs.setDefault("acroread.format", "pdf");
        prefs.setDefault("acroread.inverse", INVERSE_SEARCH_NO);
        prefs.setDefault("acroread.forward", "false");
        prefs.setDefault("itexmac.command", ViewerAttributeRegistry.findFromEnvPath("open", "", ""));
        prefs.setDefault("itexmac.arguments", DEFAULT_ARGUMENTS_ITEXMAC);
        prefs.setDefault("itexmac.format", "pdf");
        prefs.setDefault("itexmac.inverse", INVERSE_SEARCH_RUN);
        prefs.setDefault("itexmac.forward", "false");
    }

    public void setDefaults() {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_COMMAND, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_COMMAND));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_ARGUMENTS, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_ARGUMENTS));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_COMMAND, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_COMMAND));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_SERVER, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_SERVER));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_TOPIC, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_TOPIC));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_COMMAND, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_COMMAND));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_SERVER, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_SERVER));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_TOPIC, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_TOPIC));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_FORMAT, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_FORMAT));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_INVERSE_SEARCH, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_INVERSE_SEARCH));
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_FORWARD_SEARCH, TexlipsePlugin.getPreference(String.valueOf(this.activeViewer) + ATTRIBUTE_FORWARD_SEARCH));
    }

    public void load(IPreferenceStore pref) {
        String list = pref.getString(VIEWER_NAMES);
        if (list != null && list.indexOf(44) > 0) {
            String[] names = list.split(",");
            this.allViewers = names;
            int i = 0;
            while (i < names.length) {
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_COMMAND, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_COMMAND));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_ARGUMENTS, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_ARGUMENTS));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_COMMAND, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_COMMAND));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_SERVER, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_SERVER));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_TOPIC, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_VIEW_TOPIC));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_COMMAND, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_COMMAND));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_SERVER, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_SERVER));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_TOPIC, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_DDE_CLOSE_TOPIC));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_FORMAT, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_FORMAT));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_INVERSE_SEARCH, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_INVERSE_SEARCH));
                this.registry.put(String.valueOf(names[i]) + ATTRIBUTE_FORWARD_SEARCH, pref.getString(String.valueOf(names[i]) + ATTRIBUTE_FORWARD_SEARCH));
                ++i;
            }
            if (names.length > 0) {
                this.activeViewer = names[0];
            }
        } else if (list != null && list.length() > 0) {
            this.activeViewer = list;
            this.allViewers = new String[]{list};
            this.setCommand(pref.getString(String.valueOf(list) + ATTRIBUTE_COMMAND));
            this.setArguments(pref.getString(String.valueOf(list) + ATTRIBUTE_ARGUMENTS));
            this.setDDEViewCommand(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_VIEW_COMMAND));
            this.setDDEViewServer(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_VIEW_SERVER));
            this.setDDEViewTopic(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_VIEW_TOPIC));
            this.setDDEViewCommand(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_CLOSE_COMMAND));
            this.setDDEViewServer(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_CLOSE_SERVER));
            this.setDDEViewTopic(pref.getString(String.valueOf(list) + ATTRIBUTE_DDE_CLOSE_TOPIC));
            this.setFormat(pref.getString(String.valueOf(list) + ATTRIBUTE_FORMAT));
            this.setInverse(pref.getString(String.valueOf(list) + ATTRIBUTE_INVERSE_SEARCH));
            this.setForward(pref.getString(String.valueOf(list) + ATTRIBUTE_FORWARD_SEARCH));
        }
    }

    public void save(IPreferenceStore pref, String[] viewers) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < viewers.length) {
            String name = viewers[i];
            String cmdKey = String.valueOf(name) + ATTRIBUTE_COMMAND;
            String argKey = String.valueOf(name) + ATTRIBUTE_ARGUMENTS;
            String ddeViewCommandKey = String.valueOf(name) + ATTRIBUTE_DDE_VIEW_COMMAND;
            String ddeViewServerKey = String.valueOf(name) + ATTRIBUTE_DDE_VIEW_SERVER;
            String ddeViewTopicKey = String.valueOf(name) + ATTRIBUTE_DDE_VIEW_TOPIC;
            String ddeCloseCommandKey = String.valueOf(name) + ATTRIBUTE_DDE_CLOSE_COMMAND;
            String ddeCloseServerKey = String.valueOf(name) + ATTRIBUTE_DDE_CLOSE_SERVER;
            String ddeCloseTopicKey = String.valueOf(name) + ATTRIBUTE_DDE_CLOSE_TOPIC;
            String formatKey = String.valueOf(name) + ATTRIBUTE_FORMAT;
            String invKey = String.valueOf(name) + ATTRIBUTE_INVERSE_SEARCH;
            String frwKey = String.valueOf(name) + ATTRIBUTE_FORWARD_SEARCH;
            pref.setValue(cmdKey, this.registry.get(cmdKey));
            pref.setValue(argKey, this.registry.get(argKey));
            pref.setValue(ddeViewCommandKey, this.registry.get(ddeViewCommandKey));
            pref.setValue(ddeViewServerKey, this.registry.get(ddeViewServerKey));
            pref.setValue(ddeViewTopicKey, this.registry.get(ddeViewTopicKey));
            pref.setValue(ddeCloseCommandKey, this.registry.get(ddeCloseCommandKey));
            pref.setValue(ddeCloseServerKey, this.registry.get(ddeCloseServerKey));
            pref.setValue(ddeCloseTopicKey, this.registry.get(ddeCloseTopicKey));
            pref.setValue(formatKey, this.registry.get(formatKey));
            pref.setValue(invKey, this.registry.get(invKey));
            pref.setValue(frwKey, this.registry.get(frwKey));
            sb.append(name);
            sb.append(',');
            ++i;
        }
        pref.setValue(VIEWER_CURRENT, this.activeViewer);
        sb.delete(sb.length() - 1, sb.length());
        pref.setValue(VIEWER_NAMES, sb.toString());
    }

    public void mergeWith(ViewerAttributeRegistry reg) {
        this.registry.putAll(reg.asMap());
    }

    public String[] getViewerList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.registry.keySet()) {
            if (!key.endsWith(ATTRIBUTE_COMMAND)) continue;
            String name = key.substring(0, key.indexOf(ATTRIBUTE_COMMAND));
            list.add(name);
        }
        Object[] arr = list.toArray(new String[0]);
        Arrays.sort(arr);
        return arr;
    }

    public int getActiveViewerIndex(String[] list) {
        int i = 0;
        while (i < list.length) {
            if (this.activeViewer.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getPreferredViewer(String format) {
        int i = 0;
        while (i < this.allViewers.length) {
            String viewerOutputFormat = this.registry.get(String.valueOf(this.allViewers[i]) + ATTRIBUTE_FORMAT);
            if (viewerOutputFormat.equals(format)) {
                return this.allViewers[i];
            }
            ++i;
        }
        return null;
    }

    public String getActiveViewer() {
        return this.activeViewer;
    }

    public void setActiveViewer(String activeViewer) {
        this.activeViewer = activeViewer;
    }

    public String getCommand() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_COMMAND);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setCommand(String cmd) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_COMMAND, cmd);
    }

    public String getArguments() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_ARGUMENTS);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setArguments(String args) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_ARGUMENTS, args);
    }

    public String getDDEViewCommand() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_COMMAND);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDEViewCommand(String command) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_COMMAND, command);
    }

    public String getDDEViewServer() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_SERVER);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDEViewServer(String server) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_SERVER, server);
    }

    public String getDDEViewTopic() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_TOPIC);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDEViewTopic(String topic) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_VIEW_TOPIC, topic);
    }

    public String getDDECloseCommand() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_COMMAND);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDECloseCommand(String command) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_COMMAND, command);
    }

    public String getDDECloseServer() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_SERVER);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDECloseServer(String server) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_SERVER, server);
    }

    public String getDDECloseTopic() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_TOPIC);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setDDECloseTopic(String topic) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_DDE_CLOSE_TOPIC, topic);
    }

    public String getFormat() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_FORMAT);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setFormat(String format) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_FORMAT, format);
    }

    public String getInverse() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_INVERSE_SEARCH);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setInverse(String inv) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_INVERSE_SEARCH, inv);
    }

    public boolean getForward() {
        String value = this.registry.get(String.valueOf(this.activeViewer) + ATTRIBUTE_FORWARD_SEARCH);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public void setForward(String forward) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_FORWARD_SEARCH, forward);
    }

    public void setForward(boolean forward) {
        this.registry.put(String.valueOf(this.activeViewer) + ATTRIBUTE_FORWARD_SEARCH, String.valueOf(forward));
    }

    public void setValues(Map regMap) {
        this.registry.putAll(regMap);
        this.activeViewer = (String)regMap.get(VIEWER_CURRENT);
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.registry);
        map.put(VIEWER_CURRENT, this.activeViewer);
        return map;
    }

    public Object clone() {
        ViewerAttributeRegistry reg = new ViewerAttributeRegistry();
        reg.registry = new HashMap();
        reg.setValues(this.asMap());
        return reg;
    }

    public void remove(String item) {
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_COMMAND);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_ARGUMENTS);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_VIEW_COMMAND);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_VIEW_SERVER);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_VIEW_TOPIC);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_CLOSE_COMMAND);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_CLOSE_SERVER);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_DDE_CLOSE_TOPIC);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_FORMAT);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_INVERSE_SEARCH);
        this.registry.remove(String.valueOf(item) + ATTRIBUTE_FORWARD_SEARCH);
    }

    public String[] getFormatList() {
        return new String[]{"dvi", "ps", "pdf"};
    }
}

