/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import java.util.ArrayList;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.partitioner.FastLaTeXPartitionScanner;
import net.sourceforge.texlipse.model.OutlineNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TexLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        Image image;
        OutlineNode node = (OutlineNode)element;
        switch (node.getType()) {
            case 14: {
                image = TexlipsePlugin.getImage("preamble");
                break;
            }
            case 0: {
                image = TexlipsePlugin.getImage("part");
                break;
            }
            case 1: {
                image = TexlipsePlugin.getImage("chapter");
                break;
            }
            case 2: {
                image = TexlipsePlugin.getImage("section");
                break;
            }
            case 3: {
                image = TexlipsePlugin.getImage("subsection");
                break;
            }
            case 4: {
                image = TexlipsePlugin.getImage("subsubsection");
                break;
            }
            case 5: {
                image = TexlipsePlugin.getImage("paragraph");
                break;
            }
            case 13: {
                image = TexLabelProvider.getEnvImage(node.getName());
                break;
            }
            case 20: {
                image = TexlipsePlugin.getImage("label");
                break;
            }
            default: {
                image = TexlipsePlugin.getImage("default_outline");
            }
        }
        if (image == null) {
            image = TexlipsePlugin.getImage("default_outline");
        }
        return image;
    }

    public String getText(Object element) {
        ArrayList<OutlineNode> childs;
        OutlineNode node = (OutlineNode)element;
        String text = node.getName();
        if (node.hasChildren() && (childs = node.getChildren()).get(0).getType() == 20) {
            text = String.valueOf(text) + " (L: " + childs.get(0).getName() + ")";
        }
        return text;
    }

    private static Image getEnvImage(String envName) {
        Image image = TexlipsePlugin.getImage(envName);
        if (image == null && FastLaTeXPartitionScanner.isMathEnv(envName)) {
            image = TexlipsePlugin.getImage("formula");
        }
        return image;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

