/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.parallel;

import de.nm.ant.AbstractWorkerTask;
import de.nm.ant.files.fileset.DependsFileSet;
import de.nm.string.XString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Task;

public abstract class AbstractParallelTask
extends AbstractWorkerTask {
    protected final List<DependsFileSet> depends = new ArrayList<DependsFileSet>();
    private boolean error = false;
    private boolean exitOnError = true;
    private boolean failOnAny = false;
    private long keepAliveTime = 60L;
    protected int maxPoolSize = 2048;
    protected int numThreads = 0;
    protected int numThreadsPerProcessor = 0;
    protected boolean parallelQueue = false;
    protected Vector<ParallelRunner> parallelRunner = new Vector();
    protected ThreadPoolExecutor threadPool = null;
    protected LinkedBlockingQueue<Runnable> workQueue = null;

    public void addDependsFileset(DependsFileSet set) {
        this.depends.add(set);
    }

    protected void addRunnerTasks(List<Task> tasks) {
        this.checkInit();
        if (!this.error) {
            ParallelRunner pr = new ParallelRunner(tasks);
            this.threadPool.execute(pr);
        }
    }

    protected void checkInit() {
        if (this.isThread() && this.threadPool == null) {
            this.updateThreadCounts();
            this.workQueue = new LinkedBlockingQueue();
            this.threadPool = new ThreadPoolExecutor(this.numThreads, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue);
            this.threadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    protected List<Task> copyTask(List<Task> nestedTasks) {
        ArrayList<Task> copytask = new ArrayList<Task>(nestedTasks.size());
        try {
            for (Task task : nestedTasks) {
                copytask.add((Task)task.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            this.log("copytask - " + e.getMessage(), 0);
        }
        return copytask;
    }

    protected long getLastModified() {
        long lm = -1L;
        for (DependsFileSet fs : this.depends) {
            String[] files;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            File dir = fs.getDir();
            this.logVerbose(dir);
            String[] stringArray = files = ds.getIncludedFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                File tf = this.createFile(dir, f);
                this.logVerbose(tf, "depends on");
                long l = tf.lastModified();
                if (l > lm) {
                    lm = l;
                }
                ++n2;
            }
        }
        return lm;
    }

    protected boolean isThread() {
        return this.parallelQueue || this.numThreads > 0 || this.numThreadsPerProcessor > 0;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public void setFailOnAny(boolean failOnAny) {
        this.failOnAny = failOnAny;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setThreadCount(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setThreadsPerProcessor(int numThreadsPerProcessor) {
        this.numThreadsPerProcessor = numThreadsPerProcessor;
    }

    public String toString() {
        return XString.concat((int)512, (String[])new String[]{" <AbstractParallelTask ", " numThreads=", String.valueOf(this.numThreads), " numThreadsPerProcessor=", String.valueOf(this.numThreadsPerProcessor), super.toString(), ">"});
    }

    protected void updateThreadCounts() {
        if (this.numThreadsPerProcessor != 0) {
            this.numThreads = Runtime.getRuntime().availableProcessors() * this.numThreadsPerProcessor;
        }
    }

    public void useParallelQueue(LinkedBlockingQueue<Runnable> newQueue, ThreadPoolExecutor newThreadPool) {
        this.parallelQueue = true;
        this.workQueue = newQueue;
        this.threadPool = newThreadPool;
    }

    protected void waitForFinish() {
        if (this.threadPool != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.threadPool.getActiveCount() != 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void logStatus() {
        if (this.parallelQueue) {
            this.logDebug("using external queue!");
        } else if (this.isThread()) {
            this.checkInit();
            this.logDebug(XString.concat((Object[])new Object[]{"using (", this.maxPoolSize, ",", this.numThreads, ",", this.numThreadsPerProcessor, ")"}));
        } else {
            this.logDebug("using no threads!");
        }
    }

    protected class ParallelRunner
    implements Runnable {
        private final List<Task> nestedTasks;

        public ParallelRunner(List<Task> tasks) {
            this.nestedTasks = tasks;
        }

        @Override
        public void run() {
            block4: {
                try {
                    for (Task task : this.nestedTasks) {
                        task.perform();
                    }
                }
                catch (BuildException e) {
                    AbstractParallelTask.this.log(e.getMessage(), 0);
                    if (!AbstractParallelTask.this.failOnAny) break block4;
                    AbstractParallelTask.this.error = true;
                    AbstractParallelTask.this.threadPool.shutdownNow();
                    if (AbstractParallelTask.this.exitOnError) {
                        System.exit(1);
                    }
                    throw new ExitStatusException("Parallel execution interrupted.", 1);
                }
            }
        }
    }
}

