%%
%% This is file `newlfm.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% newlfm.dtx  (with options: `package')
%% 
%% \CharacterTable
%% {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%  Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%  Digits        \0\1\2\3\4\5\6\7\8\9
%%  Exclamation   \!     Double quote  \"     Hash (number) \#
%%  Dollar        \$     Percent       \%     Ampersand     \&
%%  Acute accent  \'     Left paren    \(     Right paren   \)
%%  Asterisk      \*     Plus          \+     Comma         \,
%%  Minus         \-     Point         \.     Solidus       \/
%%  Colon         \:     Semicolon     \;     Less than     \<
%%  Equals        \=     Greater than  \>     Question mark \?
%%  Commercial at \@     Left bracket  \[     Backslash     \\
%%  Right bracket \]     Circumflex    \^     Underscore    \_
%%  Grave accent  \`     Left brace    \{     Vertical bar  \|
%%  Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{newlfm}
              [2003/1/10 v6.0
               Letter-Fax-Memo LaTeX Document Class]



\newcommand{\ifta}{0}\newcommand{\iftb}{0}%
\newcommand{\txa}[1]{\ifthenelse{\ifta=1}{\typeout{#1}}{}}%
\newcommand{\txb}[1]{}%\ifthenelse{\iftb=1}{\typeout{#1}}{}}%
\RequirePackage{keyval}%
\RequirePackage{ifthen}[1997/11/02]%
\RequirePackage{setdim}%
\RequirePackage{fancyhdr}%
\RequirePackage{eso-pic}%
\@ifundefined{ps@@empty}{%
  \ClassError{newlfm}{Version of fancyhdr.sty is not current. \MessageBreak
    Please obtain a recent copy of fancyhdr.sty (Version 1.99d
    or later) from CTAN.}
  {Go to CTAN and download the current version of fancyhdr.sty}}{}
\RequirePackage{calc}[1997/11/11]%
\RequirePackage{graphicx}[1997/06/09]%
\newlength{\measit}\newlength{\addit}
\newlength{\@blka@b}       \newlength{\@blka@a}%
\newlength{\@blkb@b}       \newlength{\@blkb@a}%
\newlength{\@blkc@b}       \newlength{\@blkc@a}%
\newlength{\@dt@sk@b}      \newlength{\@dt@sk@a}%
\newlength{\@addr@fr@sk@b} \newlength{\@addr@fr@sk@a}%
\newlength{\@addr@to@sk@b} \newlength{\@addr@to@sk@a}%
\newlength{\@greet@to@sk@b}\newlength{\@greet@to@sk@a}%
\newlength{\@sig@sk@b}     \newlength{\@sig@sk@a}%
\newlength{\@sig@sp}%
\newlength{\@post@sig@sp@a}%
\newlength{\@post@sig@sp@b}%
\newlength{\@pre@memo@sp}%
\newlength{\@post@memo@sp}%
\newlength{\@marg@left}    \setlength{\@marg@left}{1in}%
\newlength{\@marg@right}   \setlength{\@marg@right}{1in}%
\newlength{\@marg@top}     \setlength{\@marg@top}{1in}%
\newlength{\@marg@bottom}  \setlength{\@marg@bottom}{1in}%
\newlength{\@marg@top@a}   \setlength{\@marg@top@a}{0in}%
\newlength{\@marg@bottom@a}\setlength{\@marg@bottom@a}{0in}%
\newlength{\@marg@top@b}   \setlength{\@marg@top@b}{0in}%
\newlength{\@marg@bottom@b}\setlength{\@marg@bottom@b}{0in}%
\newlength{\@unpr@tp}      \setlength{\@unpr@tp}{0in}%
\newlength{\@unpr@bm}      \setlength{\@unpr@bm}{0in}%
\newlength{\@unpr@rt}      \setlength{\@unpr@rt}{0in}%
\newlength{\@unpr@lt}      \setlength{\@unpr@lt}{0in}%
\newlength{\@marg@left@top@d}     \setlength{\@marg@left@top@d}{.5pt}%
\newlength{\ddh}\newlength{\ddw}%
\newlength{\@H@Hgt}\newlength{\@F@Hgt}\newlength{\@h@hgt}\newlength{\@f@hgt}%
\newlength{\h@Lhgt}\newlength{\h@Chgt}\newlength{\h@Rtgt}%
\newlength{\h@Ldth}\newlength{\h@Cdth}\newlength{\h@Rdth}%
\newlength{\f@Lhgt}\newlength{\f@Chgt}\newlength{\f@Rtgt}%
\newlength{\f@Ldth}\newlength{\f@Cdth}\newlength{\f@Rdth}%
\newlength{\h@lhgt}\newlength{\h@chgt}\newlength{\h@rtgt}%
\newlength{\h@ldth}\newlength{\h@cdth}\newlength{\h@rdth}%
\newlength{\f@lhgt}\newlength{\f@chgt}\newlength{\f@rtgt}%
\newlength{\f@ldth}\newlength{\f@cdth}\newlength{\f@rdth}%
\newlength{\addv}\newlength{\@Plg}\newlength{\@Pwd}%
\newlength{\@above@caption@skip}\newlength{\@below@caption@skip}%
\newlength{\cmndlen}\newlength{\extrlen}%
\newlength{\addrlen}    \newlength{\addrmen}%
\newlength{\plz}\newlength{\pzz}\newlength{\@box@w}%
\newlength{\pa}\newlength{\pb}\newlength{\pc}\newlength{\pd}% Determine length of boxes
\newlength{\@text@width}\newlength{\@text@height}%
\newlength{\@marg@left@r}\newlength{\@marg@left@l}%
\newsavebox{\sigbox}\newsavebox{\b@addr@fr}\newsavebox{\b@addr@to}%
\newsavebox{\@x@sCh}\newsavebox{\@x@sLh}\newsavebox{\@x@sRh}%
\newsavebox{\@x@sCf}\newsavebox{\@x@sLf}\newsavebox{\@x@sRf}%
\newsavebox{\@x@sch}\newsavebox{\@x@slh}\newsavebox{\@x@srh}%
\newsavebox{\@x@scf}\newsavebox{\@x@slf}\newsavebox{\@x@srf}%
\newsavebox{\fba}
\newcounter{@c@pos}%
\newcounter{figure}%
\newcounter{table}%
\newboolean{@addr@fr@l}%
\newboolean{@addr@fr@p}%
\newboolean{@addr@fr@e}            \setboolean{@addr@fr@e}{false}%
\newboolean{@addr@fr@f}            \setboolean{@addr@fr@f}{false}%
\newboolean{@addr@fr@t}            \setboolean{@addr@fr@t}{false}%
\newboolean{@dt@l}                 \setboolean{@dt@l}{true}%
\newboolean{@dt@c}                 \setboolean{@dt@c}{false}%
\newboolean{@dt@p}%
\newboolean{@fax@m@run}            \setboolean{@fax@m@run}{false}%
\newboolean{@s@b@s}                \setboolean{@s@b@s}{false}%
\newboolean{@greet@p}
\newboolean{@greet@l}%
\newboolean{@sig@l}                \setboolean{@sig@l}{true}%
\newboolean{@sig@c}                \setboolean{@sig@l}{false}%
\newboolean{@use@sig}%
\newboolean{@use@sig@nm}%
\newboolean{@lang@amer}            \setboolean{@lang@amer}{true}%
\newboolean{@lang@engl}            \setboolean{@lang@engl}{false}%
\newboolean{@lang@germ}            \setboolean{@lang@germ}{false}%
\newboolean{@lang@frnc}            \setboolean{@lang@frnc}{false}%
\newboolean{@lang@othr}            \setboolean{@lang@othr}{false}%
\newboolean{@lang@pigl}            \setboolean{@lang@pigl}{false}%
\newboolean{@marg@flush@top}       \setboolean{@marg@flush@top}{false}%
\newboolean{@marg@use}             \setboolean{@marg@use}{false}%
\newboolean{@marg@luse}            \setboolean{@marg@luse}{false}%
\newboolean{@marg@ruse}            \setboolean{@marg@ruse}{false}%
\newboolean{@marg@Luse}            \setboolean{@marg@Luse}{false}%
\newboolean{@marg@Ruse}            \setboolean{@marg@Ruse}{false}%
\newboolean{@Lf@use}               \setboolean{@Lf@use}{false}
\newboolean{@Cf@use}               \setboolean{@Cf@use}{false}
\newboolean{@Rf@use}               \setboolean{@Rf@use}{false}
\newboolean{@LOf@use}              \setboolean{@LOf@use}{false}
\newboolean{@COf@use}              \setboolean{@COf@use}{false}
\newboolean{@ROf@use}              \setboolean{@ROf@use}{false}
\newboolean{@lf@use}               \setboolean{@lf@use}{false}
\newboolean{@cf@use}               \setboolean{@cf@use}{false}
\newboolean{@rf@use}               \setboolean{@rf@use}{false}
\newboolean{@Lh@use}               \setboolean{@Lh@use}{false}
\newboolean{@Ch@use}               \setboolean{@Ch@use}{false}
\newboolean{@Rh@use}               \setboolean{@Rh@use}{false}
\newboolean{@LUh@use}              \setboolean{@LUh@use}{false}
\newboolean{@CUh@use}              \setboolean{@CUh@use}{false}
\newboolean{@RUh@use}              \setboolean{@RUh@use}{false}
\newboolean{@lh@use}               \setboolean{@lh@use}{false}
\newboolean{@ch@use}               \setboolean{@ch@use}{false}
\newboolean{@rh@use}               \setboolean{@rh@use}{false}
\newboolean{@bg@use}               \setboolean{@bg@use}{false}
\newboolean{@Bg@use}               \setboolean{@Bg@use}{false}
\newboolean{@memo@bl}%
\newboolean{@memo@a}
\newboolean{@memo@b}               \setboolean{@memo@b}{false}%
\newboolean{@memo@c}               \setboolean{@memo@c}{false}%
\newboolean{@memo@d}               \setboolean{@memo@d}{false}%
\newboolean{@memo@e}               \setboolean{@memo@e}{true}%
\newboolean{@memo@f}               \setboolean{@memo@f}{true}%
\newboolean{@memo@g}               \setboolean{@memo@g}{true}%
\newboolean{@memo@h}               \setboolean{@memo@h}{false}%
\newboolean{@memo@i}               \setboolean{@memo@i}{false}%
\newboolean{@memo@j}               \setboolean{@memo@j}{false}%
\newboolean{@memo@k}               \setboolean{@memo@k}{false}%
\newboolean{@memo@l}               \setboolean{@memo@l}{false}%
\newboolean{@memo@m}               \setboolean{@memo@m}{false}%
\newboolean{@memo@n}               \setboolean{@memo@n}{false}%
\newboolean{@pr@regard}            \setboolean{@pr@regard}{false}%
\newboolean{@set@env}              \setboolean{@set@env}{false}%
\newboolean{@sig@p}%
\newboolean{@sig@mp}%
\newboolean{@addr@to@l}%
\newboolean{@addr@to@p}%
\newboolean{@addr@to@f}            \setboolean{@addr@to@f}{false}%
\newboolean{@addr@to@e}            \setboolean{@addr@to@e}{false}%
\newboolean{@addr@to@t}            \setboolean{@addr@to@t}{false}%
\newboolean{@fax@hdr@pg}%
\newboolean{@fax@RA}%
\newboolean{@fax@RU}%
\newboolean{@fax@bla}              \setboolean{@fax@bla}{true}%
\newboolean{@fax@blb}              \setboolean{@fax@blb}{false}%
\newboolean{@use@all@fr}%
\newboolean{@use@all@to}%
\newboolean{@use@envlab}           \setboolean{@use@envlab}{false}%
\newboolean{@no@cen}               \setboolean{@no@cen}{false}
\newboolean{@no@spc}               \setboolean{@no@spc}{false}
\newboolean{@b@h}                  \setboolean{@b@h}{false}
\newboolean{@b@f}                  \setboolean{@b@f}{false}
\newboolean{@b@r}                  \setboolean{@b@r}{false}
\newboolean{@b@l}                  \setboolean{@b@l}{false}
\newboolean{@B@h}                  \setboolean{@B@h}{false}
\newboolean{@B@f}                  \setboolean{@B@f}{false}
\newboolean{@B@r}                  \setboolean{@B@r}{false}
\newboolean{@B@l}                  \setboolean{@B@l}{false}
\providecommand{\@d@pos}[1]{#1}\providecommand{\@t@pos}[1]{#1}\providecommand{\@f@pos}[1]{#1}
\providecommand{\d@pos}[1]{\renewcommand{\@d@pos}{#1}}
\providecommand{\t@pos}[1]{\renewcommand{\@t@pos}{#1}}
\providecommand{\f@pos}[1]{\renewcommand{\@f@pos}{#1}}
\def\Dimens{\@ifnextchar[%]
\Dimens@i{\Dimens@i[]}}
\def\Dimens@i[#1]{{\setkeys{dx}{#1}}}
\def\Language{\@ifnextchar[%]
\Lang@i{\Lang@i[]}}
\def\Lang@i[#1]{{\setkeys{lg}{#1}}}
\def\MemoParam{\@ifnextchar[%]
\MemoP@i{\MemoP@i[]}}
\def\MemoP@i[#1]{{\setkeys{mp}{#1}}}
\def\LetterParam{\@ifnextchar[%]
\LetrP@i{\LetrP@i[]}}
\def\LetrP@i[#1]{{\setkeys{lp}{#1}}}
\def\FAZParam{\@ifnextchar[%]
\FAXP@i{\FAXP@i[]}}
\def\FAXP@i[#1]{{\setkeys{fx}{#1}}}
\def\LetterP#1{\setkeys{lp}{#1}}
\def\LanguageP#1{\setkeys{lg}{#1}}
\def\FAXP#1{\setkeys{fx}{#1}}
\def\DimensP#1{\setkeys{dx}{#1}}
\def\MemoP#1{\setkeys{mp}{#1}}
\newcommand{\iffixt}[2]{\ifthenelse{\equal{#1}{true}}{\setboolean{#2}{true}}{}}
\newcommand{\iffixf}[2]{\ifthenelse{\equal{#1}{true}}{\setboolean{#2}{false}}{}}
\newcommand{\iffixq}[2]{\ifthenelse{\equal{#1}{true}}{#2}{}}
\providecommand{\defaultlanguage}{}%
\providecommand{\@date@phr}{}       \providecommand{\DatePhrase}[1]{}%
\providecommand{\@fax@cover@line}{} \providecommand{\PhrFAXcovp}[1]{}%
\providecommand{\@fax@page@count}{} \providecommand{\PhrFAXpgcnt}[1]{}%
\providecommand{\@email@phr}{}      \providecommand{\PhrEmail}[1]{}  %
\providecommand{\@fax@phr}{}        \providecommand{\PhrFax}[1]{}%
\providecommand{\@pager@phr}{}      \providecommand{\PhrPager}[1]{}%
\providecommand{\@doc@phr}{}        \providecommand{\PhrDocument}[1]{}%
\providecommand{\@phn@phr}{}        \providecommand{\PhrPhone}[1]{}%
\providecommand{\@re@phr}{}         \providecommand{\PhrRe}[1]{}%
\providecommand{\@subre@phr}{}      \providecommand{\PhrSubre}[1]{}%
\providecommand{\@cc@phr}{}         \providecommand{\PhrCc}[1]{}%
\providecommand{\@ps@phr}{}         \providecommand{\PhrPs}[1]{}%
\providecommand{\@m@phr}{}          \providecommand{\PhrMessage}[1]{}%
\providecommand{\@pps@phr}{}        \providecommand{\PhrPps}[1]{}%
\providecommand{\@ppps@phr}{}       \providecommand{\PhrPpps}[1]{}%
\providecommand{\@encl@phr}{}       \providecommand{\PhrEncl}[1]{}%
\providecommand{\@hnto@phr}{}       \providecommand{\PhrTo}[1]{}%
\providecommand{\@hnfr@phr}{}       \providecommand{\PhrFrom}[1]{}%
\providecommand{\@am@phr}{}%
\providecommand{\@regard@phr}{}     \providecommand{\PhrRegard}[1]{}%
\renewcommand{\DatePhrase}[1]{\renewcommand{\@date@phr}{#1}}%
\renewcommand{\PhrFAXcovp}[1]{\renewcommand{\@fax@cover@line}{#1}}%
\renewcommand{\PhrFAXpgcnt}[1]{\renewcommand{\@fax@page@count}{#1}}%
\renewcommand{\PhrEmail}[1]{\renewcommand{\@email@phr}{#1}}%
\renewcommand{\PhrFax}[1]{\renewcommand{\@fax@phr}{#1}}
\renewcommand{\PhrPager}[1]{\renewcommand{\@pager@phr}{#1}}%
\renewcommand{\PhrDocument}[1]{\renewcommand{\@doc@phr}{#1}}%
\renewcommand{\PhrPhone}[1]{\renewcommand{\@phn@phr}{#1}}%
\renewcommand{\PhrRe}[1]{\renewcommand{\@re@phr}{#1}}%
\renewcommand{\PhrSubre}[1]{\renewcommand{\@subre@phr}{#1}}%
\renewcommand{\PhrCc}[1]{\renewcommand{\@cc@phr}{#1}}%
\renewcommand{\PhrPs}[1]{\renewcommand{\@ps@phr}{#1}}%
\renewcommand{\PhrMessage}[1]{\renewcommand{\@m@phr}{#1}}%
\renewcommand{\PhrPps}[1]{\renewcommand{\@pps@phr}{#1}}%
\renewcommand{\PhrPpps}[1]{\renewcommand{\@ppps@phr}{#1}}%
\renewcommand{\PhrEncl}[1]{\renewcommand{\@encl@phr}{#1}}%
\renewcommand{\PhrTo}[1]{\renewcommand{\@hnto@phr}{#1}}%
\renewcommand{\PhrFrom}[1]{\renewcommand{\@hnfr@phr}{#1}}%
\renewcommand{\PhrRegard}[1]{\renewcommand{\@regard@phr}{#1}}%
\renewcommand{\defaultlanguage}{american}%
\renewcommand{\@am@phr}{%
  \DatePhrase{Date}%
  \PhrFAXcovp{FAX Cover Page}%
  \PhrFAXpgcnt{FAX Page Count}%
  \PhrFax{FAX}%
  \PhrPager{Pager}%
  \PhrEmail{E-mail}%
  \PhrDocument{Document}%
  \PhrPhone{Telephone}%
  \PhrRe{Re}%
  \PhrSubre{\ensuremath{\mathrm{Re}_2}}%
  \PhrCc{cc}%
  \PhrPs{Ps}%
  \PhrMessage{Message}%
  \PhrPps{Pps}%
  \PhrPpps{Ppps}%
  \PhrEncl{Encl}%
  \PhrPager{Page}%
  \PhrTo{To}%
  \PhrFrom{From}%
  \PhrRegard{Regarding}%
}
\InputIfFileExists{extracd.tex}%
  {\typeout{Reading alternative macro definitions from extracd.tex}}%
  {\typeout{All language information must be in newlfm.cls}}%
\DeclareOption{french}%
{\renewcommand{\defaultlanguage}{french}\setboolean{@lang@frnc}{true} \@fr@phr}%
\define@key{lg}{french}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{french}\setboolean{@lang@frnc}{true} \@fr@phr}}%
\DeclareOption{german}%
{\renewcommand{\defaultlanguage}{german}\setboolean{@lang@germ}{true} \@gr@phr}%
\define@key{lg}{german}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{german}\setboolean{@lang@germ}{true} \@gr@phr}}%
\DeclareOption{american}%
{\renewcommand{\defaultlanguage}{american}\setboolean{@lang@amer}{true} \@am@phr}%
\define@key{lg}{american}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{american}\setboolean{@lang@amer}{true} \@am@phr}}%
\DeclareOption{english}%
{\renewcommand{\defaultlanguage}{english}\setboolean{@lang@engl}{true} \@en@phr}%
\define@key{lg}{english}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{english}\setboolean{@lang@engl}{true} \@en@phr}}%
\DeclareOption{othlang}%
{\renewcommand{\defaultlanguage}{othlang}\setboolean{@lang@othr}{true} \@ot@phr}%
\define@key{lg}{othlang}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{othlang}\setboolean{@lang@othr}{true} \@ot@phr}}%
\DeclareOption{piglatin}%
{\renewcommand{\defaultlanguage}{piglatin}\setboolean{@lang@pigl}{true} \@pl@phr}%
\define@key{lg}{piglatin}[true]%
{\iffixq{#1}{\renewcommand{\defaultlanguage}{piglatin}\setboolean{@lang@pigl}{true} \@pl@phr}}%
\define@key{dx}{textwidthsize}{\setlength{\@text@width}{#1}}
\newcommand*{\textwidthsize}[1]{\setlength{\@text@width}{#1}}%
\define@key{dx}{textheightsize}{\setlength{\@text@height}{#1}}
\newcommand*{\textheightsize}[1]{\setlength{\@text@height}{#1}}%
\define@key{dx}{bottommarginskip}{\setlength{\@marg@bottom@a}{#1}}%
\newcommand*{\bottommarginskip}[1]{\setlength{\@marg@bottom@a}{#1}}%
\define@key{dx}{bottommarginskipbelow}{\setlength{\@marg@bottom@b}{#1}}%
\newcommand*{\bottommarginskipbelow}[1]{\setlength{\@marg@bottom@b}{#1}}%
\newcommand*{\spbmarg}[1]{\setlength{\@marg@bottom}{#1}}%
\newcommand*{\sztmarg}[1]{\setlength{\@marg@top}{#1}}%
\newcommand*{\topmarginskip}[1]{\setlength{\@marg@top@a}{#1}}%
\define@key{dx}{topmarginskip}{\setlength{\@marg@top@a}{#1}}%
\newcommand*{\headermarginskip}[1]{\setlength{\@marg@top@b}{#1}}%
\define@key{dx}{headermarginskip}{\setlength{\@marg@top@b}{#1}}%
\newcommand*{\rightmarginsize}[1]{\setlength{\@marg@right}{#1}}%
\newcommand*{\szrmarg}[1]{\setlength{\@marg@right}{#1}}%
\define@key{dx}{rightmarginsize}{\setlength{\@marg@right}{#1}}%
\newcommand*{\szlmarg}[1]{\setlength{\@marg@left}{#1}}%
\newcommand*{\leftmarginsize}[1]{\setlength{\@marg@left}{#1}}%
\define@key{dx}{leftmarginsize}{\setlength{\@marg@left}{#1}}%
\newcommand*{\headermarginsize}[1]{\setlength{\@marg@top}{#1}}%
\define@key{dx}{headermarginsize}{\setlength{\@marg@top}{#1}}%
\newcommand*{\footermarginsize}[1]{\setlength{\@marg@bottom}{#1}}%
\define@key{dx}{footermarginsize}{\setlength{\@marg@bottom}{#1}}%
\newcommand*{\leftmargintopdist}[1]{\setlength{\@marg@left@top@d}{#1}%
  \setboolean{@marg@flush@top}{true}}%
\define@key{dx}{leftmargintopdist}%
  {\setlength{\@marg@left@top@d}{#1}\setboolean{@marg@flush@top}{true}}%
\newcommand*{\splmargt}[1]{\setlength{\@marg@left@top@d}{#1}%
  \setboolean{@marg@flush@top}{true}}%
\define@key{dx}{leftmarginskipleft}{
  \setlength{\@marg@left@l}{#1}\setboolean{@marg@flush@top}{false}}%
\newcommand*{\leftmarginskipleft}[1]{\setlength{\@marg@left@l}{#1}}%
\newcommand*{\splmargl}[1]{\setlength{\@marg@left@l}{#1}}%
\newcommand*{\leftmarginskipright}[1]{\setlength{\@marg@left@r}{#1}}%
\newcommand*{\splmargr}[1]{\setlength{\@marg@left@r}{#1}}%
\define@key{dx}{leftmarginskipright}{\setlength{\@marg@left@r}{#1}}%
\newcommand*{\dateskipbefore}[1]{\setlength{\@dt@sk@b}{#1}}%
\newcommand*{\spbefdate}[1]{\setlength{\@dt@sk@b}{#1}}%
\define@key{dx}{dateskipbefore}{\setlength{\@dt@sk@b}{#1}}%
\newcommand*{\dateskipafter}[1]{\setlength{\@dt@sk@a}{#1}}%
\newcommand*{\spaftdate}[1]{\setlength{\@dt@sk@a}{#1}}%
\define@key{dx}{dateskipafter}{\setlength{\@dt@sk@a}{#1}}%
\newcommand*{\addrfromskipafter}[1]{\setlength{\@addr@fr@sk@a}{#1}}%
\newcommand*{\spaftfraddr}[1]{\setlength{\@addr@fr@sk@a}{#1}}%
\define@key{dx}{addrfromskipafter}{\setlength{\@addr@fr@sk@a}{#1}}%
\newcommand*{\addrfromskipbefore}[1]{\setlength{\@addr@fr@sk@b}{#1}}%
\newcommand*{\spbeffraddr}[1]{\setlength{\@addr@fr@sk@b}{#1}}%
\define@key{dx}{addrfromskipbefore}{\setlength{\@addr@fr@sk@b}{#1}}%
\newcommand*{\addrtoskipafter}[1]{\setlength{\@addr@to@sk@a}{#1}}%
\newcommand*{\spafttoaddr}[1]{\setlength{\@addr@to@sk@a}{#1}}%
\define@key{dx}{addrtoskipafter}{\setlength{\@addr@to@sk@a}{#1}}%
\newcommand*{\addrtoskipbefore}[1]{\setlength{\@addr@to@sk@b}{#1}}%
\define@key{dx}{addrtoskipbefore}{\setlength{\@addr@to@sk@b}{#1}}%
\newcommand*{\greettoskipafter}[1]{\setlength{\@greet@to@sk@a}{#1}}%
\newcommand*{\spaftgreet}[1]{\setlength{\@greet@to@sk@a}{#1}}%
\define@key{dx}{greettoskipafter}{\setlength{\@greet@to@sk@a}{#1}}%
\newcommand*{\sigskipbefore}[1]{\setlength{\@sig@sk@b}{#1}}%
\newcommand*{\spbefsig}[1]{\setlength{\@sig@sk@b}{#1}}%
\define@key{dx}{sigskipbefore}{\setlength{\@sig@sk@b}{#1}}%
\newcommand*{\spaftsig}[1]{\setlength{\@sig@sk@a}{#1}}%
\newcommand*{\sigskipafter}[1]{\setlength{\@sig@sk@a}{#1}}%
\define@key{dx}{sigskipafter}{\setlength{\@sig@sk@a}{#1}}%
\newcommand*{\sigsize}[1]{\setlength{\@sig@sp}{#1}}%
\define@key{dx}{sigsize}{\setlength{\@sig@sp}{#1}}%
\newcommand*{\postsigskipafter}[1]{\setlength{\@post@sig@sp@a}{#1}}%
\newcommand*{\sppostsig}[1]{\setlength{\@post@sig@sp@a}{#1}}%
\define@key{dx}{postsigskipafter}{\setlength{\@post@sig@sp@a}{#1}}% %
\newcommand*{\postsigskipbefore}[1]{\setlength{\@post@sig@sp@b}{#1}}%
\define@key{dx}{postsigskipbefore}{\setlength{\@post@sig@sp@b}{#1}}% %
\newcommand*{\spaftmemo}[1]{\setlength{\@post@memo@sp}{#1}}%
\newcommand*{\memoskipafter}[1]{\setlength{\@post@memo@sp}{#1}}%
\define@key{dx}{memoskipafter}{\setlength{\@post@memo@sp}{#1}}%
\newcommand*{\memoskipbefore}[1]{\setlength{\@pre@memo@sp}{#1}}%
\define@key{dx}{memoskipbefore}{\setlength{\@pre@memo@sp}{#1}}%
\newcommand*{\unprtop}[1]{\setlength{\@unpr@tp}{#1}}
\define@key{dx}{unprtop}{\setlength{\@unpr@tp}{#1}}%
\newcommand*{\unprbottom}[1]{\setlength{\@unpr@bm}{#1}}
\define@key{dx}{unprbottom}{\setlength{\@unpr@bm}{#1}}%
\newcommand*{\unprright}[1]{\setlength{\@unpr@rt}{#1}}
\define@key{dx}{unprright}{\setlength{\@unpr@rt}{#1}}%
\newcommand*{\unprleft}[1]{\setlength{\@unpr@lt}{#1}}
\define@key{dx}{unprleft}{\setlength{\@unpr@lt}{#1}}%
\setkeys{dx}{textwidthsize=-1pt,textheightsize=-1pt,bottommarginskip=5pt,%
headermarginskip=0pt,rightmarginsize=72pt,leftmarginsize=72pt,bottommarginskipbelow=5pt,%
leftmargintopdist=-1pt,addrtoskipafter=18pt,unprright=-1pt,%
leftmarginskipleft=10pt,leftmarginskipright=10pt,dateskipbefore=20pt,%
dateskipafter=36pt,addrfromskipafter=36pt,addrfromskipbefore=0pt,
greettoskipafter=18pt,sigskipbefore=12pt,sigskipafter=12pt,sigsize=72pt,%
postsigskipafter=10pt,memoskipafter=15pt,memoskipbefore=35pt,unprtop=-1pt,unprbottom=-1pt,%
unprleft=-1pt}%
\newcommand{\@opt@stm}{\setboolean{@addr@fr@p}{false} %
                        \setboolean{@addr@to@p}{false} %
                        \setboolean{@memo@bl}{true}%
                        \setboolean{@greet@p}{false}%
                        \setboolean{@dt@l}{false}%
                        \setboolean{@dt@c}{false}%
                        \setboolean{@dt@p}{false}%
                        \setboolean{@sig@p}{false}%
                        \setboolean{@sig@mp}{true}%
                       }%
\newcommand{\@opt@flm}  {\setboolean{@addr@fr@p}{false} %
                         \setboolean{@addr@to@p}{false} %
                         \setboolean{@memo@bl}{true}%
                         \setboolean{@greet@p}{false}%
                         \setboolean{@dt@l}{false}%
                         \setboolean{@dt@c}{false}%
                         \setboolean{@dt@p}{false}%
                         \setboolean{@sig@p}{false}%
                         \setboolean{@sig@mp}{false}%
                         \setboolean{@memo@b}{true}%
                         \setboolean{@memo@c}{true}%
                         \setboolean{@memo@d}{true}%
                         \setboolean{@memo@h}{true}%
                         \setboolean{@memo@i}{true}%
                         \setboolean{@memo@j}{true}%
                         \setboolean{@memo@k}{true}%
                         \setboolean{@memo@l}{true}%
                         \setboolean{@memo@m}{true}%
                         \setboolean{@memo@n}{true}%
                        }%
\DeclareOption{memoaddrto}   {\setboolean{@memo@b}{true}}%
\define@key{mp}{memoaddrto}[true]{\iffixt{@memo@b}{true}}%
\DeclareOption{memoemailto}  {\setboolean{@memo@k}{true}}%
\define@key{mp}{memoemailto}[true]{\iffixt{@memo@k}{true}}%
\DeclareOption{memophoneto}  {\setboolean{@memo@c}{true}}%
\define@key{mp}{memophoneto}[true]{\iffixt{@memo@c}{true}}%
\DeclareOption{memopagerto}  {\setboolean{@memo@n}{true}}%
\define@key{mp}{memopagerto}[true]{\iffixt{@memo@n}{true}}%
\DeclareOption{memofaxto}    {\setboolean{@memo@d}{true}}%
\define@key{mp}{memofaxto}[true]{\iffixt{@memo@d}{true}}%
\DeclareOption{memoaddrfrom} {\setboolean{@memo@h}{true}}%
\define@key{mp}{memoaddrfrom}[true]{\iffixt{@memo@h}{true}}%
\DeclareOption{memoemailfrom}{\setboolean{@memo@l}{true}}%
\define@key{mp}{memoemailfrom}[true]{\iffixt{@memo@l}{true}}%
\DeclareOption{memopagerfrom}{\setboolean{@memo@m}{true}}%
\define@key{mp}{memopagerfrom}[true]{\iffixt{@memo@m}{true}}%
\DeclareOption{memophonefrom}{\setboolean{@memo@i}{true}}%
\define@key{mp}{memophonefrom}[true]{\iffixt{@memo@i}{true}}%
\DeclareOption{memofaxfrom}  {\setboolean{@memo@j}{true}}%
\define@key{mp}{memofaxfrom}[true]{\iffixt{@memo@j}{true}}%
\DeclareOption{memodate}     {\setboolean{@dt@p}{true}}%
\define@key{mp}{memodate}[true]{\iffixt{@dt@p}{true}}%
\DeclareOption{memonofrom}   {\setboolean{@memo@e}{true}}%
\define@key{mp}{memonofrom}[true]{\iffixt{@memo@e}{true}}%
\DeclareOption{memonoto}     {\setboolean{@memo@g}{true}}%
\define@key{mp}{memonoto}[true]{\iffixt{@memo@g}{true}}%
\DeclareOption{memonore}     {\setboolean{@memo@f}{true}}%\
\define@key{mp}{memonore}[true]{\iffixt{@memo@f}{true}}%
\DeclareOption{fullmemo}{\@opt@flm}%
\define@key{mp}{fullmemo}[true]{\iffixq{#1}{\@opt@flm}}%
\DeclareOption{stdmemo}{\@opt@stm}%
\define@key{mp}{stdmemo}[true]{\iffixq{#1}{\@opt@stm}}%
\DeclareOption{faxhp}{\setboolean{@fax@hdr@pg}{true}\setboolean{@fax@RA}{false}}%
\DeclareOption{faxheaderpage}{\setboolean{@fax@hdr@pg}{true}\setboolean{@fax@RA}{false}}%
\define@key{fx}{faxheaderpage}[true]%
{\iffixq{#1}{\setboolean{@fax@hdr@pg}{true}\setboolean{@fax@RA}{false}}}%
\DeclareOption{faxhba}%                Print fax header block on leader in right top-margin.
  {\setboolean{@fax@RA}{true}\setboolean{@fax@hdr@pg}{false}}%
\DeclareOption{faxhbb}%                Print fax header block - leader - upper right quad letter
  {\setboolean{@fax@RU}{true}\setboolean{@fax@hdr@pg}{false}}%
\DeclareOption{faxbla}%                Print FAX block in \Rheader
  {\setboolean{@fax@bla}{true}\setboolean{@fax@blb}{false}}%
\DeclareOption{faxblb}%
  {\setboolean{@fax@blb}{true}\setboolean{@fax@bla}{false}}%
\DeclareOption{faxblocka}%             Print FAX block in \Rheader
  {\setboolean{@fax@bla}{true}\setboolean{@fax@blb}{false}}%
\define@key{fx}{faxblocka}[true]%
{\iffixq{#1}{\setboolean{@fax@bla}{true}\setboolean{@fax@blb}{false}}}%
\DeclareOption{faxblockb}%
  {\setboolean{@fax@blb}{true}\setboolean{@fax@bla}{false}}%
\define@key{fx}{faxblockb}[true]%
{\iffixq{#1}{\setboolean{@fax@blb}{true}\setboolean{@fax@bla}{false}}}%
\newcommand{\@opt@slr} {\setboolean{@addr@fr@l}{false}%
                        \setboolean{@addr@fr@p}{true}%
                        \setboolean{@addr@to@p}{true}%
                        \setboolean{@dt@p}{true}%
                        \setboolean{@dt@l}{false}%
                        \setboolean{@dt@c}{false}%
                        \setboolean{@greet@p}{true}%
                        \setboolean{@sig@p}{true}%
                        \setboolean{@sig@mp}{false}%
                        \setboolean{@addr@to@l}{true}%
                        \setboolean{@memo@bl}{false}%
                        \setboolean{@dt@l}{false}%
                        \setboolean{@sig@l}{false}%
                        \setboolean{@sig@c}{false}%
                        \d@pos{1}\t@pos{3}\f@pos{2}}%
\DeclareOption{stdltr} {\@opt@slr}%
\DeclareOption{stdletter}{\@opt@slr}%
\define@key{lp}{stdletter}[true]{\iffixq{#1}{\@opt@slr}}%

\newcommand{\@opt@sln} {\setboolean{@addr@fr@l}{false} %
                        \setboolean{@addr@fr@p}{false} %
                        \setboolean{@addr@to@p}{true} %
                        \setboolean{@dt@p}{true}%
                        \setboolean{@dt@l}{false}%
                        \setboolean{@dt@c}{false}%
                        \setboolean{@greet@p}{true}%
                        \setboolean{@sig@p}{true}%
                        \setboolean{@sig@mp}{false}%
                        \setboolean{@addr@to@l}{true} %
                        \setboolean{@memo@bl}{false}%
                        \setboolean{@dt@l}{false}%
                        \setboolean{@sig@l}{false}%
                        \setboolean{@sig@c}{false}%
                        \d@pos{1}\t@pos{3}\f@pos{2}}%
\DeclareOption{sltrnf} {\@opt@sln}%
\DeclareOption{stdletternofrom} {\@opt@sln}%
\define@key{lp}{stdletternofrom}[true]{\iffixq{#1}{\@opt@sln}}%

\newcommand{\@opt@blr} {\setboolean{@addr@fr@l}{true}%
                        \setboolean{@addr@fr@p}{true}%
                        \setboolean{@memo@bl}{false}%
                        \setboolean{@addr@to@l}{true}%
                        \setboolean{@dt@l}{true}%
                        \setboolean{@dt@c}{false}%
                        \setboolean{@sig@l}{true}%
                        \setboolean{@sig@c}{false}%
                        \setboolean{@sig@p}{true}%
                        \setboolean{@sig@mp}{false}%
                        \d@pos{1}\t@pos{3}\f@pos{2}}
\DeclareOption{busltr} {\@opt@blr}%
\DeclareOption{busletter} {\@opt@blr}%
\define@key{lp}{busletter}[true]{\iffixq{#1}{\@opt@blr}}%

\newcommand{\@opt@bln} {\setboolean{@addr@fr@l}{true}%
                        \setboolean{@addr@fr@p}{false}%
                        \setboolean{@memo@bl}{false}%
                        \setboolean{@addr@to@l}{true}%
                        \setboolean{@dt@l}{true}%
                        \setboolean{@dt@c}{false}%
                        \setboolean{@sig@l}{true}%
                        \setboolean{@sig@p}{true}%
                        \setboolean{@sig@mp}{false}%
                        \setboolean{@sig@c}{false}%
                        \d@pos{1}\t@pos{3}\f@pos{2}}%
\DeclareOption{bltrnf} {\@opt@bln}%
\DeclareOption{busletternofrom} {\@opt@bln}%
\define@key{lp}{busletternofrom}[true]{\iffixq{#1}{\@opt@bln}}%

\DeclareOption{addrfrl}      {\setboolean{@addr@fr@l}{true}}%
\DeclareOption{addrfrr}      {\setboolean{@addr@fr@l}{false}}%
\DeclareOption{addrtol}      {\setboolean{@addr@to@l}{true}}%
\DeclareOption{addrtor}      {\setboolean{@addr@to@l}{false}}%
\DeclareOption{addrfromleft} {\setboolean{@addr@fr@l}{true}}%
\define@key{lp}{addrfromleft}[true]{\iffixt{#1}{@addr@fr@l}}
\DeclareOption{addrfromright}{\setboolean{@addr@fr@l}{false}}%
\define@key{lp}{addrfromright}[true]{\iffixf{#1}{@addr@fr@l}}
\DeclareOption{addrtoleft}   {\setboolean{@addr@to@l}{true}}%
\define@key{lp}{addrtoleft}[true]{\iffixt{#1}{@addr@to@l}}
\DeclareOption{addrtoright}  {\setboolean{@addr@to@l}{false}}%
\define@key{lp}{addrtoright}[true]{\iffixf{#1}{@addr@to@l}}
\DeclareOption{addrtoemail}  {\setboolean{@addr@to@e}{true}}%
\define@key{lp}{addrtoemail}[true]{\iffixt{#1}{@addr@to@e}}
\DeclareOption{addrtophone}  {\setboolean{@addr@to@t}{true}}%
\define@key{lp}{addrtophone}[true]{\iffixt{#1}{@addr@to@t}}
\DeclareOption{addrtofax}    {\setboolean{@addr@to@f}{true}}%
\DeclareOption{addrfromemail}{\setboolean{@addr@fr@e}{true}}%
\define@key{lp}{addrfromemail}[true]{\iffixt{#1}{@addr@fr@e}}
\DeclareOption{addrfromphone}{\setboolean{@addr@fr@t}{true}}%
\define@key{lp}{addrfromphone}[true]{\iffixt{#1}{@addr@fr@t}}
\DeclareOption{addrfromfax}  {\setboolean{@addr@fr@f}{true}}%
\providecommand{\boxht}[1]{}  \providecommand{\boxwd}[1]{}
\providecommand{\@boxht}[1]{} \providecommand{\@boxwd}[1]{}
\renewcommand{\boxht}[1]{\renewcommand{\@boxht}{#1}} \boxht{1in}
\renewcommand{\boxwd}[1]{\renewcommand{\@boxwd}{#1}} \boxwd{2.6in}
\newcommand{\@labname}{nolines,dateno}
\DeclareOption{Avery5160}{\renewcommand{\@labname}{Avery5160,nolines,dateno}
   \boxht{71pt}\boxwd{2.725in}\setlength{\@F@Hgt}{0pt}}
\define@key{lp}{Avery5160}[true]%
{\iffixq{#1}{\renewcommand{\@labname}{Avery5160,nolines,dateno}%
\boxht{71pt}\boxwd{2.725in}}\setlength{\@F@Hgt}{0pt}}%
\DeclareOption{setuplabel}{\setboolean{@set@env}{true}}
\define@key{lp}{setuplabel}[true]{\iffixq{#1}{\setboolean{@set@env}{true}}}
\newcommand{\@dodtf}{\d@pos{1}\t@pos{3}\f@pos{2}}%
\newcommand{\@dofdt}{\d@pos{2}\t@pos{3}\f@pos{1}}%
\newcommand{\@doftd}{\d@pos{3}\t@pos{3}\f@pos{1}}%
\newcommand{\@dosbs}{\d@pos{1}\t@pos{0}\f@pos{0}\setboolean{@s@b@s}{true}}%
\DeclareOption{orddft} {\@dodtf}%
\DeclareOption{orderdatefromto} {\@dodtf}%
\define@key{lp}{orderdatefromto}[true]{\iffixq{#1}{\@dodtf}}%
\DeclareOption{ordfdt} {\@dofdt}%
\DeclareOption{orderfromdateto} {\@dofdt}%
\define@key{lp}{orderfromdateto}[true]{\iffixq{#1}{\@dofdt}}%
\DeclareOption{ordftd} {\@doftd}%
\DeclareOption{orderfromtodate} {\@doftd}%
\define@key{lp}{orderfromtodate}[true]{\iffixq{#1}{\@doftd}}%
\DeclareOption{sidebyside}      {\@dosbs}%
\define@key{lp}{sidebyside}[true]{\iffixq{#1}{\@dosbs}}%
\DeclareOption{margflush}{\setboolean{@marg@flush@top}{true}}%
\define@key{lp}{margflush}[true]{\iffixt{#1}{@marg@flush@top}{true}}%
\DeclareOption{biggap}{\setboolean{@gap@small}{false}}%
\DeclareOption{addrfrno}{\setboolean{@addr@fr@p}{false}}%
\DeclareOption{addrfromno}{\setboolean{@addr@fr@p}{false}}%
\DeclareOption{noaddrfr}{\setboolean{@addr@fr@p}{false}}%
\DeclareOption{noaddrfrom}{\setboolean{@addr@fr@p}{false}}%
\define@key{lp}{noaddrfrom}[true]{\iffixf{#1}{@addr@fr@p}}%
\DeclareOption{addrtono}{\setboolean{@addr@to@p}{false}}%
\DeclareOption{noaddrto}{\setboolean{@addr@to@p}{false}}%
\define@key{lp}{noaddrto}[true]{\iffixf{#1}{@addr@to@p}}%
\DeclareOption{greetno}{\setboolean{@greet@p}{false}}%
\define@key{lp}{nogreet}[true]{\iffixf{#1}{@greet@p}}%
\DeclareOption{dtright}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{false}}%
\DeclareOption{dateright}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{false}}%
\define@key{lp}{dateright}[true]%
{\iffixq{#1}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{false}}}%
\DeclareOption{dtleft}{\setboolean{@dt@l}{true}\setboolean{@dt@c}{false}}%
\DeclareOption{dateleft}{\setboolean{@dt@l}{true}\setboolean{@dt@c}{false}}%
\define@key{lp}{dateleft}[true]%
{\iffixq{#1}{\setboolean{@dt@l}{true}\setboolean{@dt@c}{false}}}%
\DeclareOption{dtcenter}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{true}}%
\DeclareOption{datecenter}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{true}}%
\define@key{lp}{datecenter}[true]%
{\iffixq{#1}{\setboolean{@dt@l}{false}\setboolean{@dt@c}{true}}}%
\DeclareOption{dateno}{\setboolean{@dt@p}{false}}%
\define@key{lp}{dateno}[true]{\iffixf{#1}{@dt@p}}%
\DeclareOption{dateyes}{\setboolean{@dt@p}{true}}%
\DeclareOption{sigleft}{\setboolean{@sig@l}{true}\setboolean{@sig@c}{false}}%
\DeclareOption{signatureleft}{\setboolean{@sig@l}{true}\setboolean{@sig@c}{false}}%
\define@key{lp}{signatureleft}[true]%
{\iffixq{#1}{\setboolean{@sig@l}{true}\setboolean{@sig@c}{false}}}%
\DeclareOption{signaturecenter}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{true}}%
\DeclareOption{sigcenter}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{true}}%
\define@key{lp}{signaturecenter}[true]%
{\iffixq{#1}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{true}}}%
\DeclareOption{sigright}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{false}}%
\DeclareOption{signatureright}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{false}}%
\define@key{lp}{signatureright}[true]%
{\iffixq{#1}{\setboolean{@sig@l}{false}\setboolean{@sig@c}{false}}}%
\DeclareOption{signo}{\setboolean{@sig@p}{false}}%
\DeclareOption{signatureno}{\setboolean{@sig@p}{false}}%
\define@key{lp}{signo}[true]{\iffixf{#1}{@sig@p}}%
\DeclareOption{prafr}{\setboolean{@use@all@fr}{true}}%
\DeclareOption{printallfrom}{\setboolean{@use@all@fr}{true}}%
\define@key{lp}{printallfrom}[true]{\iffixt{#1}{@use@all@fr}}%
\DeclareOption{prato}{\setboolean{@use@all@to}{true}}%
\DeclareOption{printallto}{\setboolean{@use@all@to}{true}}%
\define@key{lp}{printallto}[true]{\iffixt{#1}{@use@all@to}}%
\DeclareOption{blankheader}{\setboolean{@b@h}{true}}%
\define@key{lp}{blankheader}[true]{\iffixt{#1}{@b@h}}%
\DeclareOption{Blankheader}{\setboolean{@B@h}{true}}%
\define@key{lp}{Blankheader}[true]{\iffixt{#1}{@B@h}}%
\DeclareOption{blankfooter}{\setboolean{@b@f}{true}}%
\define@key{lp}{blankfooter}[true]{\iffixt{#1}{@b@f}}%
\DeclareOption{Blankfooter}{\setboolean{@B@f}{true}}%
\define@key{lp}{Blankfooter}[true]{\iffixt{#1}{@B@f}}%
\DeclareOption{blanklmargin}{\setboolean{@b@l}{true}}%
\DeclareOption{blankleftmargin}{\setboolean{@b@l}{true}}%
\define@key{lp}{blankleftmargin}[true]{\iffixt{#1}{@b@l}}%
\DeclareOption{Blankleftmargin}{\setboolean{@B@l}{true}}%
\define@key{lp}{Blankleftmargin}[true]{\iffixt{#1}{@B@l}}%
\DeclareOption{blankrmargin}{\setboolean{@b@r}{true}}%
\DeclareOption{blankrightmargin}{\setboolean{@b@r}{true}}%
\define@key{lp}{blankrightmargin}[true]{\iffixt{#1}{@b@r}}%
\DeclareOption{Blankrightmargin}{\setboolean{@B@r}{true}}%
\define@key{lp}{Blankrightmargin}[true]{\iffixt{#1}{@B@r}}%
\DeclareOption{Blankall}{\setboolean{@B@f}{true}\setboolean{@B@l}{true}
                         \setboolean{@B@h}{true}\setboolean{@B@r}{true}}%
\define@key{lp}{Blankall}[true]%
{\iffixq{#1}{\setboolean{@B@f}{true}\setboolean{@B@l}{true}
             \setboolean{@B@h}{true}\setboolean{@B@r}{true}}}%
\DeclareOption{blankall}{\setboolean{@b@f}{true}\setboolean{@b@l}{true}
                         \setboolean{@b@h}{true}\setboolean{@b@r}{true}}%
\define@key{lp}{blankall}[true]%
{\iffixq{#1}{\setboolean{@b@f}{true}\setboolean{@b@l}{true}
             \setboolean{@b@h}{true}\setboolean{@b@r}{true}}}%
\DeclareOption{Blank}% Fixed
  {\setboolean{@B@f}{true}\setboolean{@B@l}{true}%
   \setboolean{@B@h}{true}\setboolean{@B@r}{true}%
   \setboolean{@b@f}{true}\setboolean{@b@l}{true}%
   \setboolean{@b@h}{true}\setboolean{@b@r}{true}}%
\define@key{lp}{Blank}[true]%
{\iffixq{#1}{\setboolean{@B@f}{true}\setboolean{@B@l}{true}%
   \setboolean{@B@h}{true}\setboolean{@B@r}{true}%
   \setboolean{@b@f}{true}\setboolean{@b@l}{true}%
   \setboolean{@b@h}{true}\setboolean{@b@r}{true}}}%
\DeclareOption{useenvlab}{\setboolean{@use@envlab}{true}}%
\define@key{lp}{useenvlab}[true]{\iffixt{#1}{@use@envlab}}%
\providecommand{\@paper@type}{}\renewcommand{\@paper@type}{letterpaper}
\DeclareOption{letterpaper}{\renewcommand{\@paper@type}{letterpaper}}
\define@key{lp}{letterpaper}[true]%
{\iffixq{#1}{\renewcommand{\@paper@type}{letterpaper}}}%
\DeclareOption{legalpaper}{\renewcommand{\@paper@type}{legalpaper}}
\define@key{lp}{legalpaper}[true]%
{\iffixq{#1}{\renewcommand{\@paper@type}{legalpaper}}}%
\DeclareOption{a4paper}{\renewcommand{\@paper@type}{a4paper}}
\define@key{lp}{a4paper}[true]%
{\iffixq{#1}{\renewcommand{\@paper@type}{a4paper}}}%
\DeclareOption{a3paper}{\renewcommand{\@paper@type}{a3paper}}
\define@key{lp}{a3paper}[true]%
{\iffixq{#1}{\renewcommand{\@paper@type}{a3paper}}}%
\ExecuteOptions{\@paper@type,stdletter,american,memoa}%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\newcommand{\showdim}[1]{%
  \txa{ * * * }
  \txa{*****************************************************************************}
  \txa{Dimensions: #1}%
  \txa{\string\headheight:     \the\headheight, \string\headsep:        \the\headsep}%
  \txa{\string\paperheight:    \the\paperheight, \string\paperwidth:    \the\paperwidth}%
  \txa{\string\textheight:     \the\textheight, \string\footskip:       \the\footskip}%
  \txa{\string\textwidth:      \the\textwidth,  \string\evensidemargin: \the\evensidemargin}%
  \txa{\string\oddsidemargin:  \the\oddsidemargin, \string\columnsep:      \the\columnsep}%
  \txa{\string\topmargin:      \the\topmargin}%
  \txa{*****************************************************************************}
  \txa{ * * * }
}%
\renewcommand{\ifta}{0}%
\showdim{Before LoadClass}%
\PassOptionsToClass{\@paper@type,oneside,final}{letter}%
\LoadClass{letter}%
\showdim{Before addrset}%
\RequirePackage{addrset}%
\IfFileExists{envlab.sty}{\RequirePackage{envlab}}{}%
\showdim{After LoadClass}
\setlength{\voffset}{0in}%
\setlength{\itemsep}{.2em}%
\setlength{\topsep}{.2em}%
\setlength{\partopsep}{0\p@}%
\setlength{\arraycolsep}{5\p@}%
\setlength{\tabcolsep}{6\p@}%
\setlength{\arrayrulewidth}{.4\p@}%
\setlength{\doublerulesep}{2\p@}%
\setlength{\tabbingsep}{\labelsep}%
\skip\@mpfootins = \skip\footins%
\setlength{\fboxsep}{3\p@}%
\setlength{\fboxrule}{.4\p@}%
\providecommand{\geometry}{ }%
\renewcommand{\geometry}[1]{\typeout{Command \string\geometry{items} no longer supported.}%
\typeout{newlfm supports several dimensional commands.  Please check the manual for detail.}%
}%
\renewcommand{\theequation}{\@arabic\c@equation}%
\renewcommand{\footnoterule}{%
  \kern-\p@%
  \hrule \@width .4\columnwidth%
  \kern .6\p@}%
  \long\def\@makefntext#1{%
    \noindent \hangindent 5\p@%
    \hb@xt@5\p@{\hss\@makefnmark}#1}%
\renewcommand{\thefigure}{\@arabic\c@figure}
\providecommand{\figurename}{}\renewcommand{\figurename}{Figure}
\providecommand{\tablename}{} \renewcommand{\tablename}{Table}
\newcommand{\fps@figure}{tbp}\newcommand{\ftype@figure}{1}\newcommand{\ext@figure}{lof}
\newcommand{\fnum@figure}{\figurename~\thefigure}
\newenvironment{figure}{\@float{figure}}{\end@float}
\newenvironment{figure*}{\@dblfloat{figure}}{\end@dblfloat}
\renewcommand\thetable{\@arabic\c@table}
\newcommand{\fps@table}{tbp}\newcommand{\ftype@table}{2}
\newcommand{\ext@table}{lot}
\newcommand{\fnum@table}{\tablename~\thetable}
\newenvironment{table}{\@float{table}}{\end@float}
\newenvironment{table*}{\@dblfloat{table}}{\end@dblfloat}
\setlength\@above@caption@skip{10\p@}\setlength\@below@caption@skip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\@above@caption@skip\sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else\global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi\vskip\@below@caption@skip}
\newcommand{\section}[1]{{\Large {\bfseries #1}}}
\newcommand{\monthname}{% timestamp function
  \ifcase\month%
    \or January\or February\or March\or April \or May\or June%
    \or July\or August\or September\or October \or November\or December%
  \fi%
}%
\newcommand{\timestring}{%
  \begingroup%
    \count0 = \time \divide\count0 by 60%
    \count2 = \count0 % the hour%
    \count4 = \time \multiply\count0 by 60%
    \advance\count4 by -\count0 % the minute%
    \ifnum\count4<10 \toks1 = {0}    \else \toks1 = {}\fi%
    \ifnum\count2<12 \toks0 = {A.M.} %
      \else \toks0 = {P.M.}\advance\count2 by -12\fi%
    \ifnum\count2=0 \count2 = 12 \fi % make midnight 12%
    {\number\count2:\the\toks1 \number\count4%
    \thinspace \the\toks0}%
  \endgroup%
}%
\newcommand{\timestamp}
  {\number\day\space\monthname\space\number\year,\space\timestring}%
\newcommand{\datestamp}
  {\monthname\space\number\day,\space\number\year}%
\newboolean{@hl} \setboolean{@hl}{true}
\newboolean{@fl} \setboolean{@fl}{true}
\newcommand{\noheadline}{\setboolean{@hl}{false}}
\define@key{lp}{noheadline}[true]{\iffixq{#1}{\setboolean{@hl}{false}}}
\newcommand{\nofootline}{\setboolean{@fl}{false}}
\define@key{lp}{nofootline}[true]{\iffixq{#1}{\setboolean{@fl}{false}}}
\newcommand{\nolines}{\setboolean{@fl}{false}\setboolean{@hl}{false}}
\define@key{lp}{nolines}[true]{\iffixq{#1}{\setboolean{@fl}{false}\setboolean{@hl}{false}}}
\newcommand{\@plhl}{1}\newcommand{\nopheadline}
  {\renewcommand{\@plhl}{0}}%
\newcommand{\@plfl}{1}\newcommand{\nopfootline}
  {\renewcommand{\@plfl}{0}}%
\fancypagestyle{ltrhead}{%
  \fancyhf{}%
  \fancyfoot[L]{\@Lfooter}%
  \fancyfoot[C]{\@Cfooter}%
  \fancyfoot[R]{\@Rfooter}%
  \fancyhead[L]{\@Lheader\ifempty{\@LUheader}{}{\vspace*{-.5in}
       \@LUheader \vspace*{.5in}}}%   % section 2 goes here if we go to plan b
  \fancyhead[R]{\@Rheader\ifempty{\@RUheader}{}{}}%
  \fancyhead[C]{\@Cheader}%
  \settoheight{\measit}{\@Rheader}
  \settodepth{\addit}{\@Rheader}
  \addtolength{\measit}{\addit}
  \settoheight{\measit}{\@Lheader}
  \settodepth{\addit}{\@Lheader}
  \addtolength{\measit}{\addit}
  \settoheight{\measit}{\@Cheader}
  \settodepth{\addit}{\@Cheader}
  \addtolength{\measit}{\addit}
}%
\fancypagestyle{othhead}{%
  \fancyhf{}%
  \fancyfoot[L]{\@lfooter}%
  \fancyfoot[C]{\@cfooter}%
  \fancyfoot[R]{\@rfooter}%
  \fancyhead[L]{\@lheader}%
  \fancyhead[R]{\@rheader}%
  \fancyhead[C]{\@cheader}%
}%
\providecommand{\@Backgrd}{ }    \providecommand{\@backgrd}{ }%
\providecommand{\@Lfooter}{ }    \providecommand{\@Cfooter}{ }%
\providecommand{\@Rfooter}{ }    \providecommand{\@lfooter}{ }%
\providecommand{\@cfooter}{ }    \providecommand{\@rfooter}{ }%
\providecommand{\@LOfooter}{ }   \providecommand{\@COfooter}{ }%
\providecommand{\@ROfooter}{ }   \providecommand{\@Lheader}{ }%
\providecommand{\@Cheader}{ }    \providecommand{\@Rheader}{ }%
\providecommand{\@lheader}{ }    \providecommand{\@cheader}{ }%
\providecommand{\@rheader}{ }    \providecommand{\@LUheader}{ }%
\providecommand{\@CUheader}{ }   \providecommand{\@RUheader}{ }%
\providecommand{\@Rmarg}{ }      \providecommand{\@Lmarg}{ }%
\providecommand{\@rmarg}{ }      \providecommand{\@lmarg}{ }%
\newcommand*{\Backgrd}[1]{\setboolean{@Bg@use}{true}\renewcommand{\@Backgrd}{#1}}%
\newcommand*{\backgrd}[1]{\setboolean{@bg@use}{true}\renewcommand{\@backgrd}{#1}}%
\newcommand*{\Lfooter}[1]{\setboolean{@Lf@use}{true}\renewcommand{\@Lfooter}{#1}}%
\newcommand*{\Cfooter}[1]{\setboolean{@Cf@use}{true}\renewcommand{\@Cfooter}{#1}}%
\newcommand*{\Rfooter}[1]{\setboolean{@Rf@use}{true}\renewcommand{\@Rfooter}{#1}}%
\newcommand*{\LOfooter}[1]{\setboolean{@LOf@use}{true}\renewcommand{\@LOfooter}{#1}}%
\newcommand*{\COfooter}[1]{\setboolean{@COf@use}{true}\renewcommand{\@COfooter}{#1}}%
\newcommand*{\ROfooter}[1]{\setboolean{@ROf@use}{true}\renewcommand{\@ROfooter}{#1}}%
\newcommand*{\lfooter}[1]{\setboolean{@lf@use}{true}\renewcommand{\@lfooter}{#1}}%
\newcommand*{\cfooter}[1]{\setboolean{@cf@use}{true}\renewcommand{\@cfooter}{#1}}%
\newcommand*{\rfooter}[1]{\setboolean{@rf@use}{true}\renewcommand{\@rfooter}{#1}}%
\newcommand*{\Lheader}[1]{\setboolean{@Lh@use}{true}\renewcommand{\@Lheader}{#1}}%
\newcommand*{\Cheader}[1]{\setboolean{@Ch@use}{true}\renewcommand{\@Cheader}{#1}}%
\newcommand*{\Rheader}[1]{\setboolean{@Rh@use}{true}\renewcommand{\@Rheader}{#1}}%
\newcommand*{\LUheader}[1]{\setboolean{@LUh@use}{true}\renewcommand{\@LUheader}{#1}}%
\newcommand*{\CUheader}[1]{\setboolean{@CUh@use}{true}\renewcommand{\@CUheader}{#1}}%
\newcommand*{\RUheader}[1]{\setboolean{@RUh@use}{true}\renewcommand{\@RUheader}{#1}}%
\newcommand*{\lheader}[1]{\setboolean{@lh@use}{true}\renewcommand{\@lheader}{#1}}%
\newcommand*{\cheader}[1]{\setboolean{@ch@use}{true}\renewcommand{\@cheader}{#1}}%
\newcommand*{\rheader}[1]{\setboolean{@rh@use}{true}\renewcommand{\@rheader}{#1}}%
\newcommand*{\Rmargin}[1]{\renewcommand{\@Rmarg}{#1}\setboolean{@marg@use}{true}
  \setboolean{@marg@Ruse}{true}}%
\newcommand*{\Lmargin}[1]{\renewcommand{\@Lmarg}{#1}\setboolean{@marg@use}{true}
  \setboolean{@marg@Luse}{true}}%
\newcommand*{\rmargin}[1]{\renewcommand{\@rmarg}{#1}\setboolean{@marg@use}{true}
  \setboolean{@marg@ruse}{true}}%
\newcommand*{\lmargin}[1]{\renewcommand{\@lmarg}{#1}\setboolean{@marg@use}{true}
  \setboolean{@marg@luse}{true}}%
\newcommand{\Prnt@Chk}[7]{
  \ifthenelse{\boolean{#1}}{\ifempty{#6}{}{
    \vspace*{-2\parskip}\vspace*{#6}}}{}
  \ifthenelse{\boolean{#1}}%
    {\ifthenelse{\boolean{#2}}{\begin{flushleft}{#4}\end{flushleft}}%
    {\ifthenelse{\boolean{#3}}%
      {\begin{center}{#4}\end{center}}%
      {\begin{flushright}{#4}\end{flushright}}}%
    }{}%
  \ifthenelse{\boolean{#1}}{#5}{}%
  \ifthenelse{\boolean{#1}}{\ifempty{#7}{}%
    {\vspace*{-2\parskip}\vspace*{#7}}}{}%
}%
\newcommand{\fixphr}[2]{\strut & \parbox[t]{\the\pc}{#1} #2 \\}%
\renewcommand{\ifta}{0}%
\newcommand{\memosec}{%
  \txa{Start of memosec}
  \renewcommand{\ifta}{0}%
  \noindent\ignorespaces%
  \settowidth{\pa}{{\large\bf \@hnfr@phr:\hspace*{1.25em}}}%
  \setlength{\pb}{\textwidth-\pa-.1em}%
  \addtolength{\pb}{-5pt}%
  \settowidth{\pc}{\@phn@phr:\hspace*{2em}}%
  \settowidth{\pd}{\@fax@phr:\hspace*{2em}}%
  \ifthenelse{\lengthtest{\pc<\pd}}{\setlength{\pc}{\the\pd}}{}%
  \settowidth{\pd}{\@pager@phr:\hspace*{2em}}
  \ifthenelse{\lengthtest{\pc<\pd}}{\setlength{\pc}{\the\pd}}{}%
  \settowidth{\pd}{\@email@phr:\hspace*{2em}}
  \ifthenelse{\lengthtest{\pc<\pd}}{\setlength{\pc}{\the\pd}}{}%
  \txa{After length tests}
  { \Large \vspace*{-1em}\setlength{\tabcolsep}{0pt}%
    \setboolean{@memo@a}{false}%
    \vspace*{\@pre@memo@sp}\noindent\par%
    \begin{flushleft}%
      \begin{tabular}{p{\the\pa}l}%
        \ifthenelse{\boolean{@memo@g}}%
          {\setboolean{@memo@a}{true}%
           \strut {\bf \@hnto@phr:} & \@name@to \strut \\%
          \ifthenelse{\boolean{@memo@b}}%
            {\strut & \parbox[t]{\the\pb}%
              {\@addr@to\strut}\strut\\}{}%
          \ifthenelse{\boolean{@memo@c}}%
            {\fixphr{\@phn@phr:}{\@phn@to}}{}%
          \ifthenelse{\boolean{@memo@d}}%
            {\fixphr{\@fax@phr:}{\@fax@to}}{}%
          \ifthenelse{\boolean{@memo@n}}%
            {\fixphr{\@pager@phr:}{\@pager@to}}{}%
          \ifthenelse{\boolean{@memo@k}}%
            {\fixphr{\@email@phr:}{\@email@to}}{}%
          }{}%
        \ifthenelse{\boolean{@memo@e}}
         {\setboolean{@memo@a}{true}%
          \strut {\bf \@hnfr@phr:} &{\@name@fr} \strut \\%
          \ifthenelse{\boolean{@memo@h}}{\strut & %
            \parbox[t]{\the\pb}{\@addr@fr \strut} \strut \\}{}%
          \ifthenelse{\boolean{@memo@i}}%
            {\fixphr{\@phn@phr:}{\@phn@fr}}{}%
          \ifthenelse{\boolean{@memo@j}}%
            {\fixphr{\@fax@phr:}{\@fax@fr}}{}%
          \ifthenelse{\boolean{@memo@m}}%
            {\fixphr{\@pager@phr:}{\@pager@fr}}{}%
          \ifthenelse{\boolean{@memo@l}}%
            {\fixphr{\@email@phr:}{\@email@fr}}{}%
        }{}%
        \ifthenelse{\boolean{@memo@f}}{\setboolean{@memo@a}{true}%
          \strut {\bf \@re@phr:}   &  {\@re@line} \\%
        }{}%
        \ifthenelse{\boolean{@dt@p}}{\strut {\bf \@date@phr:} & \@xdate \\}{}
        \ifthenelse{\boolean{@memo@a}}{\hline}{}%
      \end{tabular}%
    \end{flushleft}%
  }%

  \vspace*{\@post@memo@sp}\noindent\par%
  \txa{End of memosec}
}%
\InputIfFileExists{memosec.tex}%
  {\typeout{Reading {\tt memosec.tex}}}%
  {\typeout{The default definition for memosec is used.  File memosec.tex doesn't exist.}}%
\newcommand*{\faxpage}{%
  { \renewcommand{\ifta}{0}%
    \showdim{Before fax page setup A}%
    \setlength{\ddh}{\paperheight-1in}
    \setlength{\ddw}{\paperwidth-2in}
    \global\setlength{\textwidth}{\paperwidth-2in}
    \txa{\string\paperheight:\paperheight,\string\ddh:\the\ddh}
    \txa{\string\paperwidth:\paperwidth,\string\ddw:\the\ddw}
    \setpage{\ddh}{\ddw}{1in}{1in}{.25in}{3in}{.75in}{.25in}{.25in}
    \newpage\c@page\@ne\interlinepenalty=200%
    \showdim{Before fax page setup B}%
    \thispagestyle{empty}%
    \vspace*{-\the\@H@Hgt}
    \vspace*{.5in}
    \showdim{Inside fax page specification}
    \begin{center}%
      \framebox{\Huge{\@fax@cover@line}} \\%
      \vspace*{.5in} \Large{\@fax@page@count: \ref{totpage}} \\
      \vspace*{.5in} \Large{\timestamp} \\%
    \end{center}%
    \settowidth{\cmndlen}{\LARGE{\@hnto@phr:}}%
    \settowidth{\extrlen}{\LARGE{\@hnfr@phr:}}%
    \ifthenelse{\lengthtest{\cmndlen<\extrlen}}{\setlength{\cmndlen}{\extrlen}}{}%
    \settowidth{\extrlen}{\LARGE{\@m@phr:}}%
    \ifthenelse{\lengthtest{\cmndlen<\extrlen}}{\setlength{\cmndlen}{\extrlen}}{}%
    \setlength{\extrlen}{\the\textwidth-\the\cmndlen}%
    \begin{tabular}{p{\the\cmndlen}p{\the\extrlen}} \hline \\%
    \LARGE{\@hnto@phr:} & %
      \parbox[t]{\extrlen}{\@name@to \strut \\ \@addr@to \strut%
        \ifempty{\@phn@to}{}{\\ \@phn@phr:\space\@phn@to \strut}%
        \ifempty{\@phnb@to}{}{\\ \@phn@phr:\space\@phnb@to \strut}%
        \ifempty{\@phnc@to}{}{\\ \@phn@phr:\space\@phnc@to \strut}%
        \ifempty{\@phnd@to}{}{\\ \@phn@phr:\space\@phnd@to \strut}%
        \ifempty{\@fax@to}{}{\\ \@fax@phr:\space\@fax@to \strut}} \\%
    \hline \vspace*{5pt}%
    \LARGE{\@hnfr@phr:} & \vspace*{5pt}%
      \parbox[t]{\extrlen}{\@name@fr \strut \\ \@addr@fr \strut %%
        \ifempty{\@phn@fr}{}{\\ \@phn@phr:\space\@phn@fr \strut}%
        \ifempty{\@phnb@fr}{}{\\ \@phn@phr:\space\@phnb@fr \strut}%
        \ifempty{\@phnc@fr}{}{\\ \@phn@phr:\space\@phnc@fr \strut}%
        \ifempty{\@phnd@fr}{}{\\ \@phn@phr:\space\@phnd@fr \strut}%
        \ifempty{\@fax@fr}{}{\\ \@fax@phr:\space\@fax@fr \strut}} \\%
    \hline%
    \ifempty{\@fax@mssg}{}{ \strut%
      \LARGE{\@m@phr:} \strut &%
      \parbox[t]{\extrlen}{\strut \@fax@mssg} \strut \\ \hline}%
    \end{tabular}%
  }
  \renewcommand{\ifta}{0}%
}%
\InputIfFileExists{faxpage.tex}%
  {\typeout{Reading FAX page definitions from faxpage.tex}}%
  {\typeout{faxpage definitions stored in newlfm.cls}}%
\newcommand{\faxblocka}{%
  \sbox{\fba}{%
    \framebox[2.5in]{\parbox[b]{2.5in}{\setlength{\tabcolsep}{0pt}
    \begin{tabular}{p{.5in}p{2in}}
    \multicolumn{2}{l}{\Large \hspace*{.25in}
      \@fax@phr{} \@doc@phr} \\ \hline
      \@hnfr@phr:\space & \@name@fr \\
      \@fax@phr:\space & \@fax@fr \\ \hline
      \@hnto@phr:\space & \@name@to \\
      \@fax@phr:\space & \@fax@to \\ \hline
      \@re@phr: & \@re@line
    \end{tabular}}}}}
\newcommand{\faxblockb}{%
  {\parbox[t]{\textwidth}{\fbox{%
    \begin{tabular}{llll}%
    \@hnfr@phr:\space & \@name@fr & \@hnto@phr:\space & \@name@to \\%
    \@fax@phr:\space & \@fax@fr & \@fax@phr:\space & \@fax@to \\%
    \@phn@phr:\space & \@phn@fr & \@phn@phr:\space & \@phn@to \\%
    \@re@phr: & \multicolumn{3}{l}{\parbox[t]{2in}{\@re@line}} \\%
    \end{tabular}%
}}}}%
\newcommand{\ifempty}[3]{\ifthenelse{\equal{#1}{}}{#2}{#3}}%
\newcommand{\ifpempty}[3]{\ifthenelse{\equal{\protect#1}{}}{#2}{#3}}%
\newcommand{\@prnt@sec}[1]{%
  \ifthenelse{#1=\@d@pos}%
    {\Prnt@Chk{@dt@p}{@dt@l}{@dt@c}{\@xdate}{}{\@dt@sk@b}{\@dt@sk@a}}%
    {}%
  \ifthenelse{#1=\@f@pos}%
    {\Prnt@Chk{@addr@fr@p}{@addr@fr@l}{@no@cen}%
      {\usebox{\b@addr@fr}}{}{\@addr@fr@sk@b}{\@addr@fr@sk@a}}%
    {}%
  \ifthenelse{#1=\@t@pos}%
    {\Prnt@Chk{@addr@to@p}{@addr@to@l}{@no@cen}%
      {\@name@to \strut \\ \@addr@to \strut}{}{\@addr@to@sk@b}{\@addr@to@sk@a}}%
    {}%
}%
\newcommand*{\openlfm}{%
  \renewcommand{\ifta}{0}%
  \ifthenelse{\boolean{@marg@use}}%                 Here we set up marginal notes
    {\setlength{\h@Chgt}{-\@H@Hgt+\@marg@left@top@d}% Adjust column top to leftmargintopdist
     \ifthenelse{\boolean{@marg@Luse}}%             Here we set up left-side marginal notes
       {\reversemarginpar
        \marginpar{\vspace*{\the\h@Chgt} \hspace*{\@marg@left@l} \@Lmarg}}{}
     \ifthenelse{\boolean{@marg@Ruse}}%             Here we set up right-side marginal notes
       {\normalmarginpar
        \marginpar{\@Rmarg}}{}
    }{}%
  \ifpempty{\@LUheader}{}{\@LUheader \hfill}%
  \ifpempty{\@CUheader}{}{\hfill \@CUheader \hfill}%
  \ifpempty{\@RUheader}{}{\hfill \@RUheader}%
  \txa{Running memosec}%
  \ifthenelse{\boolean{@memo@bl}}%
    {{\memosec}\setboolean{@dt@p}{false}%
        \setboolean{@no@spc}{true}}% %Memo
       {}%
  \sbox{\b@addr@fr}{\noindent\setlength{\tabcolsep}{0pt}%
    \raggedleft\begin{tabular}{l@{}}%
    \noindent\ignorespaces\@addr@fr\end{tabular}}%
  \settowidth{\addrlen}{\usebox{\b@addr@fr}}%
  \sbox{\b@addr@fr}{\noindent\setlength{\tabcolsep}{0pt}%
    \parbox[t]{\addrlen}{\noindent%
    \begin{tabular}{l@{}}%
      \ignorespaces\@addr@fr
      \ifthenelse{\boolean{@addr@fr@t}}{\\ \@phn@phr: \@phone@fr}{}%
      \ifthenelse{\boolean{@addr@fr@f}}{\\ \@fax@phr: \@fax@fr}{}%
      \ifthenelse{\boolean{@addr@fr@e}}{\\ \@email@phr: \@email@fr}{}%
      \end{tabular}}}%
  \sbox{\b@addr@to}{\noindent\setlength{\tabcolsep}{0pt}%
    \raggedleft\begin{tabular}{l@{}}%
    \noindent\ignorespaces\@name@to \strut \\ \@addr@to
      \ifthenelse{\boolean{@addr@to@t}}{\\ \@phn@phr: \@phone@to}{}%
      \ifthenelse{\boolean{@addr@to@f}}{\\ \@fax@phr: \@fax@to}{}%
      \ifthenelse{\boolean{@addr@to@e}}{\\ \@email@phr: \@email@to}{}%
      \end{tabular}}%
  \settowidth{\addrmen}{\usebox{\b@addr@to}}%
  \sbox{\b@addr@to}{\noindent\setlength{\tabcolsep}{0pt}%
    \parbox[t]{\addrmen}{\noindent%
    \begin{tabular}{l@{}}%
      \ignorespaces\@name@to \strut \\ \@addr@to
      \ifthenelse{\boolean{@addr@to@t}}{\\ \@phn@phr: \@phone@to}{}%
      \ifthenelse{\boolean{@addr@to@f}}{\\ \@fax@phr: \@fax@to}{}%
      \ifthenelse{\boolean{@addr@to@e}}{\\ \@email@phr: \@email@to}{}%
      \end{tabular}}}%
  \ifthenelse{\boolean{@no@spc}}{} {%
    \ifthenelse{\boolean{@s@b@s}}%
      {\par\noindent{\usebox{\b@addr@to} \hfill \usebox{\b@addr@fr}}}%
      {}%
    \setcounter{@c@pos}{1} \@prnt@sec{\the@c@pos}%
    \setcounter{@c@pos}{2} \@prnt@sec{\the@c@pos}%
    \setcounter{@c@pos}{3} \@prnt@sec{\the@c@pos}%
    \setboolean{@greet@l}{true}%
    \ifthenelse{\boolean{@pr@regard}}{\@regard@phr: \@regard@line}{}%
    \Prnt@Chk{@greet@p}{@greet@l}{@no@cen}%
      {\par\@greet@to\par\nobreak}{}{}{\@greet@to@sk@a}%
  } %
  \txa{End of openlfm}
}%
\newcommand{\closlfm}{%
  \renewcommand{\ifta}{0}%
  \txa{In closlfm}
  \par\nobreak%
  \vspace*{\@sig@sk@b}%
  \stopbreaks%
  \noindent%
  \hspace*{\longindentation}%
  \sbox{\sigbox}{\setlength{\tabcolsep}{0pt}%
    \begin{tabular}{l}
       \ignorespaces \@closeline \hspace*{.01pt} \\%
       \vspace*{2\parskip}%
       \ifthenelse{\boolean{@use@sig}}{\@sig@fr}%
         {\vspace*{\@sig@sp}} \\%
       \vspace*{2\parskip}%
       \ifthenelse{\boolean{@use@sig@nm}}{\@sig@nm}{\@name@fr}
    \end{tabular}%
    }%
  \settowidth{\@box@w}{\usebox{\sigbox}}
  \Prnt@Chk{@sig@p}{@sig@l}{@no@cen}%
    {\parbox{\@box@w}{\usebox{\sigbox}}}{}{\@sig@sk@b}{\@sig@sk@a}%
}%
\newcommand*{\@post@sig@bl}[2]{%
  \vspace*{\@post@sig@sp@b}%
  \ifempty{#2}{}{%
    \par\noindent%
    \parbox[t]{\textwidth}{%
      \setlength{\pzz}{\textwidth}%
      \settowidth{\plz}{{\small\normalfont#1:}}%
      \addtolength{\pzz}{-\plz} %
      \@hangfrom{{\small\normalfont#1: }}%
      \ignorespaces \parbox[t]{\pzz}{{\small#2}}\strut}\par}%
  \vspace*{\@post@sig@sp@a}%
}%
\providecommand{\@ltr@info@name}{} \renewcommand{\@ltr@info@name}{letrinfo.tex}
\newcommand{\InfoFileName}[1]{\renewcommand{\@ltr@info@name}{#1}}
\define@key{dx}{InfoFileName}{\renewcommand{\@ltr@info@name}{#1}}
\InputIfFileExists{\@ltr@info@name}%
  {\typeout{Reading default letter definitions from \@ltr@info@name}}%
  {\typeout{All letter definitions must be in newlfm.cls}}%
\providecommand{\@ltr@body}{}%
\providecommand{\ltrbody}{}%
\providecommand{\letterbody}{}%
\renewcommand{\ltrbody}[1]{\renewcommand{\@ltr@body}{#1}}%
\renewcommand{\letterbody}[1]{\renewcommand{\@ltr@body}{#1}}%
\providecommand{\doltr}{}%
\providecommand{\doletter}{}%
\renewcommand{\doltr}[1]%
  {#1 \begin{newlfm} \@ltr@body \end{newlfm} \newpage%
  \ifthenelse{\envopen = 1}%
    {\immediate\write14{\string\envlabel{\string\setadrto{\string#1}} }}{}%
}%
\newcommand{\envlabel}[1]{#1\parbox[t][\@boxht][t]{\@boxwd}%
  {{\@name@to \\ \@addr@to} \hfill}}%
\newcommand{\dims}{left=.165in,top=5pt,textheight=10.6in}%
\newcommand{\makeenvst}{%
  \immediate\openout14=envelope.tex%
  \immediate\write14{\string\documentclass[dvips]{newlfm}}%
  \immediate\write14{\string\pagestyle{empty}\string\thispagestyle{empty}}%
  \immediate\write14{\string\setkeys{lp}{\@labname,letterpaper}}%
  \immediate\write14{\string\setkeys{dx}{textwidthsize=8.3in,textheightsize=10.75in}}%
  \immediate\write14{\string\setkeys{dx}{headermarginsize=10pt,leftmarginsize=20pt}}%
  \immediate\write14{\string\newpage}%
  \immediate\write14{\string\begin{document}}%
  \renewcommand{\envopen}{1}%
  \ifthenelse{\boolean{@hl}}%
    {\renewcommand{\headrulewidth}{1pt}}%
    {\renewcommand{\headrulewidth}{0pt}}%
  \ifthenelse{\boolean{@fl}}%
    {\renewcommand{\footrulewidth}{1pt}}%
    {\renewcommand{\footrulewidth}{0pt}}%
}%
\newcommand{\makeenvfn}{%
  \immediate\write14{\string\end{document}}%
  \immediate\closeout14%
}%
\newcommand{\envopen}{0}%
\renewcommand{\doletter}[1]%
{\setadrto{#1}
 \begin{newlfm} \@ltr@body \end{newlfm} \newpage%
 \ifthenelse{\envopen = 1}%
   {\immediate\write14{\string\envlabel{\string\setadrto{\string#1}}}}%
   {}%
}%
\newenvironment{newlfm}{% Start of fax environment, in fax class%
  \@set@em@up
  \renewcommand{\ifta}{0}%
  \faxblocka%
  \ifthenelse{\boolean{@fax@RA}}%
    {\ifthenelse{\boolean{@fax@bla}}{\Rheader{\usebox{\fba}}}{}%
     \ifthenelse{\boolean{@fax@blb}}{\Rheader{\faxblockb}}{}}%
    {}%
  \ifthenelse{\boolean{@fax@RU}}%
    {\txa{setting up ruh}%
     \ifthenelse{\boolean{@fax@bla}}{\RUheader{\faxblocka}}{}%
     \ifthenelse{\boolean{@fax@blb}}{\RUheader{\faxblockb}}{}}%
    {}%
    \txa{setting up ruh}%
  \renewcommand{\ifta}{0}%
  \ifthenelse{\boolean{@fax@hdr@pg}} {%
   {\txa{FAX Page Setup}%
    \renewcommand{\ifta}{0}%
    \showdim{Before resetting dimensions}%
    \faxpage%
    \renewcommand{\ifta}{0}%
    \txa{Before newpage issued}%
    \newpage%
    \txa{After newpage issued}%
    \showdim{After fax page setup}%
    }%
  }{}%
  \renewcommand{\ifta}{0}%
  \showdim{After fax page section closes}%
  \renewcommand{\ifta}{0}%
  \if@twoside \ifodd\c@page%
              \else\thispagestyle{empty}\null\newpage\fi  \fi%
  \c@page\@ne%
  \interlinepenalty=200 % smaller than the TeXbook value%
  \setlength{\headwidth}{\textwidth}%
  \txa{Before Rfooter}%
  \ifthenelse{\boolean{@B@f}}%
    {\Cfooter{\phantom{\Cfooter}} \Rfooter{\phantom{\Rfooter}} \Lfooter{\phantom{\Lfooter}}} {}%
  \txa{Before Rheader}%
  \ifthenelse{\boolean{@B@h}}%
    {\Rheader{\phantom{\Rheader}} \Lheader{\phantom{\Lheader}} \Cheader{\phantom{\Cheader}}} {}%
  \txa{Before Lmargin}%
  \ifthenelse{\boolean{@B@l}}%
    {\ifempty{\@Lmarg}{}{\Lmargin{\phantom{\Lmargin}}}}{}%
  \txa{Before Rmargin}%
  \ifthenelse{\boolean{@B@r}}%
    {\ifempty{\@Rmarg}{}{\Rmargin{\phantom{\Rmargin}}}}{}%
  \txa{Before rfooter}%
  \ifthenelse{\boolean{@b@f}}%
    {\rfooter{\phantom{\rfooter}} \lfooter{\phantom{\lfooter}} \cfooter{\phantom{\cfooter}}} {}%
  \txa{Before rheader}%
  \ifthenelse{\boolean{@b@h}}%
    {\rheader{\phantom{\rheader}} \lheader{\phantom{\lheader}} \cheader{\phantom{\cheader}}} {}%
  \txa{Before lmargin}%
  \ifthenelse{\boolean{@b@l}}%
    {\lmargin{\phantom{\lmargin}}} {}%
  \txa{Before rmargin}%
  \ifthenelse{\boolean{@b@r}}%
    {\rmargin{\phantom{\rmargin}}} {}%
  \setlength{\textwidth}{\paperwidth-\@marg@right-\@marg@left-1pt}
  \txa{Before opening}%
  \txa{\string\@marg@right: \the\@marg@right, \string\@marg@right: \the\@marg@right}
  \txa{\string\textwidth: \the\textwidth, \string\paperwidth: \the\paperwidth}
  \openlfm%
  \renewcommand{\ifta}{0}%
  \txa{\string\@marg@right: \the\@marg@right, \string\@marg@right: \the\@marg@right}
  \txa{\string\textwidth: \the\textwidth, \string\paperwidth: \the\paperwidth}
  \txa{After opening}%
  \renewcommand{\ifta}{0}%
  \txa{\string\@marg@right: \the\@marg@right, \string\@marg@right: \the\@marg@right}
  \txa{\string\textwidth: \the\textwidth, \string\paperwidth: \the\paperwidth}
  \pagestyle{othhead}  \thispagestyle{ltrhead}%
}%
{
  \renewcommand{\ifta}{0}%
  \txa{At the start of the close of newlfm env}
  \ifthenelse{\boolean{@sig@p}}{
    \txa{Before closing}
    \closlfm%
    \txa{After closing}
    \@post@sig@bl{\@ps@phr}{\@ps@item}%
    \@post@sig@bl{\@pps@phr}{\@pps@item}%
    \@post@sig@bl{\@ppps@phr}{\@ppps@item}%
    \@post@sig@bl{\@encl@phr}{\@encl@item}%
    \@post@sig@bl{\@cc@phr}{\@cc@item}%
   }{}%
  \ifthenelse{\boolean{@sig@mp}}{
    \@post@sig@bl{\@ps@phr}{\@ps@item}%
    \@post@sig@bl{\@pps@phr}{\@pps@item}%
    \@post@sig@bl{\@ppps@phr}{\@ppps@item}%
    \@post@sig@bl{\@encl@phr}{\@encl@item}%
    \@post@sig@bl{\@cc@phr}{\@cc@item}%
   }{}%
  \ifthenelse{\boolean{@use@envlab}}%
    {\newpage%
     \changepage{11in}{8.5in}{1in}{1in}{0in}{0in}{0in}{0in}{0in}%
     \txa{Actually using the makeenvelope...}
     \startlabels%
     \@capitalizeaddressfalse
     \mlabel{\@name@fr \\ \@addr@fr}{\@name@to \\ \@addr@to}}{}%
  \stopletter\@@par\pagebreak\@@par%
  \immediate\write\@auxout{\string\newlabel{totpage}{{\thepage}{0}}}%
}%
\newcommand{\pgrph}[1]{{\bf #1}}%
\pagestyle{ltrhead}%
\pagenumbering{arabic}%
\raggedbottom%
\providecommand{\@texttop}{}%
\renewcommand{\@texttop}
  {\ifnum\c@page=1\vskip \z@ plus.00006fil\relax\fi}%
\onecolumn%
\newcommand{\@set@em@up}{
  \ifthenelse{\boolean{@set@env}}{\makeenvst}{}%
  \ifthenelse{\boolean{@hl}}{\renewcommand{\headrulewidth}{1pt}}
    {\renewcommand{\headrulewidth}{0pt}}%
  \ifthenelse{\boolean{@fl}}{\renewcommand{\footrulewidth}{1pt}}
    {\renewcommand{\footrulewidth}{0pt}}%
  \renewcommand{\ifta}{0}%
  \sbox{\@x@sCh}{\@Cheader}\sbox{\@x@sLh}{\@Lheader}\sbox{\@x@sRh}{\@Rheader}%
  \sbox{\@x@sCf}{\@Cfooter}\sbox{\@x@sLf}{\@Lfooter}\sbox{\@x@sRf}{\@Rfooter}%
  \sbox{\@x@sch}{\@cheader}\sbox{\@x@slh}{\@lheader}\sbox{\@x@srh}{\@rheader}%
  \sbox{\@x@scf}{\@cfooter}\sbox{\@x@slf}{\@lfooter}\sbox{\@x@srf}{\@rfooter}%
  \renewcommand{\ifta}{0}%
  \ifthenelse{\boolean{@Ch@use}}
    {\settoheight{\h@Chgt}{\usebox{\@x@sCh}}
     \settodepth{\h@Cdth}{\usebox{\@x@sCh}}
     \addtolength{\h@Chgt}{\h@Cdth+1pt}%
    }
    {\setlength{\h@Chgt}{0pt}}
  \ifthenelse{\boolean{@Rh@use}}
    {\settoheight{\h@Rtgt}{\usebox{\@x@sRh}}
     \settodepth{\h@Rdth}{\usebox{\@x@sRh}}
     \addtolength{\h@Rtgt}{\h@Rdth+1pt}%
    }
    {\setlength{\h@Rtgt}{0pt}}
  \ifthenelse{\boolean{@Lh@use}}
    {\settoheight{\h@Lhgt}{\usebox{\@x@sLh}}
     \settodepth{\h@Ldth}{\usebox{\@x@sLh}}
     \addtolength{\h@Lhgt}{\h@Ldth+1pt}%
    }
    {\setlength{\h@Lhgt}{0pt}}
  \ifthenelse{\boolean{@ch@use}}
    {\settoheight{\h@chgt}{\usebox{\@x@sch}}
     \settodepth{\h@cdth}{\usebox{\@x@sch}}
     \addtolength{\h@chgt}{\h@cdth+1pt}%
    }
    {\setlength{\h@chgt}{0pt}}
  \ifthenelse{\boolean{@rh@use}}
    {\settoheight{\h@rtgt}{\usebox{\@x@srh}}
     \settodepth{\h@rdth}{\usebox{\@x@srh}}
     \addtolength{\h@rtgt}{\h@rdth+1pt}%
    }
    {\setlength{\h@rtgt}{0pt}}
  \ifthenelse{\boolean{@lh@use}}
    {\settoheight{\h@lhgt}{\usebox{\@x@slh}}
     \settodepth{\h@ldth}{\usebox{\@x@slh}}
     \addtolength{\h@lhgt}{\h@ldth+1pt}%
    }
    {\setlength{\h@lhgt}{0pt}}
  \ifthenelse{\boolean{@Cf@use}}
    {\settoheight{\f@Chgt}{\usebox{\@x@sCf}}
     \settodepth{\f@Cdth}{\usebox{\@x@sCf}}
     \addtolength{\f@Chgt}{\f@Cdth}%
    }
    {\setlength{\f@Chgt}{0pt}}
  \ifthenelse{\boolean{@Rf@use}}
    {\settoheight{\f@Rtgt}{\usebox{\@x@sRf}}
     \settodepth{\f@Rdth}{\usebox{\@x@sRf}}
     \addtolength{\f@Rtgt}{\f@Rdth}
    }
    {\setlength{\f@Rtgt}{0pt}}
  \ifthenelse{\boolean{@Lf@use}}
    {\settoheight{\f@Lhgt}{\usebox{\@x@sLf}}
     \settodepth{\f@Ldth}{\usebox{\@x@sLf}}
     \addtolength{\f@Lhgt}{\f@Ldth}%
    }
    {\setlength{\f@Lhgt}{0pt}}
  \ifthenelse{\boolean{@ch@use}}
    {\settoheight{\f@chgt}{\usebox{\@x@scf}}
     \settodepth{\f@cdth}{\usebox{\@x@scf}}
     \addtolength{\f@chgt}{\f@cdth}%
    }
    {\setlength{\f@chgt}{0pt}}
  \ifthenelse{\boolean{@rh@use}}
    {\settoheight{\f@rtgt}{\usebox{\@x@srf}}
     \settodepth{\f@rdth}{\usebox{\@x@srf}}
     \addtolength{\f@rtgt}{\f@rdth}%
    }
    {\setlength{\f@rtgt}{0pt}}
  \ifthenelse{\boolean{@lh@use}}
    {\settoheight{\f@lhgt}{\usebox{\@x@slf}}
     \settodepth{\f@ldth}{\usebox{\@x@slf}}
     \addtolength{\f@lhgt}{\f@ldth}%
    }
    {\setlength{\f@lhgt}{0pt}}
  \ifthenelse{\lengthtest{\h@Lhgt<\h@Chgt}}
    {\setlength{\@H@Hgt}{\h@Chgt}} {\setlength{\@H@Hgt}{\h@Lhgt}}%
  \ifthenelse{\lengthtest{\@H@Hgt<\h@Rtgt}}  {\setlength{\@H@Hgt}{\h@Rtgt}} {}%
  \ifthenelse{\lengthtest{\@H@Hgt<1pt}}
    {\setlength{\@H@Hgt}{\@marg@top}}
    {\ifthenelse{\lengthtest{\@marg@top@a<\@unpr@tp}}{\setlength{\@marg@top@a}{\@unpr@tp}}{}
     \addtolength{\@H@Hgt}{\@marg@top@a+3pt}
    }%
  \ifthenelse{\lengthtest{\h@lhgt<\h@chgt}}
    {\setlength{\@h@hgt}{\h@chgt}} {\setlength{\@h@hgt}{\h@lhgt}}%
  \ifthenelse{\lengthtest{\@h@hgt<\h@rtgt}}  {\setlength{\@h@hgt}{\h@rtgt}} {}%
  \ifthenelse{\lengthtest{\f@Lhgt<\f@Chgt}}
    {\setlength{\@F@Hgt}{\f@Chgt}} {\setlength{\@F@Hgt}{\f@Lhgt}}%
  \ifthenelse{\lengthtest{\@F@Hgt<\f@Rtgt}}  {\setlength{\@F@Hgt}{\f@Rtgt}} {}%
  \ifthenelse{\lengthtest{\@F@Hgt<1pt}}
    {\setlength{\@F@Hgt}{\@marg@bottom}}
    {\ifthenelse{\lengthtest{\@marg@bottom@b<\@unpr@bm}}
                {\setlength{\@marg@bottom@b}{\@unpr@bm}}{}
     \addtolength{\@F@Hgt}{\@marg@bottom@a+3pt}
    }%
  \ifthenelse{\lengthtest{\f@lhgt<\f@chgt}}%
    {\setlength{\@f@hgt}{\f@chgt}} {\setlength{\@f@hgt}{\f@lhgt}}%
  \ifthenelse{\lengthtest{\@f@hgt<\f@rtgt}}  {\setlength{\@f@hgt}{\f@rtgt}} {}%
  \ifthenelse{\lengthtest{\@marg@left@top@d<1pt}}
    {\setlength{\@marg@left@top@d}{\@H@Hgt+\@marg@top@a}}{}
  \setlength{\@Plg}{\paperheight-\@H@Hgt-\@F@Hgt-\@marg@top@b-\@marg@top@a-
             \@marg@bottom@a-\@marg@bottom@b-\@f@f-\footrulewidth-\headrulewidth}
  \ifthenelse{\lengthtest{\@text@height>.1pt}}{\setlength{\@Plg}{\@text@height}}{}%
  \ifthenelse{\boolean{@Bg@use}}
    {\AddToShipoutPicture*{\@Backgrd}}
    {}
  \renewcommand{\ifta}{0}%
  \txa{\string\h@Chgt: \the\h@Chgt, \string\h@Rtgt: \the\h@Rtgt}%
  \txa{\string\h@Lhgt: \the\h@Lhgt, \string\@H@Hgt: \the\@H@Hgt}%
  \txa{\string\h@chgt: \the\h@chgt, \string\h@rtgt: \the\h@rtgt}%
  \txa{\string\h@lhgt: \the\h@lhgt, \string\@h@hgt: \the\@h@hgt}%
  \txa{\string\f@Chgt: \the\f@Chgt, \string\f@Rtgt: \the\f@Rtgt}%
  \txa{\string\f@Lhgt: \the\f@Lhgt, \string\@F@Hgt: \the\@F@Hgt}%
  \txa{\string\f@chgt: \the\f@chgt, \string\f@rtgt: \the\f@rtgt}%
  \txa{\string\f@lhgt: \the\f@lhgt, \string\@f@hgt: \the\@f@hgt}%
  \txa{\string\@Plg:\the\@Plg, \string\paperheight:\the\paperheight}
  \txa{\string\@H@Hgt:\the\@H@Hgt, \string\@h@hgt:\the\@h@hgt, \string\footskip:\the\footskip}%
  \txa{\string\F@Hgt:\the\@F@Hgt, \string\baselineskip:\the\baselineskip}
  \txa{\string\voffset:\the\voffset, \string\headsep:\the\headsep}%
  \txa{\string\footruleskip:\footruleskip, \string\footrulewidth:\footrulewidth}%
  \txa{\string\@f@f:\@f@f}%
  \ifthenelse{\boolean{@marg@Luse}}%
  {%
    \txa{Setting up left column...}
    \settowidth{\h@Chgt}{\@Lmarg}%
    \ifthenelse{\lengthtest{\@unpr@lt>\@marg@left@l}}{\setlength{\@marg@left@l}{\@unpr@lt}}{}%
    \addtolength{\h@Chgt}{\@marg@left@l}%
    \setlength{\marginparwidth}{\h@Chgt}%
    \setlength{\marginparsep}{\@marg@left@r}%
    \setlength{\@marg@left}{\h@Chgt}%
    \txa{\string\h@Chgt:\the\h@Chgt, \string\marginparwidth:\the\marginparwidth}
    \ifthenelse{\lengthtest{\@marg@left@top@d<1pt}}
      {\setlength{\@marg@left@top@d}{\Hhgt}}{}%
    \txa{Done!}
  }%
  {%
    \setlength{\marginparsep}{0in}%
    \setlength{\marginparwidth}{0in}%
    \ifthenelse{\lengthtest{\@unpr@lt>\@marg@left}}{\setlength{\@marg@left}{\@unpr@lt}}{}%
  }%
  \ifthenelse{\lengthtest{\@unpr@rt>\@marg@right}}{\setlength{\@marg@right}{\@unpr@rt}}{}%
  \setlength{\@Pwd}{\paperwidth-\@marg@left-\@marg@right}
  \ifthenelse{\lengthtest{\@text@width>.1pt}}{\setlength{\@Pwd}{\@text@width}}{}%
  \showdim{At raggedbottom}%
  \raggedbottom%
  \renewcommand{\ifta}{0}%
  \showdim{Before setpage}
  \txa{\string\@marg@top@a:\the\@marg@top@a,\string\@H@Hgt:\the\@H@Hgt}
  \txa{\string\@marg@top@b:\the\@marg@top@b,\string\@F@Hgt:\the\@F@Hgt}
  \txa{\string\@marg@bottom@a:\the\@marg@bottom@a,\string\@H@Hgt:\the\@H@Hgt}
  \txa{\string\@marg@bottom@b:\the\@marg@bottom@b,\string\@F@Hgt:\the\@F@Hgt}
  \txa{\string\@unpr@bm:\the\@unpr@bm,\string\@unpr@tp:\the\@F@Hgt}
  \setpage{\@Plg}{\@Pwd}{\@marg@left-1in}{\@marg@left-1in}{10pt}
    {\@marg@top@a-1in}{\@H@Hgt}{\@marg@top@b}{\@F@Hgt}
  \showdim{After setpage}%
  \setlength{\headwidth}{\textwidth}
}
\AtEndDocument{
  \ifthenelse{\boolean{@set@env}}{\makeenvfn}{}%
}
\AtBeginDocument{
  \renewcommand{\ifta}{0}%
  \txa{AtBeginDocument...}
  \ifthenelse{\boolean{@use@envlab}}
    {
     \IfFileExists{envlab.sty}
       {\makelabels
       }
       {\typeout{The option <useenvlab> was issued.}
        \typeout{File <envlab.sty> cannot be found.}
        \typeout{Option <useenvlab> is disabled}
        \typeout{Please install envlab system.}
        \setboolean{@use@envlab}{false}}}{}
    {}
  \txa{At the very very end...}
}
\endinput%

%%% Local Variables:
%%% mode: latex
%%% TeX-master: t
%%% End:
\endinput
%%
%% End of file `newlfm.cls'.
