/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.decomposition.LUDecomposition;
import lombok.Generated;

public final class CroutDoolittle {
    public static LUDecomposition decompose(FastMatrix M) {
        return CroutDoolittle.decompose(M, Constants.getEpsilon());
    }

    public static LUDecomposition decompose(FastMatrix M, double eps) {
        int n = M.getColumnsCount();
        if (M.getRowsCount() != n) {
            throw new MatrixException("m_err_square");
        }
        double[] lu = M.toArray();
        int[] piv = null;
        double[] LUcolj = new double[n];
        for (int j = 0; j < n; ++j) {
            int jj;
            int i;
            int i2 = 0;
            int idx = j * n;
            while (i2 < n) {
                LUcolj[i2] = lu[idx];
                ++i2;
                ++idx;
            }
            i2 = 0;
            idx = 0;
            while (i2 < n) {
                int kmax = i2 <= j ? i2 : j;
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += lu[idx + k * n] * LUcolj[k];
                }
                int n2 = i2++;
                double d = LUcolj[n2] - s;
                LUcolj[n2] = d;
                lu[idx + j * n] = d;
                ++idx;
            }
            int p = j;
            for (i = j + 1; i < n; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                if (piv == null) {
                    piv = new int[n];
                    for (i = 0; i < n; ++i) {
                        piv[i] = i;
                    }
                }
                int k = 0;
                int pk = p;
                int jk = j;
                while (k < n) {
                    double t = lu[pk];
                    lu[pk] = lu[jk];
                    lu[jk] = t;
                    ++k;
                    pk += n;
                    jk += n;
                }
                int kk = piv[p];
                piv[p] = piv[j];
                piv[j] = kk;
            }
            if (Math.abs(lu[jj = j * n + j]) < eps) {
                throw new MatrixException("m_err_sing");
            }
            for (int i3 = j + 1; i3 < n; ++i3) {
                int n3 = j * n + i3;
                lu[n3] = lu[n3] / lu[jj];
            }
        }
        return new LUDecomposition(FastMatrix.builder(lu).nrows(n).ncolumns(n).build(), piv);
    }

    @Generated
    private CroutDoolittle() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

