/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import jdplus.toolkit.base.api.timeseries.TimePoint;
import jdplus.toolkit.base.api.timeseries.TimeSeriesObs;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TimePointObs
implements TimeSeriesObs<TimePoint> {
    @NonNull
    private final TimePoint period;
    private final double value;

    @NonNull
    public static TimePointObs parse(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        int index = text.toString().indexOf("=");
        if (index < 0) {
            throw new IllegalArgumentException("Invalid TimePointObs text: " + String.valueOf(text));
        }
        return TimePointObs.of(TimePoint.parse(text.subSequence(0, index)), Double.parseDouble(text.subSequence(index + 1, text.length()).toString()));
    }

    public String toString() {
        return String.valueOf(this.period) + "=" + this.value;
    }

    @Generated
    private TimePointObs(@NonNull TimePoint period, double value) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        this.period = period;
        this.value = value;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TimePointObs of(@NonNull TimePoint period, double value) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        return new TimePointObs(period, value);
    }

    @Override
    @NonNull
    @Generated
    public TimePoint getPeriod() {
        return this.period;
    }

    @Override
    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePointObs)) {
            return false;
        }
        TimePointObs other = (TimePointObs)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        TimePoint this$period = this.getPeriod();
        TimePoint other$period = other.getPeriod();
        return !(this$period == null ? other$period != null : !((Object)this$period).equals(other$period));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        TimePoint $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        return result;
    }
}

