/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataWindow;
import jdplus.toolkit.base.core.data.analysis.FFT;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;

public final class ToeplitzMatrix {
    private final double[] r;

    public static double[] solveDurbinSystem(double[] r) {
        int n = r.length - 1;
        double[] y = new double[n];
        double alpha = -r[1] / r[0];
        double beta = r[0];
        y[0] = alpha;
        for (int k = 0; k < n - 1; ++k) {
            beta *= 1.0 - alpha * alpha;
            double tmp = 0.0;
            for (int i = k; i >= 0; --i) {
                tmp += r[k - i + 1] * y[i];
            }
            alpha = -(r[k + 2] + tmp) / beta;
            int k2 = (1 + k) / 2;
            for (int i = 0; i < k2; ++i) {
                double yi = y[i];
                int n2 = i;
                y[n2] = y[n2] + alpha * y[k - i];
                int n3 = k - i;
                y[n3] = y[n3] + alpha * yi;
            }
            if (k % 2 == 0) {
                int n4 = k2;
                y[n4] = y[n4] * (1.0 + alpha);
            }
            y[k + 1] = alpha;
        }
        return y;
    }

    public static double[] solveLevinsonSystem(double[] r, double[] b) {
        int n = r.length - 1;
        double[] y = new double[n - 1];
        double[] x = new double[n];
        double alpha = -r[1] / r[0];
        double beta = r[0];
        y[0] = alpha;
        x[0] = b[0] / r[0];
        for (int k = 0; k < n - 1; ++k) {
            int i;
            beta *= 1.0 - alpha * alpha;
            double tmp = 0.0;
            for (int i2 = k; i2 >= 0; --i2) {
                tmp += r[k - i2 + 1] * x[i2];
            }
            double mu = (b[k + 1] - tmp) / beta;
            for (i = 0; i <= k; ++i) {
                int n2 = i;
                x[n2] = x[n2] + mu * y[k - i];
            }
            x[k + 1] = mu;
            if (k >= n - 2) continue;
            tmp = 0.0;
            for (i = k; i >= 0; --i) {
                tmp += r[k - i + 1] * y[i];
            }
            alpha = -(r[k + 2] + tmp) / beta;
            int k2 = (1 + k) / 2;
            for (int i3 = 0; i3 < k2; ++i3) {
                double yi = y[i3];
                int n3 = i3;
                y[n3] = y[n3] + alpha * y[k - i3];
                int n4 = k - i3;
                y[n4] = y[n4] + alpha * yi;
            }
            if (k % 2 == 0) {
                int n5 = k2;
                y[n5] = y[n5] * (1.0 + alpha);
            }
            y[k + 1] = alpha;
        }
        return x;
    }

    public ToeplitzMatrix(double[] r) {
        this.r = (double[])r.clone();
    }

    public FastMatrix asMatrix() {
        FastMatrix T2 = new FastMatrix(this.r.length, this.r.length);
        DataBlock diag = T2.diagonal();
        diag.set(this.r[0]);
        DataWindow ldiag = diag.window();
        DataWindow udiag = diag.window();
        for (int i = 1; i < this.r.length; ++i) {
            ldiag.slideAndShrink(1).set(this.r[i]);
            udiag.slideAndShrink(this.r.length).set(this.r[i]);
        }
        return T2;
    }

    public FastMatrix inverse() {
        int n = this.r.length;
        int nc = n - 1;
        FastMatrix m = new FastMatrix(n, n);
        double[] y = ToeplitzMatrix.solveDurbinSystem(this.r);
        double tmp = this.r[0];
        for (int i = 0; i < nc; ++i) {
            tmp += this.r[i + 1] * y[i];
        }
        double gamma = 1.0 / tmp;
        m.set(0, 0, gamma);
        m.set(nc, nc, gamma);
        for (int i = 0; i < nc; ++i) {
            int n2 = i;
            y[n2] = y[n2] * gamma;
            m.set(0, i + 1, y[i]);
            m.set(nc - i - 1, nc, y[i]);
        }
        Arrays2.reverse((double[])y);
        int imax = (n + 1) / 2;
        for (int i = 1; i < imax; ++i) {
            for (int j = i; j < n - i; ++j) {
                double x = m.get(i - 1, j - 1) + (y[nc - i] * y[nc - j] - y[i - 1] * y[j - 1]) / gamma;
                m.set(i, j, x);
                m.set(nc - j, nc - i, x);
            }
        }
        SymmetricMatrix.fromUpper(m);
        return m;
    }

    public void mul(DataBlock x) {
        int n = this.r.length;
        if (n == 1) {
            x.mul(0, this.r[0]);
        } else {
            int i;
            int q;
            int nc = 2 * n - 2;
            for (q = 2; q < nc; q <<= 1) {
            }
            Complex[] fx = new Complex[q];
            Complex[] fr2 = new Complex[q];
            for (i = 0; i < n; ++i) {
                fx[i] = Complex.cart((double)x.get(i));
                fr2[i] = Complex.cart((double)this.r[i]);
            }
            i = n - 2;
            int j = n;
            while (i > 0) {
                fr2[j] = Complex.cart((double)this.r[i]);
                --i;
                ++j;
            }
            FFT.transform(fx);
            FFT.transform(fr2);
            for (i = 0; i < q; ++i) {
                fx[i] = fx[i].times(fr2[i]);
            }
            FFT.backTransform(fx);
            for (i = 0; i < n; ++i) {
                x.set(i, fx[i].getRe());
            }
        }
    }
}

