/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Objects;
import java.util.function.Supplier;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.ToStringHelper;

public abstract class Feature {
    private PMMLEncoder encoder = null;
    private String name = null;
    private DataType dataType = null;

    public Feature(PMMLEncoder encoder, String name, DataType dataType) {
        this.setEncoder(encoder);
        this.setName(name);
        this.setDataType(dataType);
    }

    public abstract ContinuousFeature toContinuousFeature();

    public ContinuousFeature toContinuousFeature(DataType dataType) {
        ContinuousFeature continuousFeature = this.toContinuousFeature();
        if (dataType == continuousFeature.getDataType()) {
            return continuousFeature;
        }
        String name = FieldNameUtil.create(dataType, continuousFeature);
        return this.toContinuousFeature(name, dataType, continuousFeature::ref);
    }

    protected ContinuousFeature toContinuousFeature(String name, DataType dataType, Supplier<? extends Expression> expressionSupplier) {
        PMMLEncoder encoder = this.getEncoder();
        DerivedField derivedField = encoder.ensureDerivedField(name, OpType.CONTINUOUS, dataType, expressionSupplier);
        return new ContinuousFeature(encoder, (Field<?>)derivedField);
    }

    public FieldRef ref() {
        return new FieldRef(this.getName());
    }

    public Field<?> getField() {
        PMMLEncoder encoder = this.getEncoder();
        return encoder.getField(this.getName());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + Objects.hashCode(this.getEncoder());
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.getDataType());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Feature) {
            Feature that = (Feature)object;
            if (Objects.equals(this.getClass(), that.getClass())) {
                return Objects.equals(this.getEncoder(), that.getEncoder()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getDataType(), that.getDataType());
            }
        }
        return false;
    }

    public String toString() {
        ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected ToStringHelper toStringHelper() {
        return new ToStringHelper((Object)this).add("name", (Object)this.getName()).add("dataType", (Object)this.getDataType());
    }

    public PMMLEncoder getEncoder() {
        return this.encoder;
    }

    private void setEncoder(PMMLEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }
}

