## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(VizTest)
library(carData)
library(dplyr)
library(tidyr)

## -----------------------------------------------------------------------------
library(VizTest)
data(iris)
mod <- lm(Petal.Width ~ Species, data = iris) 
summary(mod)
v <- viztest(mod)
library(marginaleffects)
preds <- avg_predictions(mod, variables="Species", conf_level = .9999)
preds

data(esoph)
esoph$agegp <- as.factor(as.character(esoph$agegp))
esoph$tobgp <- factor(as.character(esoph$tobgp), levels=c("0-9g/day", "10-19", "20-29", "30+"))
esoph$alcgp <- factor(as.character(esoph$alcgp), levels=c("0-39g/day", "40-79", "80-119", "120+"))

model1 <- glm(cbind(ncases, ncontrols) ~ agegp + tobgp + alcgp,
              data = esoph, family = binomial())
preds <- avg_predictions(model1, variables = "tobgp")

## -----------------------------------------------------------------------------
ests <- preds$estimate
names(ests) <- preds$tobgp

## -----------------------------------------------------------------------------
tmpl <- make_diff_template(ests, include_intercept = FALSE, include_zero = FALSE)
tmpl

## -----------------------------------------------------------------------------
diff <- c(1,1,1, 0, 0,0)

## -----------------------------------------------------------------------------
tmpl$sig <- diff
tmpl

## -----------------------------------------------------------------------------
viztest(preds, include_zero=FALSE, include_intercept = FALSE, sig_diffs = diff,range_levels = c(.25, .999))

## -----------------------------------------------------------------------------
viztest(preds, include_zero=FALSE, include_intercept = FALSE)

