## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(typeR)

## -----------------------------------------------------------------------------
# # Basic usage
# typeRun("my-demo.qmd")
# 
# # With custom settings
# typeRun("my-demo.qmd", delay = 0.08, jitter = 0.02)

## ----examples-----------------------------------------------------------------
# # Find the example file
# demo_file <- system.file("examples/demo-presentation.qmd", package = "typeR")
# 
# # Run it
# typeRun(demo_file)
# 
# # Or the simpler version
# simple_file <- system.file("examples/simple-presentation.qmd",
#                            package = "typeR")
# typeRun(simple_file, delay = 0.05)

## ----speed--------------------------------------------------------------------
# # Slower for readability
# typeRun("presentation.qmd", delay = 0.10, jitter = 0.03)
# 
# # Very slow for teaching
# typeRun("presentation.qmd", delay = 0.15, jitter = 0.05)
# 
# # Fast for quick demos
# typeRun("presentation.qmd", delay = 0.03, jitter = 0.01)

## ----output-------------------------------------------------------------------
# # Limit to 5 lines
# typeRun("presentation.qmd", max_print = 5)
# 
# # Show more for detailed examples
# typeRun("presentation.qmd", max_print = 15)

## ----pause, eval=FALSE--------------------------------------------------------
# typeRun("presentation.qmd")
# # Press ESC to pause
# # Enter 1 to resume
# # Enter 2 to stop

## ----test---------------------------------------------------------------------
# # Full test run
# typeRun("my-talk.qmd", delay = 0.05)
# 
# # Check for errors or unexpected output

## ----practice-----------------------------------------------------------------
# # Save the above as "data-analysis.qmd"
# typeRun("data-analysis.qmd", delay = 0.06, max_print = 8)

## ----env----------------------------------------------------------------------
# # Create isolated environment
# demo_env <- new.env()
# 
# # Run presentation in that environment
# typeRun("presentation.qmd", envir = demo_env)
# 
# # Your global environment remains clean
# ls()  # Nothing added here
# ls(demo_env)  # All demo objects here

## ----multiple-----------------------------------------------------------------
# # Run a series of short demos
# demos <- c("intro.qmd", "advanced.qmd", "qa.qmd")
# 
# for (demo in demos) {
#   cat("\n\n=== Starting:", demo, "===\n\n")
#   typeRun(demo, delay = 0.06)
#   cat("\n\n=== Finished:", demo, "===\n\n")
# }

## -----------------------------------------------------------------------------
# typeRun("presentation.qmd", delay = 0.12)

## -----------------------------------------------------------------------------
# typeRun("presentation.qmd", max_print = 5)

## -----------------------------------------------------------------------------
# # Test graphics device
# plot(1:10)  # Should work before starting typeRun

## ----teaching-----------------------------------------------------------------
# # Week 1: Basics
# typeRun("week1-intro.qmd", delay = 0.10)
# 
# # Week 2: Data manipulation
# typeRun("week2-dplyr.qmd", delay = 0.08)
# 
# # Week 3: Visualization
# typeRun("week3-ggplot.qmd", delay = 0.08)

## ----conference---------------------------------------------------------------
# # 20-minute presentation
# typeRun("conference-talk.qmd",
#         delay = 0.06,     # Fast enough to keep pace
#         max_print = 6)    # Brief outputs

## ----workshop-----------------------------------------------------------------
# # Interactive 2-hour workshop
# typeRun("workshop-morning.qmd",
#         delay = 0.09,      # Slower for learning
#         max_print = 8)
# 
# # Break, then afternoon session
# typeRun("workshop-afternoon.qmd",
#         delay = 0.09,
#         max_print = 8)

