/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixWindow;
import jdplus.toolkit.base.core.math.matrices.decomposition.QRDecomposition;
import jdplus.toolkit.base.core.math.matrices.decomposition.Reflector;

public class HouseholderWithPivoting {
    private double[] qr;
    private double[] beta;
    private int m;
    private int n;
    private int nfixed;
    private int[] pivot;

    public QRDecomposition decompose(FastMatrix A, int nfixed) {
        this.init(A, nfixed);
        this.householder();
        return new QRDecomposition(FastMatrix.builder(this.qr).nrows(this.m).ncolumns(this.n).build(), this.beta, this.pivot);
    }

    private void householder() {
        int k = Math.min(this.m, this.nfixed);
        Reflector hous = new Reflector(this.qr);
        FastMatrix M = FastMatrix.builder(this.qr).nrows(this.m).ncolumns(this.n).build();
        MatrixWindow wnd = M.all();
        int j = 0;
        int i = 0;
        while (i < k) {
            hous.set(j, this.m - i);
            hous.larfg();
            int nc = this.n - i - 1;
            if (nc > 0) {
                FastMatrix m = wnd.bhshrink();
                if (hous.beta != 0.0) {
                    hous.lapply(m);
                }
            }
            this.beta[i] = hous.beta;
            this.qr[j] = hous.alpha;
            wnd.bvshrink();
            ++i;
            j += this.m + 1;
        }
        if (this.nfixed == this.n) {
            return;
        }
        k = Math.min(this.m, this.n);
        double[] norm = new double[k];
        double[] pnorm = new double[k];
        this.pivot = new int[k];
        for (int i2 = 0; i2 < k; ++i2) {
            this.pivot[i2] = i2;
        }
        DataPointer c = DataPointer.of(this.qr, j);
        for (int i3 = this.nfixed; i3 < k; ++i3) {
            double nrm;
            norm[i3] = nrm = c.fastNorm2(this.m - this.nfixed);
            pnorm[i3] = nrm;
            c.move(this.m);
        }
        double tol = Math.sqrt(Constants.getEpsilon());
        int i4 = this.nfixed;
        while (i4 < k) {
            int icur = i4;
            for (int l = i4 + 1; l < k; ++l) {
                if (!(pnorm[l] > pnorm[icur])) continue;
                icur = l;
            }
            if (icur != i4) {
                this.swapColumns(i4, icur);
                pnorm[icur] = pnorm[i4];
                norm[icur] = norm[i4];
            }
            hous.set(j, this.m - i4);
            hous.larfg();
            int nc = this.n - i4 - 1;
            if (nc > 0) {
                FastMatrix fm = wnd.bhshrink();
                if (hous.beta != 0.0) {
                    hous.lapply(fm);
                }
            }
            this.beta[i4] = hous.beta;
            this.qr[j] = hous.alpha;
            wnd.bvshrink();
            int l = i4 + 1;
            int j0 = j + this.m;
            while (l < k) {
                if (pnorm[l] != 0.0) {
                    double rnorm;
                    double tmp = this.qr[j0] / pnorm[l];
                    double tmp2 = (tmp = Math.max(1.0 - tmp * tmp, 0.0)) * (rnorm = pnorm[l] / norm[l]) * rnorm;
                    if (tmp2 <= tol) {
                        double nrm;
                        c.pos(j0 + 1);
                        norm[l] = pnorm[l] = (nrm = c.fastNorm2(this.m - i4 - 1));
                    } else {
                        int n = l;
                        pnorm[n] = pnorm[n] * Math.sqrt(tmp);
                    }
                }
                ++l;
                j0 += this.m;
            }
            ++i4;
            j += this.m + 1;
        }
    }

    private void init(FastMatrix M, int nfixed) {
        this.m = M.getRowsCount();
        this.n = M.getColumnsCount();
        this.nfixed = nfixed;
        this.qr = M.toArray();
        this.beta = new double[this.n];
    }

    private void swapColumns(int i, int j) {
        int ri = i * this.m;
        int rimax = ri + this.m;
        int rj = j * this.m;
        while (ri < rimax) {
            double tmp = this.qr[ri];
            this.qr[ri] = this.qr[rj];
            this.qr[rj] = tmp;
            ++ri;
            ++rj;
        }
        int tmp = this.pivot[j];
        this.pivot[j] = this.pivot[i];
        this.pivot[i] = tmp;
    }
}

