/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api;

import jdplus.sa.base.api.ComponentType;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class SaSeriesInfo
implements Comparable<SaSeriesInfo> {
    private static final String EMPTY = "";
    @NonNull
    private final String name;
    @NonNull
    private final ComponentType component;
    @NonNull
    private final ComponentInformation info;
    @NonNull
    public final String description;
    public static final String F_SUFFIX = "_f";
    public static final String E_SUFFIX = "_e";
    public static final String EF_SUFFIX = "_ef";
    public static final String B_SUFFIX = "_b";

    public SaSeriesInfo(String name, ComponentType type) {
        this(name, type, ComponentInformation.Value, EMPTY);
    }

    @Override
    public int compareTo(SaSeriesInfo o) {
        if (this == o) {
            return 0;
        }
        int cmp = this.name.compareTo(o.name);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.component.compareTo(o.component);
        if (cmp != 0) {
            return cmp;
        }
        return this.info.compareTo((Enum)o.info);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.description != null && this.description.length() > 0) {
            builder.append(this.description);
        } else {
            builder.append(this.name);
        }
        if (this.info == ComponentInformation.Value || this.info == ComponentInformation.Undefined) {
            return builder.toString();
        }
        builder.append(" (");
        if (null != this.info) {
            switch (this.info) {
                case Forecast: {
                    builder.append("forecasts)");
                    break;
                }
                case Stdev: {
                    builder.append("std error)");
                    break;
                }
                case StdevForecast: {
                    builder.append("forecast errors)");
                    break;
                }
            }
        }
        return builder.toString();
    }

    public String getCode() {
        if (this.info == ComponentInformation.Undefined || this.info == ComponentInformation.Value) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        switch (this.info) {
            case Forecast: {
                builder.append(F_SUFFIX);
                break;
            }
            case Stdev: {
                builder.append(E_SUFFIX);
                break;
            }
            case StdevForecast: {
                builder.append(EF_SUFFIX);
            }
        }
        return builder.toString();
    }

    public static SaSeriesInfo split(String code) {
        int len = code.length();
        if (SaSeriesInfo.hasSuffix(code, F_SUFFIX)) {
            return new SaSeriesInfo(code.substring(0, len - 2), ComponentType.Undefined, ComponentInformation.Forecast, EMPTY);
        }
        if (SaSeriesInfo.hasSuffix(code, E_SUFFIX)) {
            return new SaSeriesInfo(code.substring(0, len - 2), ComponentType.Undefined, ComponentInformation.Stdev, EMPTY);
        }
        if (SaSeriesInfo.hasSuffix(code, EF_SUFFIX)) {
            return new SaSeriesInfo(code.substring(0, len - 3), ComponentType.Undefined, ComponentInformation.StdevForecast, EMPTY);
        }
        return new SaSeriesInfo(code, ComponentType.Undefined);
    }

    private static boolean hasSuffix(String s, String suffix) {
        int slen;
        int len = s.length();
        if (len <= (slen = suffix.length())) {
            return false;
        }
        int i = len - slen;
        for (int j = 0; j < slen; ++j) {
            if (s.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public ComponentType getComponent() {
        return this.component;
    }

    @NonNull
    @Generated
    public ComponentInformation getInfo() {
        return this.info;
    }

    @NonNull
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaSeriesInfo)) {
            return false;
        }
        SaSeriesInfo other = (SaSeriesInfo)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ComponentType this$component = this.getComponent();
        ComponentType other$component = other.getComponent();
        if (this$component == null ? other$component != null : !((Object)((Object)this$component)).equals((Object)other$component)) {
            return false;
        }
        ComponentInformation this$info = this.getInfo();
        ComponentInformation other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ComponentType $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)((Object)$component)).hashCode());
        ComponentInformation $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public SaSeriesInfo(@NonNull String name, @NonNull ComponentType component, @NonNull ComponentInformation info, @NonNull String description) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.name = name;
        this.component = component;
        this.info = info;
        this.description = description;
    }
}

