/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api.legacy;

import jdplus.toolkit.base.api.design.DemetraPlusLegacy;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@DemetraPlusLegacy
final class LegacySpreadSheetId {
    private static final String BSEP = "<<";
    private static final String ESEP = ">>";
    @NonNull
    private final String file;
    @NonNull
    private final String sheetName;
    private final String seriesName;
    private final int indexSeries;

    @NonNull
    public static LegacySpreadSheetId collection(String file, String name) {
        return new LegacySpreadSheetId(file, name, null, -1);
    }

    @NonNull
    public static LegacySpreadSheetId series(String file, String sheetName, int spos) {
        return new LegacySpreadSheetId(file, sheetName, null, spos);
    }

    @NonNull
    public static LegacySpreadSheetId series(String file, String sheetName, String sname) {
        return new LegacySpreadSheetId(file, sheetName, sname, -1);
    }

    public static @Nullable LegacySpreadSheetId parse(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        int beg = input.indexOf(BSEP);
        if (beg != 0) {
            return null;
        }
        int end = input.indexOf(ESEP, beg += BSEP.length());
        if (end < 0) {
            return null;
        }
        String fname = input.substring(beg, end);
        beg = end + ESEP.length();
        if ((beg = input.indexOf(BSEP, beg)) < 0) {
            return null;
        }
        end = input.indexOf(ESEP, beg += BSEP.length());
        if (end < 0) {
            return null;
        }
        String sheetname = input.substring(beg, end);
        beg = end + ESEP.length();
        if (beg < input.length()) {
            if ((beg = input.indexOf(BSEP, beg)) < 0) {
                return null;
            }
            end = input.indexOf(ESEP, beg += BSEP.length());
            if (end < 0) {
                return null;
            }
            String s = input.substring(beg, end);
            try {
                short sid = Short.parseShort(s);
                return LegacySpreadSheetId.series(fname, sheetname, sid);
            }
            catch (NumberFormatException numberFormatException) {
                return LegacySpreadSheetId.series(fname, sheetname, s);
            }
        }
        return LegacySpreadSheetId.collection(fname, sheetname);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(BSEP).append(this.file).append(ESEP).append(BSEP).append(this.sheetName).append(ESEP);
        if (this.isSeries()) {
            if (this.indexSeries >= 0) {
                builder.append(BSEP).append(this.indexSeries).append(ESEP);
            } else {
                builder.append(BSEP).append(this.seriesName).append(ESEP);
            }
        }
        return builder.toString();
    }

    public boolean isCollection() {
        return -1 == this.indexSeries && this.seriesName == null;
    }

    public boolean isSeries() {
        return this.indexSeries >= 0 || this.seriesName != null;
    }

    public boolean isSeriesByIndex() {
        return this.indexSeries >= 0;
    }

    @Generated
    public LegacySpreadSheetId(@NonNull String file, @NonNull String sheetName, String seriesName, int indexSeries) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.file = file;
        this.sheetName = sheetName;
        this.seriesName = seriesName;
        this.indexSeries = indexSeries;
    }

    @NonNull
    @Generated
    public String getFile() {
        return this.file;
    }

    @NonNull
    @Generated
    public String getSheetName() {
        return this.sheetName;
    }

    @Generated
    public String getSeriesName() {
        return this.seriesName;
    }

    @Generated
    public int getIndexSeries() {
        return this.indexSeries;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LegacySpreadSheetId)) {
            return false;
        }
        LegacySpreadSheetId other = (LegacySpreadSheetId)o;
        if (this.getIndexSeries() != other.getIndexSeries()) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$sheetName = this.getSheetName();
        String other$sheetName = other.getSheetName();
        if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
            return false;
        }
        String this$seriesName = this.getSeriesName();
        String other$seriesName = other.getSeriesName();
        return !(this$seriesName == null ? other$seriesName != null : !this$seriesName.equals(other$seriesName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndexSeries();
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $sheetName = this.getSheetName();
        result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
        String $seriesName = this.getSeriesName();
        result = result * 59 + ($seriesName == null ? 43 : $seriesName.hashCode());
        return result;
    }
}

