# Example usage of Quant ES
# This example loads the included demo dataset, constructs the evidence matrix,
# runs the Quant ES core transform, and produces plots.

library(quantES)
library(tidyverse)

# Load bundled demo data
data(core_test_data)

# Build 0/1 evidence matrix from the demo table
# Assumes column 1 is the variant identifier
x <- as.matrix(core_test_data[, -1])
rownames(x) <- core_test_data[[1]]

# Run Quant ES core
res <- quant_es_core(x)

# Inspect results
res$global
head(res$variants)

# Generate default plots
plots <- quant_es_plots(res, x)

plots$p_overlay
plots$p_global
plots$p_matrix
plots$p_p_hat
plots$p_theta_ci
plots$p_combined

# Optional: highlight specific variants with user provided colours and sizes
plots2 <- quant_es_plots(
  res,
  x,
  highlight_points = list(
    list(id = "X-119469998-CT-C_XR", colour = "#ee4035", size = 4),
    list(id = res$variants$variant_id[1], colour = "#2f4356", size = 4)
  )
)

plots2$p_overlay

