/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jdplus.sa.base.api.SaVariable;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.modelling.regression.PeriodicOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.TransitoryChangeFactory;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.outlier.ExactSingleOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.regsarima.ami.ExactOutliersDetector;
import jdplus.toolkit.base.core.regsarima.regular.IOutliersDetectionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;
import jdplus.x13.base.core.x13.regarima.X13Utility;

public class OutliersDetectionModule
implements IOutliersDetectionModule {
    public static int DEF_MAXROUND = 50;
    public static int DEF_MAXOUTLIERS = 30;
    public static final double EPS = 1.0E-7;
    public static final double TCRATE = 0.7;
    private final double eps;
    private final int maxOutliers;
    private final int maxRound;
    private final boolean ao;
    private final boolean ls;
    private final boolean tc;
    private final boolean so;
    private final double tcrate;
    private final TimeSelector span;

    public static Builder builder() {
        return new Builder();
    }

    private OutliersDetectionModule(Builder builder) {
        this.eps = builder.eps;
        this.maxOutliers = builder.maxOutliers;
        this.maxRound = builder.maxRound;
        this.ao = builder.ao;
        this.ls = builder.ls;
        this.tc = builder.tc;
        this.so = builder.so;
        this.tcrate = builder.tcrate;
        this.span = builder.span;
    }

    private SingleOutlierDetector<SarimaModel> factories(int freq) {
        ExactSingleOutlierDetector sod = new ExactSingleOutlierDetector(RobustStandardDeviationComputer.mad((boolean)false), null, X13Utility.mlComputer());
        ArrayList<Object> factory = new ArrayList<Object>();
        if (this.ao) {
            factory.add(AdditiveOutlierFactory.FACTORY);
        }
        if (this.ls) {
            factory.add(LevelShiftFactory.FACTORY_ZEROENDED);
        }
        if (this.tc) {
            double c = TransitoryChangeFactory.rate((int)freq, (double)this.tcrate);
            factory.add(new TransitoryChangeFactory(c));
        }
        if (freq > 1 && this.so) {
            factory.add(new PeriodicOutlierFactory(freq, true));
        }
        sod.setOutlierFactories((IOutlierFactory[])factory.toArray(IOutlierFactory[]::new));
        return sod;
    }

    private ExactOutliersDetector make(ModelDescription desc, double cv) {
        TsDomain domain = desc.getEstimationDomain();
        ExactOutliersDetector impl = ExactOutliersDetector.builder().singleOutlierDetector(this.factories(domain.getAnnualFrequency())).criticalValue(cv).maxOutliers(this.maxOutliers).maxRound(this.maxRound).processor(RegArimaUtility.processor((boolean)true, (double)this.eps)).build();
        TsDomain odom = domain.select(this.span);
        int start = domain.indexOf(odom.getStartPeriod());
        int end = start + odom.getLength();
        impl.prepare(domain.getLength());
        impl.setBounds(start, end);
        String[] types = impl.outlierTypes();
        int[] missing = desc.getMissingInEstimationDomain();
        if (missing != null) {
            for (int i = 0; i < missing.length; ++i) {
                for (int j = 0; j < types.length; ++j) {
                    impl.exclude(missing[i], j);
                }
            }
        }
        desc.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)false)).map(var -> (IOutlier)var.getCore()).forEach(o -> impl.exclude(domain.indexOf(o.getPosition()), OutliersDetectionModule.outlierType(types, o.getCode())));
        desc.variables().filter(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true)).map(var -> (IOutlier)var.getCore()).forEach(o -> impl.addOutlier(domain.indexOf(o.getPosition()), OutliersDetectionModule.outlierType(types, o.getCode())));
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context, double criticalValue) {
        ProcessingLog log = context.getLog();
        log.push("outliers selection");
        try {
            ModelDescription model = context.getDescription();
            TsDomain domain = model.getEstimationDomain();
            ExactOutliersDetector impl = this.make(model, criticalValue);
            boolean changed = impl.process(model.regarima(), model.mapping());
            int[][] outliers = impl.getOutliers();
            log.info((String)(switch (outliers.length) {
                case 0 -> "no outlier selected";
                case 1 -> " outlier selected";
                default -> outliers.length + " outliers selected";
            }), (Object)new IOutliersDetectionModule.Info(impl.outlierTypes(), outliers, criticalValue));
            if (!changed) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            model.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
            for (int i = 0; i < outliers.length; ++i) {
                int[] cur = outliers[i];
                TsPeriod pos = domain.get(cur[0]);
                IOutlier o = impl.getFactory(cur[1]).make(pos.start());
                model.addVariable(Variable.variable((String)IOutlier.defaultName((String)o.getCode(), (TsPeriod)pos), (ITsVariable)o, OutliersDetectionModule.attributes(o)));
            }
            context.clearEstimation();
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        catch (RuntimeException err) {
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    static Map<String, String> attributes(IOutlier o) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ami", "x13");
        attributes.put("regeffect", SaVariable.defaultComponentTypeOf((IOutlier)o).name());
        return attributes;
    }

    private static int outlierType(String[] all, String cur) {
        for (int i = 0; i < all.length; ++i) {
            if (!cur.equals(all[i])) continue;
            return i;
        }
        return -1;
    }

    public static class Builder {
        private double eps = 1.0E-7;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private boolean ao;
        private boolean ls;
        private boolean tc;
        private boolean so;
        private double tcrate = 0.7;
        private TimeSelector span = TimeSelector.all();

        private Builder() {
        }

        public Builder span(TimeSelector span) {
            this.span = span;
            return this;
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder tcrate(double tcrate) {
            this.tcrate = tcrate;
            return this;
        }

        public Builder ao(boolean ao) {
            this.ao = ao;
            return this;
        }

        public Builder ls(boolean ls) {
            this.ls = ls;
            return this;
        }

        public Builder tc(boolean tc) {
            this.tc = tc;
            return this;
        }

        public Builder so(boolean so) {
            this.so = so;
            return this;
        }

        public Builder maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public OutliersDetectionModule build() {
            return new OutliersDetectionModule(this);
        }
    }
}

