/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.calendar;

import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.calendars.Calendar;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.Easter;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.GenericTradingDaysFactory;
import jdplus.toolkit.base.core.timeseries.calendars.HolidaysUtility;
import jdplus.toolkit.base.protobuf.toolkit.CalendarProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import lombok.Generated;

public final class Calendars {
    public static byte[] calendarToBuffer(Calendar calendar) {
        return CalendarProtosUtility.convert((Calendar)calendar).toByteArray();
    }

    public static Calendar calendarOf(byte[] buffer) {
        try {
            ToolkitProtos.Calendar cal = ToolkitProtos.Calendar.parseFrom((byte[])buffer);
            return CalendarProtosUtility.convert((ToolkitProtos.Calendar)cal);
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    public static String[] easter(int y0, int y1, boolean julian) {
        String[] rslt = new String[y1 - y0 + 1];
        int y = y0;
        int i = 0;
        while (y <= y1) {
            LocalDate e = julian ? Easter.julianEaster((int)y, (boolean)true) : Easter.easter((int)y);
            rslt[i] = e.format(DateTimeFormatter.ISO_DATE);
            ++y;
            ++i;
        }
        return rslt;
    }

    public static Matrix longTermMean(Calendar calendar, int period, int holiday) {
        Object ltm = calendar != null ? (Object)HolidaysUtility.longTermMean((Holiday[])calendar.getHolidays(), (int)period) : new double[period][];
        double[] means = GenericTradingDaysFactory.meanDays((int)period);
        FastMatrix M = FastMatrix.make((int)period, (int)7);
        for (int i = 0; i < period; ++i) {
            DataBlock row = M.row(i);
            row.set(means[i]);
            if (ltm[i] == null) continue;
            DataBlock C = DataBlock.of((double[])ltm[i]);
            row.sub(C);
            row.add(holiday - 1, C.sum());
        }
        return M.unmodifiable();
    }

    public static Matrix longTermMean(Calendar calendar, int period, int[] groups, int holiday) {
        DayClustering dc = DayClustering.of((int[])groups);
        FastMatrix M = FastMatrix.make((int)period, (int)dc.getGroupsCount());
        Matrix m = Calendars.longTermMean(calendar, period, holiday);
        for (int i = 0; i < M.getColumnsCount(); ++i) {
            DataBlock col = M.column(i);
            for (int j = 0; j < 7; ++j) {
                if (groups[j] != i) continue;
                col.add(m.column(j));
            }
        }
        return M.unmodifiable();
    }

    public static Matrix holidays(Calendar calendar, String date, int length, int[] nonworking, String type, boolean single) {
        LocalDate start = LocalDate.parse(date);
        Holiday[] elements = calendar.getHolidays();
        FastMatrix m = single ? FastMatrix.make((int)length, (int)1) : FastMatrix.make((int)length, (int)elements.length);
        switch (type) {
            case "Skip": {
                HolidaysUtility.fillDays((Holiday[])elements, (FastMatrix)m, (LocalDate)start, (int[])nonworking, (boolean)true);
                break;
            }
            case "NextWorkingDay": {
                HolidaysUtility.fillNextWorkingDays((Holiday[])elements, (FastMatrix)m, (LocalDate)start, (int[])nonworking);
                break;
            }
            case "PreviousWorkingDay": {
                HolidaysUtility.fillPreviousWorkingDays((Holiday[])elements, (FastMatrix)m, (LocalDate)start, (int[])nonworking);
                break;
            }
            default: {
                HolidaysUtility.fillDays((Holiday[])elements, (FastMatrix)m, (LocalDate)start, (int[])nonworking, (boolean)false);
            }
        }
        return m.unmodifiable();
    }

    @Generated
    private Calendars() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

