/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class LjungBox {
    private int lag = 1;
    private int k = 12;
    private int nhp;
    private int sign;
    private final IntToDoubleFunction autoCorrelations;
    private final int n;

    public static int defaultAutoCorrelationsCount(int period) {
        if (period >= 12) {
            return 2 * period;
        }
        if (period == 1) {
            return 8;
        }
        return 4 * period;
    }

    public static int defaultAutoCorrelationsCount(int period, int nobs) {
        int lbdf;
        switch (period) {
            case 12: {
                lbdf = 24;
                break;
            }
            case 1: {
                lbdf = 8;
                break;
            }
            default: {
                lbdf = 4 * period;
                if (nobs > 22 || period != 4) break;
                lbdf = 6;
            }
        }
        if (lbdf >= nobs) {
            lbdf = nobs / 2;
        }
        return lbdf;
    }

    public LjungBox(DoubleSeq sample) {
        this(sample, false);
    }

    public LjungBox(DoubleSeq sample, boolean correctForMean) {
        if (correctForMean) {
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)sample, (double)sample.average());
            this.n = sample.length() - 1;
        } else {
            this.autoCorrelations = AutoCovariances.autoCorrelationFunction((DoubleSeq)sample, (double)0.0);
            this.n = sample.length();
        }
    }

    public LjungBox(IntToDoubleFunction autoCorrelations, int sampleSize) {
        this.autoCorrelations = autoCorrelations;
        this.n = sampleSize;
    }

    public LjungBox hyperParametersCount(int nhp) {
        this.nhp = nhp;
        return this;
    }

    public LjungBox lag(int lag) {
        this.lag = lag;
        return this;
    }

    public LjungBox autoCorrelationsCount(int k) {
        this.k = k;
        return this;
    }

    public LjungBox usePositiveAutoCorrelations() {
        this.sign = 1;
        return this;
    }

    public LjungBox useNegativeAutoCorrelations() {
        this.sign = -1;
        return this;
    }

    public LjungBox useAllAutoCorrelations() {
        this.sign = 0;
        return this;
    }

    public LjungBox sign(int s) {
        this.sign = s;
        return this;
    }

    private double value() {
        double res = 0.0;
        for (int i = 1; i <= this.k; ++i) {
            double ai = this.autoCorrelations.applyAsDouble(i * this.lag);
            if (this.sign == 0 || this.sign == 1 && ai > 0.0 || this.sign == -1 && ai < 0.0) {
                res += ai * ai / (double)(this.n - i * this.lag);
                continue;
            }
            if (i != 1) continue;
            return 0.0;
        }
        return res;
    }

    public StatisticalTest build() {
        double res = this.value();
        double val = res * (double)this.n * (double)(this.n + 2);
        Chi2 chi = new Chi2(this.lag == 1 ? (double)(this.k - this.nhp) : (double)this.k);
        return TestsUtility.testOf(val, chi, TestType.Upper);
    }
}

