/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.matrices;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.advanced.matrices.MatrixDecompositions;

public final class MatrixDecompositionsLoader {

    public static final class Processor {
        private final Iterable<MatrixDecompositions.Processor> source = ServiceLoader.load(MatrixDecompositions.Processor.class);
        private final AtomicReference<MatrixDecompositions.Processor> resource = new AtomicReference<MatrixDecompositions.Processor>(this.doLoad());
        private final Consumer<Iterable> cleaner = loader -> ((ServiceLoader)loader).reload();

        private MatrixDecompositions.Processor doLoad() throws IllegalStateException {
            return StreamSupport.stream(this.source.spliterator(), false).findFirst().orElseThrow(() -> new IllegalStateException("Missing mandatory provider of MatrixDecompositions.Processor"));
        }

        public MatrixDecompositions.Processor get() {
            return this.resource.get();
        }

        public void set(MatrixDecompositions.Processor newValue) {
            this.resource.set(Objects.requireNonNull(newValue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reload() throws IllegalStateException {
            Iterable<MatrixDecompositions.Processor> iterable = this.source;
            synchronized (iterable) {
                this.cleaner.accept(this.source);
                this.set(this.doLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() throws IllegalStateException {
            Iterable<MatrixDecompositions.Processor> iterable = this.source;
            synchronized (iterable) {
                this.set(this.doLoad());
            }
        }
    }
}

