/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class DataSourcePreconditions {
    @NonNull
    public static DataSource checkProvider(@NonNull String providerName, @NonNull DataSource dataSource) throws IllegalArgumentException {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(providerName, dataSource.getProviderName());
        return dataSource;
    }

    @NonNull
    public static DataSet checkProvider(@NonNull String providerName, @NonNull DataSet dataSet) throws IllegalArgumentException {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(providerName, dataSet.getDataSource().getProviderName());
        return dataSet;
    }

    @NonNull
    public static TsMoniker checkProvider(@NonNull String providerName, @NonNull TsMoniker moniker) throws IllegalArgumentException {
        if (providerName == null) {
            throw new NullPointerException("providerName is marked non-null but is null");
        }
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider(providerName, moniker.getSource());
        return moniker;
    }

    private static void checkProvider(@NonNull String expected, @Nullable String found) throws IllegalArgumentException {
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (!expected.equals(found)) {
            throw new IllegalArgumentException("Invalid provider name; expected: '" + expected + "' found: '" + found + "'");
        }
    }

    @Generated
    private DataSourcePreconditions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

