/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api;

import internal.spreadsheet.base.api.SpreadSheetConnection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.tsp.util.ShortLivedCache;
import jdplus.toolkit.base.tsp.util.ShortLivedCaching;
import lombok.Generated;
import lombok.NonNull;

public final class CachedSpreadSheetConnection
implements SpreadSheetConnection {
    @NonNull
    private final SpreadSheetConnection delegate;
    @NonNull
    private final ShortLivedCache<String, List<TsCollection>> cache;

    @NonNull
    public static CachedSpreadSheetConnection of(@NonNull SpreadSheetConnection delegate, @NonNull File target, @NonNull ShortLivedCaching cacheFactory) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked non-null but is null");
        }
        return new CachedSpreadSheetConnection(delegate, (ShortLivedCache<String, List<TsCollection>>)cacheFactory.ofFile(target));
    }

    @Override
    @NonNull
    public Optional<TsCollection> getSheetByName(@NonNull String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        List<TsCollection> all = this.peekAll();
        if (all != null) {
            return all.stream().filter(collection -> collection.getName().equals(name)).findFirst();
        }
        String key = "getSheetByName/" + name;
        List cachedValue = (List)this.cache.get((Object)key);
        if (cachedValue == null) {
            Optional<TsCollection> result = this.delegate.getSheetByName(name);
            this.cache.put((Object)key, result.stream().toList());
            return result;
        }
        return cachedValue.stream().findFirst();
    }

    @Override
    @NonNull
    public List<String> getSheetNames() throws IOException {
        List<TsCollection> all = this.peekAll();
        if (all != null) {
            return all.stream().map(TsCollection::getName).toList();
        }
        String key = "getSheetNames";
        List cachedValue = (List)this.cache.get((Object)key);
        if (cachedValue == null) {
            List<String> result = this.delegate.getSheetNames();
            this.cache.put((Object)key, result.stream().map(TsCollection::ofName).toList());
            return result;
        }
        return cachedValue.stream().map(TsCollection::getName).toList();
    }

    @Override
    @NonNull
    public List<TsCollection> getSheets() throws IOException {
        String key = "getSheets";
        List<TsCollection> cachedValue = (List<TsCollection>)this.cache.get((Object)key);
        if (cachedValue == null) {
            cachedValue = this.delegate.getSheets();
            this.cache.put((Object)key, cachedValue);
        }
        return cachedValue;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private List<TsCollection> peekAll() {
        return (List)this.cache.get((Object)"getSheets");
    }

    @Generated
    CachedSpreadSheetConnection(@NonNull SpreadSheetConnection delegate, @NonNull ShortLivedCache<String, List<TsCollection>> cache) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (cache == null) {
            throw new NullPointerException("cache is marked non-null but is null");
        }
        this.delegate = delegate;
        this.cache = cache;
    }
}

