/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

public class XmlEscapeHelper {
    public static String escape(String text) {
        int codePoint;
        StringBuilder sb = new StringBuilder();
        for (int offset = 0; offset < text.length(); offset += Character.charCount(codePoint)) {
            codePoint = text.codePointAt(offset);
            sb.append(XmlEscapeHelper.escape(codePoint));
        }
        return sb.toString();
    }

    private static String escape(int c) {
        if (!(c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF)) {
            return "";
        }
        switch (c) {
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
            case 38: {
                return "&amp;";
            }
            case 39: {
                return "&apos;";
            }
            case 34: {
                return "&quot;";
            }
        }
        if (c > 126 || c < 32) {
            return "&#x".concat(Integer.toHexString(c)).concat(";");
        }
        return String.valueOf((char)c);
    }
}

