/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.nbbrd.io.text.BaseProperty;
import standalone_spreadsheet.nbbrd.io.text.Formatter;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public final class DoubleProperty
extends BaseProperty {
    @NonNull
    private final String key;
    private final double defaultValue;

    public double get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Double result = Parser.onDouble().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public double get(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::getProperty);
    }

    public double get(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, double value) {
        String valueAsString;
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (value != this.defaultValue && (valueAsString = Formatter.onDouble().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, double value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, double value) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.set(properties::put, value);
    }

    @Generated
    private DoubleProperty(@NonNull String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull DoubleProperty of(@NonNull String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new DoubleProperty(key, defaultValue);
    }

    @Override
    @NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public double getDefaultValue() {
        return this.defaultValue;
    }
}

