## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----define-------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
sdtmdata <- repfun::ru_libname(datdir)

## ----getdata------------------------------------------------------------------
sdtm.dm <- sdtmdata$dm()
sdtm.suppdm <- sdtmdata$suppdm()

## ----showsupp-----------------------------------------------------------------
sdtm.suppdm %>% distinct(QNAM,QLABEL) -> usupp
knitr::kable(usupp, caption = "Supplemental Variables to be Added")

## ----addsupp------------------------------------------------------------------
suppae <- repfun::ru_addsupp(dsetin=sdtm.dm,dsetinsupp=sdtm.suppdm)

## ----results------------------------------------------------------------------
lbls <- sapply(suppae,function(x){attr(x,"label")})
knitr::kable(head(suppae,10), col.names=paste(names(lbls),lbls,sep=" "), 
             caption = "Add Supplemental Data to DM Domain")

